#include "mbed.h"
#include "FastPWM.h"    
#include "MODSERIAL.h"
#include "QEI.h"
#include "HIDScope.h"
#include <math.h>
MODSERIAL pc(USBTX, USBRX);
DigitalOut motor1DirectionPin(D7);
FastPWM motor1MagnitudePin(D6); 
AnalogIn potMeter1(A4);
AnalogIn potMeter2(A5);
InterruptIn button2(D3);
DigitalOut led(LED1);
QEI Encoder (D12, D13, NC, 64, QEI::X4_ENCODING);
HIDScope scope(1);

//Tickers
Ticker MeasureControl;
Ticker print;
Ticker SenttoHidscope;

//Global variables
volatile double measuredPosition = 0.0;
volatile double referencePosition = 0.0; 
volatile double motorValue= 0.01;
volatile double Kp = 5.0; //dit maken we variabel, dit zorgt voor een grote of kleine overshoot
volatile double Ki = 1.0; //dit moeten we bepalen met een plot bijvoorbeeld
volatile double Kd = 0.0;
volatile double Ts = 0.01;
volatile double measuredVelocity = 0.0;
volatile double tickertime = 0.001;

//------------------------------------------------------------------------------
// Functions

double GetReferencePosition()
{
   double potMeterIn = potMeter1.read();
   referencePosition = 4.0*3.14*potMeterIn - 2.0*3.14 ; // Reference value y, scaled to -2 to 2 revolutions (or 0 to 100 pi) WAAROM?
   return referencePosition;
}

double GetMeasuredPosition()
{
    double counts = Encoder.getPulses();
    measuredPosition = ( counts / (8400)) * 6.28; // Rotational position in radians 
    return measuredPosition;  
} 

double FeedbackControl(double Error)
{  
    static double Error_integral = 0;
    static double Error_prev = Error;
    //static BiQuad LowPassFilter(..., ..., ..., ..., ...)
    // Proportional part: 
    //van 0 tot 20, waardes rond de 5 zijn het beste (minder overshoot + minder trilling motor beste combinatie hiervan)
    double u_k = Kp * Error;
    // Integral part:
    Error_integral = Error_integral + Error * Ts; 
    double u_i = Ki * Error_integral;
    // Derivative part
    double Error_derivative = (Error - Error_prev)/Ts;
    Kd = 20*potMeter2.read();
    double u_d = Kd * Error_derivative;
    Error_prev = Error;
    // Sum all parts and return it 
    return u_k + u_i + u_d; //motorValue
 }
 
void SetMotor1(double motorValue)
{
    // Given -1<=motorValue<=1, this sets the PWM and direction
    // bits for motor 1. Positive value makes motor rotating
    // clockwise. motorValues outside range are truncated to
    // within range
    if (motorValue >=0)
    {
        motor1DirectionPin=1;
    }
    else
    {
        motor1DirectionPin=0;
    }
    if (fabs(motorValue)>1)
    {
        motor1MagnitudePin = 1;
    }
    else 
    {
        motor1MagnitudePin = fabs(motorValue);
    }
}
//-----------------------------------------------------------------------------
// Tickers
void MeasureAndControl(void)
{
    // This function determines the desired velocity, measures the   
    // actual velocity, and controls the motor with 
    // a simple Feedback controller. Call this from a Ticker.
    referencePosition = GetReferencePosition();
    measuredPosition = GetMeasuredPosition();
    motorValue = FeedbackControl(referencePosition - measuredPosition);
    SetMotor1(motorValue);
}

void hidscope()
{
    double OldmeasuredPosition = measuredPosition;
    double measuredVelocity = (measuredPosition - OldmeasuredPosition) / tickertime;
    scope.set(0, measuredVelocity); // set the encoder pulses in channel 0
    scope.send();
    led = !led;
}

//-----------------------------------------------------------------------------
int main()
{
    //Initialize once
    pc.baud(115200);
    motor1MagnitudePin.period_us(60.0); // 60 microseconds PWM period: 16.7 kHz.
    MeasureControl.attach(MeasureAndControl, 0.01);
    SenttoHidscope.attach(hidscope, 0.02);
    
    //Other initializations
          
    while(true)
    {
    }
}
