#include "mbed.h"

Serial pc(USBTX, USBRX); // tx, rx

bool button1Flag = false;//ボタン1が押されているときTrue
bool button2Flag = false;//ボタン２が押されているときTrue
bool finishFlag = false;//ボタン1とボタン２を押し終わった後True
bool catchFlag = false;//サーボが動いてつかんでいるときTrue

PwmOut dcX(PA_1);//DCのXのピン
DigitalOut motordcX1(PA_0);
DigitalOut motordcX2(PA_4);

PwmOut dcY(PB_0);//DCのYのピン
DigitalOut motordcY1(PC_1);
DigitalOut motordcY2(PC_0);

DigitalIn button1(PA_15);
DigitalIn button2(PA_14);
DigitalIn switch1(PC_3);
DigitalIn switch2(PC_2);
DigitalIn switch3(PC_13);
DigitalIn switch4(PB_7);

PwmOut servo(PC_9);//サーボのピン

PwmOut dcZ(PA_13);         //dcZのピン　　　　　　
DigitalOut motordcZ1(PA_10);
DigitalOut motordcZ2(PB_14);

DigitalOut led1(PB_5);//横、縦ボタンのピン
DigitalOut led2(PB_3);

int mode = 0;

void servoCatch()
{
    //サーボが閉じる
    servo.pulsewidth_us(500);
}
void servoRelease()
{
    //サーボが開く
    servo.pulsewidth_us(700);
    wait(1);//微調整
}
void motorRight()
{
    motordcX1 = 1;//DCXが右に動く
    motordcX2 = 0;
}
void motorLeft()
{
    dcX.period_us(50);
    dcX = 0.2;

    motordcX1 = 0;//DCXが左に動く
    motordcX2 = 1;
}
void motorForward()
{
    dcY.period_us(50);
    dcY = 0.2;

    motordcY1 = 1;//DCYが前に動く
    motordcY2 = 0;
}
void motorBack()
{
    dcY.period_us(50);
    dcY = 0.2;

    motordcY1 = 0;//DCYが後ろに動く
    motordcY2 = 1;
}
void motorDown()
{
    dcZ.period_us(50);
    dcZ = 0.2;

    motordcZ1 = 1;//DCZが下に動く
    motordcZ2 = 0;
}
void motorUp()//DCZが上に動く
{
    dcZ.period_us(50);
    dcZ = 0.2;

    motordcZ1 = 0;
    motordcZ2 = 1;
}
void motorStopX()   //DCXが止まる
{
    motordcX1 = 0;
    motordcX2 = 0;
}
void motorStopY()   //DCYが止まる
{
    motordcY1 = 0;
    motordcY2 = 0;
}
void motorStopZ()   //DCZが止まる
{
    motordcZ1 = 0;
    motordcZ2 = 0;
}

void case0()
{
    servoCatch();
    led1 = 1;
    led2 = 0;
    if(button1.read() == 0) {
        button1Flag = true;
    }
    if(button1Flag == true) {
        if(switch1.read() == 1) {
            motorRight();
        } 
        else if(switch1.read() == 0) {
            motorStopX();
            mode = 1;
            button1Flag = false;
        }
        if(button1.read() == 1) {
            motorStopX();
            mode = 1;
            led1 = 0;
            led2 = 1;
            button1Flag = false;
        }
    }
}
void case1(){
    if(button2.read() == 0){
        button2Flag = true;
    }
    if(button2Flag == true){
        if(switch3.read() == 1){
            motorForward();
        }
        else if(switch3.read() == 0){
            motorStopY();
            mode = 2;
            button2Flag == false;
            }
        if(button2.read() == 1){
            motorStopY();
            mode = 2;
            button2Flag = false;    
        }
    }
}
void case2(){
        servoRelease();
        motorDown();
        wait(4);//微調整
        motorStopZ();
        wait(3);//微調整
        servoCatch();
        wait(1);
        motorUp();
        wait(3);//微調整
        motorStopZ();
        wait(3);
        mode = 3;        
        }
void case3(){
        if(switch4.read() == 1) {
            motorBack();
            }
        if(switch2.read() == 1) {
            motorLeft();
            }
        if(switch4.read() == 0) {
            motorStopY();
            }
        if(switch2.read() == 0) {
            motorStopX(); 
            }
        if(switch2.read() == 0 && switch4.read() == 0){
                mode = 4;
            }    
}
void case4(){                
                button1Flag = false;
                button2Flag = false;
                finishFlag = false;
                led1 = 1;
                led2 = 0;
                servoRelease();
                mode = 0;         
}    
int main()
{
    servo.pulsewidth_us(500);
    dcX = 0.2;
    dcX.period_us(50);
    dcY = 0.2;
    dcY.period_us(50);
    while(1){
        pc.printf("mode: %d, button1Flag %d, button2Flag %d, switch1: %d, switch2: %d, switch3: %d, switch4: %d\n"
        ,mode ,button1Flag ,button2Flag ,switch1.read() ,switch2.read() ,switch3.read() ,switch4.read());
        wait(0.1);
        switch(mode){
            case 0:
            case0();
            break;
            case 1:
            case1();
            break;
            case 2:
            case2();
            break;
            case 3:
            case3();
            break;
            case 4:
            case4();
            break;
            default:
            break;
            }
    }
}

