#include "mbed.h"
#include "math.h"

Serial pc(USBTX, USBRX);
Ticker pid;

#define M_PI 3.14159265358979323846264338327950

int r = 60;//3つのエンコーダのタイヤの半径
int c1,c2,c3;
long di = 60;//オムニの直径
long Count[3] = {c1,c2,c3};//エンコーダの値

DigitalOut led( LED1);

InterruptIn A(PF_1);//3つのエンコーダ読み取り
DigitalIn B(PA_0);
InterruptIn C(PA_4);
DigitalIn D(PB_0);
InterruptIn E(PA_15);
DigitalIn F(PA_13);

PwmOut servo1(PC_10);//サーボ
PwmOut servo2(PC_12);
 
PwmOut RF(PC_8);//左後ろ
DigitalOut RF1(PC_5);
DigitalOut RF2(PB_12);

PwmOut RB(PC_6);//右後ろ
DigitalOut RB1(PA_6);
DigitalOut RB2(PA_7);

PwmOut LF(PB_14);//右前
DigitalOut LF1(PB_6);
DigitalOut LF2(PC_7);

PwmOut LB(PB_13);//左前
DigitalOut LB1(PB_15);
DigitalOut LB2(PB_1);

long data[3] = {B,D,F};

void Arise0(){//エンコーダ読み取り
    if( int(B) == 0){
        Count[0]++;
        }
    else{
        Count[0]--;
        }
}

void Arise1(){//エンコーダ読み取り
    if( int(D) == 0){
        Count[1]++;
        }
    else{
        Count[1]--;
        }
}

void Arise2(){//エンコーダ読み取り
    if( int(F) == 0){
        Count[2]++;
        }
    else{
        Count[2]--;
        }
}

long theta = 2*(M_PI)*di*(B+D+F)/(0.04*r);//機体の回転  0.04はパルス

//x,yの仮の位置　機体の構造やギア比などで微調整

void forward(){//前進
    RF1 = 1;
    RF2 = 0;
    RB1 = 1;
    RB2 = 0;
    LF1 = 1;
    LF2 = 0;
    LB1 = 1;
    LB2 = 0;
}

void back(){//後退
    RF1 = 0;
    RF2 = 1;
    RB1 = 0;
    RB2 = 1;
    LF1 = 0;
    LF2 = 1;
    LB1 = 0;
    LB2 = 1;
}

void rightmove(){//右に平行移動
    RF1 = 0;
    RF2 = 1;
    RB1 = 1;
    RB2 = 0;
    LF1 = 1;
    LF2 = 0;
    LB1 = 0;
    LB2 = 1;
}

void leftmove(){//左に平行移動
    RF1 = 1;
    RF2 = 0;
    RB1 = 0;
    RB2 = 1;
    LF1 = 0;
    LF2 = 1;
    LB1 = 1;
    LB2 = 0;
}

void rightrotate(){//右回転
    RF1 = 0;
    RF2 = 1;
    RB1 = 0;
    RB2 = 1;
    LF1 = 1;
    LF2 = 0;
    LB1 = 1;
    LB2 = 0;
}

void leftrotate(){//左回転
    RF1 = 1;
    RF2 = 0;
    RB1 = 1;
    RB2 = 0;
    LF1 = 0;
    LF2 = 1;
    LB1 = 0;
    LB2 = 1;
}

void stop(){//機体が止まる
    RF1 = 1;
    RF2 = 1;
    RB1 = 1;
    RB2 = 1;
    LF1 = 1;
    LF2 = 1;
    LB1 = 1;
    LB2 = 1;
}

float Updatex(int goalx){               //x座標のPID制御　goalxは目標x座標
    float positionx = ((2*c2*(M_PI)*di*cosl((2*M_PI)/3+theta))/360)-(2*c3*M_PI*di*cosl((4*M_PI)/3+theta))/360+(2*c1*M_PI*di*cosl(theta)/360);
    //x座標を出し、
    float px = goalx - positionx; 
    return px;//座標をかえす
}

float Updatey(int goaly){//y座標のPID制御 goalyは目標y座標
    float positiony = ((2*c1*(M_PI)*di*sinl(theta)/360)-(2*c2*(M_PI)*di*sinl((2*M_PI)/3+theta))/360-(2*c3*(M_PI)*di*sinl((4*M_PI)/3+theta))/360);
    float py = goaly - positiony;
    return py;//座標を返す
}


int main()
{
    RF = 0.3;//pow
    RB = 0.3;
    LF = 0.3;
    LB = 0.3;
    
    A.mode(PullUp);
    B.mode(PullUp);
    C.mode(PullUp);
    D.mode(PullUp);
    E.mode(PullUp);
    F.mode(PullUp);
    
    A.rise(&Arise0);
    C.rise(&Arise1);
    E.rise(&Arise2);
    
    int i,j;
    while(true){
        forward();
        /*wait(3);
        stop();
        wait(1);
        rightmove();
        wait(3);*/
    }
    /*while(i == 0){//i,jをⅹとyの目標座標にすればおけ
        if(Updatex(i) > 0){
            rightmove();
        }
        else if(Updatex(i) < 0){
            leftmove();
        }
        else{
            stop();
            wait(1);
        }
    }
    while(j != 50){
        if(Updatey(j) > 0){
            forward();
        }
        else if(Updatey(j) < 0){
            back();
        }
        else{
            stop();
            wait(1);
        }
    }*/
}