#ifndef __BLE_DEMOAPP_SERVICE_H__
#define __BLE_DEMOAPP_SERVICE_H__

#include "Stream.h"

#include "UUID.h"
#include "BLEDevice.h"
#include "Utils.h"

typedef void (*DemoAppCallback)(uint8_t event);

class DemoAppService {
    public:
        static const uint8_t EVENT_SLIDER1_CHANGED = 0x01;
        static const uint8_t EVENT_SLIDER2_CHANGED = 0x02;
        static const uint8_t EVENT_BUTTON_CHANGED = 0x04;
    
        static const uint8_t ServiceUUID[LENGTH_OF_LONG_UUID];
        static const uint8_t slider1CharacteristicUUID[LENGTH_OF_LONG_UUID];
        static const uint8_t slider2CharacteristicUUID[LENGTH_OF_LONG_UUID];
        static const uint8_t buttonCharacteristicUUID[LENGTH_OF_LONG_UUID];
    protected:
        BLEDevice &ble;
                                            GattCharacteristic         humiditychar;
                                            GattCharacteristic         temperaturechar;
                                            GattCharacteristic         winddirectionchar;
                                            GattCharacteristic         pressurechar;
        DemoAppCallback eventCallback;
        GattCharacteristic slider1Characteristic;
        GattCharacteristic slider2Characteristic;
        GattCharacteristic buttonCharacteristic;
        
        uint16_t lastButtonPressed;
        uint16_t slider1Value;
        uint16_t slider2Value;
    public:
        DemoAppService(BLEDevice &_ble, uint16_t humidity, int16_t temperature, uint16_t winddirection, uint32_t pressure) :
            ble(_ble),
                                         humiditychar(GattCharacteristic::UUID_HUMIDITY_CHAR, (uint8_t *)&humidity,
                                        sizeof(uint16_t), sizeof(uint16_t),
                                        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                        
                                        temperaturechar(GattCharacteristic::UUID_TEMPERATURE_CHAR, (uint8_t *)&temperature,
                                        sizeof(int16_t), sizeof(int16_t),
                                        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                                        
                                        winddirectionchar(GattCharacteristic::UUID_TRUE_WIND_DIRECTION_CHAR, (uint8_t *)&winddirection,
                                        sizeof(uint16_t), sizeof(uint16_t),
                                        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
                                        
                                        pressurechar(GattCharacteristic::UUID_PRESSURE_CHAR, (uint8_t *)&pressure,
                                        sizeof(uint32_t), sizeof(uint32_t),
                                        GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
            eventCallback(NULL),
            slider1Characteristic(slider1CharacteristicUUID, (uint8_t*)&slider1Value, 2, 2,
                         GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE),
            slider2Characteristic(slider2CharacteristicUUID, (uint8_t*)&slider2Value, 2, 2,
                         GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE),
            buttonCharacteristic(buttonCharacteristicUUID, (uint8_t*)&lastButtonPressed, 2, 2,
                         GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE){

           GattCharacteristic *charTable[] = {&humiditychar, &temperaturechar, };
             GattCharacteristic *charTable2[] = {&winddirectionchar, &pressurechar};

            GattService EnvironmentalService(GattService::UUID_ENVIRONMENTAL_SENSING_SERVICE, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
             GattService EnvironmentalService2(GattService::UUID_ENVIRONMENTAL_SENSING_SERVICE, charTable2, sizeof(charTable2) / sizeof(GattCharacteristic *));

            ble.addService(EnvironmentalService);
            ble.addService(EnvironmentalService2);

//            ble.onDataWritten(this, &DemoAppService::onDataWritten);
        }
        
         /* Set a new 16-bit value for the humidity measurement.  */
    void updateHumidity(uint16_t humidity) {
        ble.updateCharacteristicValue(humiditychar.getValueAttribute().getHandle(), (uint8_t *)&humidity, sizeof(uint16_t));
    }

                 /* Set a new 16-bit value for the temperature measurement.  */
    void updateTemperature(int16_t temperature) {
        ble.updateCharacteristicValue(temperaturechar.getValueAttribute().getHandle(), (uint8_t *)&temperature, sizeof(int16_t));
    }
    
    
        /* Set a new 16-bit value for the wind direction measurement.  */
    void updateWinddirection(uint16_t winddirection) {
        ble.updateCharacteristicValue(winddirectionchar.getValueAttribute().getHandle(), (uint8_t *)&winddirection, sizeof(uint16_t));
    }       
   
    /* Set a new 32-bit value for the pressure measurement.  */
    void updatePressure(uint32_t pressure) {
        ble.updateCharacteristicValue(pressurechar.getValueAttribute().getHandle(), (uint8_t *)&pressure, sizeof(uint32_t));
    }
    
    
    
        void setCallback(DemoAppCallback callback){eventCallback = callback;}
        
        void waitForEvent(void){ble.waitForEvent(); }
        
        virtual void onDataWritten(const GattCharacteristicWriteCBParams *params) {
            uint8_t event = 0;
            DEBUG("Demo service onWrite\n\r");
            if (params->charHandle == slider1Characteristic.getValueAttribute().getHandle()) {
                uint16_t bytesRead = params->len;
                if (bytesRead == 2) {
                    memcpy(&slider1Value, params->data, 2);
                    DEBUG("Slider1: %d\n\r", slider1Value);
                    event |= EVENT_SLIDER1_CHANGED;
                }
            }
            else if (params->charHandle == slider2Characteristic.getValueAttribute().getHandle()) {
                uint16_t bytesRead = params->len;
                if (bytesRead == 2) {
                    memcpy(&slider2Value, params->data, 2);
                    DEBUG("Slider2: %d\n\r", slider2Value);
                    event |= EVENT_SLIDER2_CHANGED;
                }
            }
            else if (params->charHandle == buttonCharacteristic.getValueAttribute().getHandle()) {
                uint16_t bytesRead = params->len;
                if (bytesRead == 2) {
                    memcpy(&lastButtonPressed, params->data, 2);
                    event |= EVENT_BUTTON_CHANGED;
                }
            }
            if(event && eventCallback){
                eventCallback(event);
            }
        }
        
        uint16_t getSlider1Value()const{return slider1Value;}
        uint16_t getSlider2Value()const{return slider2Value;}
};

DemoAppService *startDemoBLE(const char* name);

#endif