/* Demo BLE service
 * Copyright (c) 2006-2013 ARM Limited
 * Copyright (c) 2015 Adam Berlinger
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "DemoAppService.h"


#include "mbed.h"
#include "BLEDevice.h"
#include "DeviceInformationService.h"
#include "UARTService.h"
#include "Utils.h"

const uint8_t DemoAppService::ServiceUUID[LENGTH_OF_LONG_UUID] = {
    0x6E, 0x40, 0x00, 0x10, 0xB5, 0xA3, 0xF3, 0x93,
    0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E,
};

const uint8_t DemoAppService::buttonCharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0x6E, 0x40, 0x00, 0x11, 0xB5, 0xA3, 0xF3, 0x93,
    0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E,
};

const uint8_t DemoAppService::slider1CharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0x6E, 0x40, 0x00, 0x12, 0xB5, 0xA3, 0xF3, 0x93,
    0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E,
};

const uint8_t DemoAppService::slider2CharacteristicUUID[LENGTH_OF_LONG_UUID] = {
    0x6E, 0x40, 0x00, 0x13, 0xB5, 0xA3, 0xF3, 0x93,
    0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E,
};

static BLEDevice  *ble;

/* Callback called when the device is disconnected */
static void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
  DEBUG("Disconnected!\n\r");
  DEBUG("Restarting the advertising process\n\r");

  ble->startAdvertising();
  //connected = false;
}

/* Callback called when the device is connected */
static void connectionCallback(Gap::Handle_t handle, const Gap::ConnectionParams_t *reason)
{
  DEBUG("Connected\r\n");

  //connected = true;
}

const static char     DEVICE_NAME[]        = "BlueNRG_UART";
DemoAppService *startDemoBLE(const char* name){
    ble = new BLEDevice();
    ble->init();
/* Set callback functions */
  ble->onDisconnection(disconnectionCallback);
  ble->onConnection(connectionCallback);
 
  DeviceInformationService deviceInfo(*ble, "ST", "Nucleo", "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
  /* setup advertising */
  ble->accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
  ble->setAdvertisingType          (GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    
  //ble->accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME            , (const uint8_t *)"BlueNRG_UART"          , sizeof("BlueNRG_UART") - 1);
  //ble->accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS, (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
  ble->accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME             , (uint8_t *)name                   , strlen(name)+1);

  /* Start advertising */
  ble->setAdvertisingInterval(160);
  ble->startAdvertising();
 
  return new DemoAppService(*ble,20,50,70,225);
}