/* Bluetooth low energy demo application
 * Copyright (c) 2015 Adam Berlinger
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "DemoAppService.h"
#include "x_cube_mems.h"
#define PI 3.1415169f
float TEMPERATURE_C = 20;
float HUMIDITY = 50;
float PRESSURE = 1000;
float WIND_DIRECTION = 0;
int16_t MagRaw[3];
AxesRaw_TypeDef MAGNETIC;

extern bool user_button_pressed;
bool connected = false;
bool UpdatedEnabled = false;

DemoAppService *demoService;
PwmOut led(LED1);

void demoCallback(uint8_t event){
    /* Nastaveni stridy PWM signalu */
    if(event & DemoAppService::EVENT_SLIDER1_CHANGED){
        int x = 1 << (demoService->getSlider1Value() / 10);
        led.write((float)(x / (float)(1 << 10)));
    }
    /* Nastaveni periody PWM signalu */
    if(event & DemoAppService::EVENT_SLIDER2_CHANGED){
        led.period(1.0f / (demoService->getSlider2Value() + 1));
    }
}

int main(void)
{
  demoService = startDemoBLE("BLE-12345678");
  demoService->setCallback(demoCallback);

  led = 0.0f;
  
  static X_CUBE_MEMS *Sensors = X_CUBE_MEMS::Instance();
 
  
  while (true) 
  {
       
            /* Read the environmental sensors  */
                  //  Sensors->hts221.GetTemperature((float *)&TEMPERATURE_C);
//                    Sensors->hts221.GetHumidity((float *)&HUMIDITY);
//                    Sensors->lps25h.GetPressure((float *)&PRESSURE);
                    
                    Sensors->hts221.GetTemperature((float *)&TEMPERATURE_C);
                    Sensors->hts221.GetHumidity((float *)&HUMIDITY);
                    Sensors->lps25h.GetPressure((float *)&PRESSURE);
                    Sensors->lis3mdl.GetAxes((AxesRaw_TypeDef *)&MAGNETIC);
                 
                    
                                            TEMPERATURE_C = TEMPERATURE_C*100;  //2 decimals
                                            HUMIDITY = HUMIDITY*100;                        //2 decimals
                                            PRESSURE = PRESSURE*1000;           //hPa to Pa + 1 decimal
                                                    
                                                    //Calcule the direction where the system is pointing relative to North.
                    //I have used a simple empirical method to distinguish between 8 directions. 
                    if (MAGNETIC.AXIS_X < 140) WIND_DIRECTION = 0; //North
                    else if (MAGNETIC.AXIS_X >= 140 && MAGNETIC.AXIS_X < 200 && -MAGNETIC.AXIS_Y > 250 ) WIND_DIRECTION = 45;  //Northeast
                    else if (MAGNETIC.AXIS_X >= 140 && MAGNETIC.AXIS_X < 200 && -MAGNETIC.AXIS_Y < 250 ) WIND_DIRECTION = 315; //Northwest
                    else if (MAGNETIC.AXIS_X >= 200 && MAGNETIC.AXIS_X < 280 && -MAGNETIC.AXIS_Y > 250 ) WIND_DIRECTION = 90;  //East
                    else if (MAGNETIC.AXIS_X >= 200 && MAGNETIC.AXIS_X < 280 && -MAGNETIC.AXIS_Y < 250 ) WIND_DIRECTION = 270; //Weast
                    else if (MAGNETIC.AXIS_X >= 280 && MAGNETIC.AXIS_X < 380 && -MAGNETIC.AXIS_Y > 250 ) WIND_DIRECTION = 135; //Southeast
                    else if (MAGNETIC.AXIS_X >= 280 && MAGNETIC.AXIS_X < 380 && -MAGNETIC.AXIS_Y < 250 ) WIND_DIRECTION = 225; //Soutwest           
                    else if (MAGNETIC.AXIS_X >= 380) WIND_DIRECTION = 180; //South
                    
                     WIND_DIRECTION *=100;                             //2 decimals
                                                    
                                                         demoService->updateHumidity(HUMIDITY);
                                                         demoService->updateTemperature(TEMPERATURE_C);
                                                         demoService->updateWinddirection(WIND_DIRECTION);
                                                         demoService->updatePressure(PRESSURE);
            demoService->waitForEvent();
         
    
  }
}
