#include "mbed.h"
#include "VL6180x.h"
#define TFTWIDTH  240
#define TFTHEIGHT 320
#define TFT_NORTH {SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR}
#define TFT_EAST  {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_MY | SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}
#define TFT_SOUTH {SPFD5408_MADCTL_MX | SPFD5408_MADCTL_BGR}
#define TFT_WEST  {SPFD5408_MADCTL_MV | SPFD5408_MADCTL_BGR}
#define BLACK   0x0000
#define BLUE    0x001F
#define RED     0xF800
#define GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF
#define SPFD5408_SOFTRESET          0x01
#define SPFD5408_SLEEPIN            0x10
#define SPFD5408_SLEEPOUT           0x11
#define SPFD5408_NORMALDISP         0x13
#define SPFD5408_INVERTOFF          0x20
#define SPFD5408_INVERTON           0x21
#define SPFD5408_GAMMASET           0x26
#define SPFD5408_DISPLAYOFF         0x28
#define SPFD5408_DISPLAYON          0x29
#define SPFD5408_COLADDRSET         0x2A
#define SPFD5408_PAGEADDRSET        0x2B
#define SPFD5408_MEMORYWRITE        0x2C
#define SPFD5408_PIXELFORMAT        0x3A
#define SPFD5408_FRAMECONTROL       0xB1
#define SPFD5408_DISPLAYFUNC        0xB6
#define SPFD5408_ENTRYMODE          0xB7
#define SPFD5408_POWERCONTROL1      0xC0
#define SPFD5408_POWERCONTROL2      0xC1
#define SPFD5408_VCOMCONTROL1       0xC5
#define SPFD5408_VCOMCONTROL2       0xC7
#define SPFD5408_MEMCONTROL         0x36
#define SPFD5408_MADCTL             0x36
#define SPFD5408_MADCTL_MY          0x80
#define SPFD5408_MADCTL_MX          0x40
#define SPFD5408_MADCTL_MV          0x20
#define SPFD5408_MADCTL_ML          0x10
#define SPFD5408_MADCTL_RGB         0x00
#define SPFD5408_MADCTL_BGR         0x08
#define SPFD5408_MADCTL_MH          0x04
#define IDLE    1
#define ACTIVE  0
#define COMMAND 0
#define DATA    1
#define TEMPS   40
#define YP A3
#define XM A2 
#define YM D9  
#define XP D8 
#define LCD_CS A3
#define LCD_CD A2
#define LCD_WR A1
#define LCD_RD A0
#define LCD_RESET A4
void restoreXY(void);
uint16_t detectTouch(void);
DigitalOut pinRD(A0);   //PA_0;
DigitalOut pinWR(A1);   //PA_1;
DigitalOut pinCD(A2);   //PA_4;
DigitalOut pinCS(A3);   //PB_0;
DigitalOut pinReset(A4);//PC_1;
BusInOut portTFT(D8, D9, D2, D3, D4, D5, D6, D7);
void WriteCommand(uint8_t c)
{
    pinCD = COMMAND;
    pinWR = ACTIVE;
    portTFT = c;
    pinWR = IDLE; 
}
void WriteData(uint8_t d)
{
    pinCD = DATA;
    pinWR = ACTIVE;
    portTFT = d;
    pinWR = IDLE; 
}
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);
 
void begin(void) {
    pinCS = IDLE; 
    pinCD = DATA;
    pinWR = IDLE;
    pinRD = IDLE;
    portTFT.output();   
    pinReset = ACTIVE;
    pinReset = IDLE;
    pinCS = ACTIVE;
    
    WriteCommand(SPFD5408_SOFTRESET);
    WriteData(0);
    wait_ms(50);
    
    WriteCommand(SPFD5408_MEMCONTROL);
    WriteData(SPFD5408_MADCTL_MY | SPFD5408_MADCTL_BGR);
    
    WriteCommand(SPFD5408_PIXELFORMAT);
    WriteData(0x55);
  
    WriteCommand(SPFD5408_FRAMECONTROL);
    WriteData(0x00);
    WriteData(0x1B);
  
    WriteCommand(SPFD5408_SLEEPOUT);
    WriteData(0);
  
    WriteCommand(SPFD5408_DISPLAYON);
    WriteData(0);
}
void setAddrWindow(int x1, int y1, int x2, int y2) {
    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_COLADDRSET);
    WriteData(x1 >> 8);
    WriteData(x1);
    WriteData(x2 >> 8);
    WriteData(x2);
    wait_us(TEMPS);
    pinCS = IDLE;
    pinCS = ACTIVE;
    wait_us(TEMPS);
    WriteCommand(SPFD5408_PAGEADDRSET);
    WriteData(y1 >> 8);
    WriteData(y1);
    WriteData(y2 >> 8);
    WriteData(y2);
    wait_us(TEMPS);
    pinCS = IDLE;
}
void fillRect(uint16_t x1, uint16_t y1, uint16_t w, uint16_t h, uint16_t fillcolor) {
    uint8_t hi, lo;
    uint16_t  x2, y2;
    uint16_t i, j;
    x2 = x1 + w - 1;
    y2 = y1 + h - 1;
    setAddrWindow(x1, y1, x2, y2);
    hi = fillcolor >> 8;
    lo = fillcolor;
    pinCS = ACTIVE;
    WriteCommand(SPFD5408_MEMORYWRITE);
    pinCD = DATA;
    for (i = h; i > 0; i--)
    {
        for (j = w; j > 0; j--)
        {
            pinWR = ACTIVE;
            portTFT = hi;
            pinWR = IDLE; 
            pinWR = ACTIVE;
            portTFT = lo;
            pinWR = IDLE;             
        }
    }
    pinCS = IDLE;
}
unsigned int min(unsigned int val1, unsigned int val2)
{
  unsigned int val = val1;
  if(val2 < val)
  {
    val = val2;
  }
  return(val);
}
unsigned int max(unsigned int val1, unsigned int val2)
{
  unsigned int val = val1;
  if(val2 > val)
  {
    val = val2;
  }
  return(val);
}
uint16_t detectTouch(void)
{
uint16_t firstValue;
//uint16_t secondValue;
AnalogIn pinXM(XM);
DigitalOut pinYP(YP);
DigitalOut pinYM(YM);

    pinYP = 1;
    pinYM = 0;
    firstValue = pinXM.read_u16() >> 4;

    //pinYP = 0;
    //pinYM = 1;
    //secondValue = pinXM.read_u16() >> 4;

    restoreXY();
    
    //if (secondValue < firstValue)
    //{
        return firstValue;
    //}
    //return secondValue;
}
void restoreXY(void)
{
DigitalOut pinXP(XP);
DigitalOut pinXM(XM);    
DigitalOut pinYP(YP);
DigitalOut pinYM(YM);

    pinXP = 1;
    pinXM = 1;
    pinYP = 1;
    pinYM = 1;
}
int main()
{
    unsigned int uiTest;
    VL6180x Capteur(D14, D15, 0x29 << 1);
    Capteur.VL6180xInit();
    Capteur.VL6180xDefautSettings();
    begin();
    
    unsigned int uiDist = Capteur.getDistance();
    unsigned int uiLastDist = uiDist;

    while(1)
    {
      fillRect(0, 0, 240, 320, WHITE);
      for(unsigned int x = 0; x < 320; x++)
      {
        wait_ms(5);
        for(unsigned int y = min(uiDist, uiLastDist); y <= max(uiDist, uiLastDist); y++)
        {
          fillRect((y * 240) / 255, x, 1, 1, BLACK);
        }
        pc.printf("Distance : %umm\r\n", uiDist);
        uiLastDist = uiDist;
        uiDist = Capteur.getDistance();
        uiTest = detectTouch();
        pc.printf("Z : %u\r\n", uiTest);
        if(uiTest)
        {
          pc.printf("Reset\r\n");
          x = 320;
        }
      }
    }
}