#ifndef MAINH
  #define MAINH

  // VS Code
  // #define uint8_t unsigned char
  // #define uint16_t unsigned int
  // #define uint32_t unsigned long
  // VS Code

  #include <stdio.h>
  #include <math.h>
  #include "mbed.h"
  #include "SDFileSystem.h"
  #include "LCD_DISCO_F746NG.h"
  #include "TS_DISCO_F746NG.h"

  struct STButton
  {
    uint16_t uiPosition[2];
    uint16_t uiSize[2];
    uint8_t ucState;
    void (*vFunction)(void);
  };

  uint8_t ucTest(void);

  uint8_t ucFPGASerialConfiguration(char *cFileName);

  void vDisplayImage(char *cFileName, uint16_t uiX, uint16_t uiY);

  void vCheckButtons(STButton *stButtons, uint8_t ucCount);

  void vRun(void);
  void vMode(void);
  void vTrigger(void);
  void vSave(void);
  void vPrint(void);

#endif
