#include "main.h"

SDFileSystem sd("sd");
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;
Serial pc(USBTX, USBRX);

int main(void)
{
  STButton stButtons[] = 
  {
    {
      {435, 20},
      {40, 42},
      0,
      vRun
    },
    {
      {435, 67},
      {40, 43},
      0,
      vMode
    },
    {
      {435, 115},
      {40, 42},
      0,
      vTrigger
    },
    {
      {435, 162},
      {40, 43},
      0,
      vSave
    },
    {
      {435, 210},
      {40, 42},
      0,
      vPrint
    }
  };
  uint8_t ucAcquisition[480];
  for(uint16_t i = 0; i < sizeof(ucAcquisition); i++)
  {
      ucAcquisition[i] = 0xFF / 2;
  }

  pc.baud(115200);
  sd.mount();
  ts.Init(lcd.GetXSize(), lcd.GetYSize());

  ucFPGASerialConfiguration("/sd/FPGA/oscilloscope.bit");

  //vDisplayImage("/sd/Image/Background.bmp", 0, 0);

  while(1)
  {
    //vCheckButtons(stButtons, sizeof(stButtons) / sizeof(STButton));
    lcd.Clear(LCD_COLOR_WHITE);
    for(uint16_t i = 1; i < sizeof(ucAcquisition); i++)
    {
        ucAcquisition[i - 1] = ucAcquisition[i];
        lcd.DrawPixel(i, (272 / 255.0) * ucAcquisition[i - 1], 0);
    }
    ucAcquisition[sizeof(ucAcquisition) - 1] = (ucAcquisition[sizeof(ucAcquisition) - 2] + ucAcquisition[sizeof(ucAcquisition) - 3] + ucAcquisition[sizeof(ucAcquisition) - 4] + ucAcquisition[sizeof(ucAcquisition) - 5] + ucTest()) / 5;
    lcd.DrawPixel(sizeof(ucAcquisition) - 1, (ucAcquisition[sizeof(ucAcquisition) - 1] / 255.0) * 50 - 25 + (272 / 2.0), 0);
  }
}

uint8_t ucTest(void)
{
  BusIn STMData(D0, D1, D2, D3, D4, D5, D6, D7);
  DigitalOut CLOCK(D13);
  
  STMData.mode(PullNone);
  
  CLOCK = 0;
  CLOCK = 1;
  
  pc.printf("0x%.2X\r\n", (unsigned int)STMData.read());
  return((uint8_t)STMData.read());
}

uint8_t ucFPGASerialConfiguration(char *cFileName)
{
  SPI fpga_spi(D11, D12, D13);
  DigitalIn fpga_done(D8);
  DigitalIn fpga_init_b(D14);
  DigitalOut fpga_program_b(D15);
  FILE *fFile = fopen(cFileName, "r");
  int iByte;

  fpga_program_b = 0;
  fpga_program_b = 1;

  if(fFile != NULL)
  {
    for(iByte = fgetc(fFile); (iByte != EOF) && fpga_init_b; iByte = fgetc(fFile))
    {
      fpga_spi.write(iByte);
    }
    fclose(fFile);
  }

  return(fpga_done);
}

void vDisplayImage(char *cFileName, uint16_t uiX, uint16_t uiY)
{
  FILE *fFile = fopen(cFileName, "r");
  uint32_t ulFileSize;
  uint8_t *ucFile;

  if(fFile != NULL)
  {
    fseek(fFile, 0, SEEK_END);
    ulFileSize = ftell(fFile);
    rewind(fFile);

    ucFile = new uint8_t[ulFileSize];

    fread(ucFile, 1, ulFileSize, fFile);

    fclose(fFile);

    lcd.DrawBitmap(uiX, uiY, ucFile);

    delete(ucFile);
  }
}

void vCheckButtons(STButton *stButtons, uint8_t ucCount)
{
  TS_StateTypeDef TS_State;

  ts.GetState(&TS_State);

  for(uint8_t i = 0; i < ucCount; i++)
  {
    stButtons[i].ucState <<= 1;
    for(uint8_t j = 0; j < TS_State.touchDetected; j++)
    {
      stButtons[i].ucState |= ((TS_State.touchX[j] >= stButtons[i].uiPosition[0]) && (TS_State.touchY[j] >= stButtons[i].uiPosition[1]) && (TS_State.touchX[j] < stButtons[i].uiPosition[0] + stButtons[i].uiSize[0]) && (TS_State.touchY[j] < stButtons[i].uiPosition[1] + stButtons[i].uiSize[1]));
    }
    if((stButtons[i].ucState & 0x03) == 0x02)
    {
      stButtons[i].vFunction();
    }
  }
}

void vRun(void)
{

}

void vMode(void)
{

}

void vTrigger(void)
{

}

void vSave(void)
{
  char cFileName[] = "/sd/Save/Save00000.csv";
  FILE *fFile = fopen(cFileName, "r");
  uint16_t uiFileIndex = 0;

  while((fFile != NULL) && (uiFileIndex < 65535))
  {
    uiFileIndex++;
    sprintf(cFileName, "/sd/Save/Save%0.5u.csv", (unsigned int)uiFileIndex);
    fFile = freopen(cFileName, "r", fFile);
  }

  if(fFile == NULL)
  {
    fFile = fopen(cFileName, "w");
  }

  fclose(fFile);
}

void vPrint(void)
{
  char cFileName[] = "/sd/Print/Print00000.bmp";
  FILE *fFile = fopen(cFileName, "r");
  uint16_t uiFileIndex = 0;

  while((fFile != NULL) && (uiFileIndex < 65535))
  {
    uiFileIndex++;
    sprintf(cFileName, "/sd/Print/Print%0.5u.bmp", (unsigned int)uiFileIndex);
    fFile = freopen(cFileName, "r", fFile);
  }

  if(fFile == NULL)
  {
    fFile = fopen(cFileName, "w");
  }

  fclose(fFile);
}
