#include "mbed.h"
#include <RF22.h>
#include <RF22ReliableDatagram.h>
#include <GPS.h>
 
// Sample programm for ReliableDatagramm Sending
// Uses address 1 and sends to RF22 with address 2
// See notebook http://mbed.org/users/charly/notebook/rfm22/ for connecting RFM22 to mbed
DigitalOut myled(LED1); 
Serial pc(USBTX, USBRX);
GPS af(PB_10, PB_11);
//RF22ReliableDatagram (uint8_t thisAddress, PinName slaveSelectPin, PinName mosi, PinName miso, PinName sclk, PinName interrupt)
RF22ReliableDatagram rf22(0,PB_6,PA_7,PA_6,PA_5,PA_10);
 
float frequency = 433;           // frequency 
 
const uint8_t sender_adress = 1;        // address of sender
const uint8_t receiver_adress =2;       // address of receiver
 
 
// send messages forever
void send_loop() {
    uint8_t data[32] = "";
 
    while (1) {
        
        if(af.sample()==1)
        {
            float latitude=af.latitude;
            float longitude=af.longitude;
        sprintf((char*)data,"%f,%f",latitude,longitude);
        pc.printf("%f, %f",latitude,longitude);
        //sendtoWait(uint8_t* buf, uint8_t len, uint8_t address);
        pc.printf("\n\rStart sending ... ");
        if (rf22.sendtoWait(data, sizeof(data), receiver_adress)) {
            pc.printf("Send to %i ACK: >>%s<< ", receiver_adress,(char*)data);
        } else {
            pc.printf("Send to %i NOTACK: >>%s<< ", receiver_adress,(char*)data);
        }
        pc.printf("sleeping 2 seconds...  ");
        wait(1); 
        }
        else
        {
            myled=1;
            wait(0.5);
            myled=0;
            wait(0.5);
        } // Wait 2 Seconds
    }
}
 
int main() {
 
    pc.baud(9600);
    pc.printf("\n\rConnected to mbed\n\r");
 
    pc.printf ("RF22-Test-Reliable-Send V1.0\n\r");
 
    // initialize the device
    if (!rf22.init())
        pc.printf("RF22 init failed\n\r");
 
    // set to 19.2 KB
    if (!rf22.setModemConfig(RF22::GFSK_Rb19_2Fd9_6))
        pc.printf("setModemConfig failed");
 
    if (!rf22.setFrequency(frequency))
        pc.printf("setFrequency failed");
 
    // Code for sending
    pc.printf("I am sending with address %i to adress %i ...\n\r",sender_adress,receiver_adress  );
    rf22.setThisAddress(sender_adress);     // sender-adress
 
    send_loop();                // start sending
}
 