#include "mbed.h"
#include <RF22.h>
#include <RF22ReliableDatagram.h>
 #include "gprs.h"
  
#define SEND_SMS_TEST           0
#define CALL_UP_TEST            0
#define ANSWER_TEST             0
#define READ_SMS_TEST           0
 
#define BAUD_RATE               19200 // Baud rate of GPRS Shield 
#define PHONE_NUMBER            "+923344255202"
 
GPRS  gprsTest(PA_9, PA_10, BAUD_RATE, PHONE_NUMBER);
Serial pc(USBTX, USBRX);
 
void messageHandle(void)
{        
     __disable_irq();
    int messageType = gprsTest.loopHandle();
    if(MESSAGE_RING == messageType) {
        gprsTest.answer();
    } else if(MESSAGE_SMS == messageType) {
        char smsMessage[SMS_MAX_LENGTH];
        gprsTest.getSMS(smsMessage);
    }
    __enable_irq();
}
 
//RF22ReliableDatagram (uint8_t thisAddress, PinName slaveSelectPin, PinName mosi, PinName miso, PinName sclk, PinName interrupt)
RF22ReliableDatagram rf22(0,PB_6,PA_7,PA_6,PA_5,PB_5);
 
float frequency = 433;           // frequency 
float longitude=0;
float latitude=0;
int flag=0;
float baselat=0;
float baselong=0;
float distance=0;
float diflat=0;
float diflong=0;
float dislat=0;
float dislong=0;
const uint8_t sender_adress = 1;        // address of sender
const uint8_t receiver_adress =2;       // address of receiver

uint8_t data[256]=" "; 
void receive_loop() {
        uint8_t buf[RF22_MAX_MESSAGE_LEN];
        uint8_t len = sizeof(buf);
 
        //boolean recvfromAck(uint8_t* buf, uint8_t* len, uint8_t* from = NULL, uint8_t* to = NULL, uint8_t* id = NULL, uint8_t* flags = NULL);
        if (rf22.recvfromAck(buf, &len)) 
        {
            sscanf((char *)buf,"%f,%f",&latitude,&longitude);
            pc.printf("\nLatitude: %f, Longitude: %f\n",latitude,longitude);
            if(flag==0)
            {
                baselat=latitude;
                baselong=longitude;
                flag=1;
            }
            diflat=latitude-baselat;
            diflong=longitude-baselong;
            dislat= 111366*diflat;
            dislong= 111366*diflong;
            distance= sqrt( (dislat*dislat) + (dislong*dislong) );
            pc.printf("baselat: %f, baselong: %f\n",baselat,baselong);     
            pc.printf("latitude: %f, longitude: %f \r\n",latitude,longitude);
            pc.printf("difference in latitude: %f \n difference in longitude: %f\n",diflat,diflong); 
            pc.printf("distance in latitude: %f \n Distance in longitude: %f\n Total Distance: %f\n",dislat,dislong,distance);     
        }
}

 
int main() {
 
    pc.baud(9600);
    pc.printf("\n\rConnected to mbed\n\r");
 
    pc.printf ("RF22-Test-Reliable-Send V1.0\n\r");
 
    // initialize the device
    if (!rf22.init())
        pc.printf("RF22 init failed\n\r");
 
    // set to 19.2 KB
    if (!rf22.setModemConfig(RF22::GFSK_Rb19_2Fd9_6))
        pc.printf("setModemConfig failed");
 
    if (!rf22.setFrequency(frequency))
        pc.printf("setFrequency failed");
 
     // Code for receiving
    pc.printf("I am receiving with address %i ...\n\r",receiver_adress);
    rf22.setThisAddress(receiver_adress);  
 
   while(latitude==0)
   {receive_loop();}
    int unk=0;
    while(0 != gprsTest.init()) {
        wait(2);
    }
    pc.printf("\n.....about to send msg\n");
    sprintf((char*)data,"STM32 GPS Coordinates:\nbaselat: %f\n baselong: %f\nlatitude: %f\n longitude: %f \r\ndifference in latitude: %f \n difference in longitude: %f\ndistance in latitude: %f \n Distance in longitude: %f\n Total Distance: %f\n",baselat,baselong,latitude,longitude,diflat,diflong,dislat,dislong,distance);
    unk=gprsTest.sendSMS(PHONE_NUMBER,(char*)data); //define phone number and text
    if(unk!=0)
    {
        pc.printf("\nSending failed\n");
        }
    gprsTest.callUp(PHONE_NUMBER);
    gprsTest.gprsSerial.attach(&messageHandle);
    pc.printf("Sent");
    while(1){wait(1);}        
}
 