#ifndef TCP_COMM_H
#define TCP_COMM_H
#include "rtos.h"
#include "mbed.h"
#include "ConfigEthernet.h"
#include <string>

#define SERVER_PORT   7

class TCP_Communication
{
    public :
        TCP_Communication();
        TCP_Communication(string adrr, int port); // Établir une connexion Socket à l'adresse et le port en paramètre 
        void initSocket();
        void sendDataSocket(char *data);
        void closeSocketConnection();
        
        // Thread pour la reception 
        static void threadReceiverStarter(void const *args);
        void threadReceiverWorker();
        
        // Thread pour le serveur 
        static void threadServerStarter(void const *args);
        void threadServerWorker(); 
        
    private:
        TCPSocketConnection socket;
        
        Thread threadSocket;
        
        char *url;
        const char *address;
        int port;
};
#endif