#include "TCP_COMM.h"
TCP_Communication::TCP_Communication()
            :threadSocket(&TCP_Communication::threadServerStarter, this, osPriorityNormal,1024)
{
    wait(5);
    threadSocket.signal_set(0x01);
}

TCP_Communication::TCP_Communication(string _addr, int _port)
            :threadSocket(&TCP_Communication::threadReceiverStarter, this, osPriorityNormal,1024)
{
    address = _addr.c_str();
    port = _port;
    initSocket();
    threadSocket.signal_set(0x02);
}

void TCP_Communication::threadServerStarter(const void *args)
{
    printf("Thread Server Starter \n");
    TCP_Communication *instance = (TCP_Communication*)args;
    instance->threadServerWorker();
}

void TCP_Communication::threadReceiverStarter(void const *args)
{
    printf("Thread Receiver Starter \n");
    TCP_Communication *instance = (TCP_Communication*)args;
    instance->threadReceiverWorker();
}

void TCP_Communication::threadServerWorker()
{
    printf("Attente du signal\n");
    threadSocket.signal_wait(0x01);
    
    printf("Init Server\n");
    TCPSocketServer server;
    server.bind(SERVER_PORT);
    printf("Server listen\n");
    server.listen();
    
    while(1)
    {
        printf("Wait for new connection...\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        char dataBuffer[256];
        while (true) {
            int lengthData = client.receive(dataBuffer, sizeof(dataBuffer));
            if (lengthData <= 0) break;
            
            // print received message to terminal
            dataBuffer[lengthData] = '\0';
            printf("Received message from Client :'%s'\n",dataBuffer);
        }
        client.close();
    } 
}

void TCP_Communication::threadReceiverWorker()
{
    threadSocket.signal_wait(0x02);
    
    while(1)
    {
        printf("Receiver Worker thread \n");
        char message[256];
        int messageLength;
        printf("Wait to receive data :\n");
        messageLength = socket.receive(message, 256);
        if(messageLength <= 0)
        {
            printf("No message \n");
            Thread::wait(500); 
            continue;
        }
        message[messageLength] = '\0'; // String end type
        printf("Received message from server: '%s' %i \n", message, messageLength);
        Thread::wait(500);  
    }
}


void TCP_Communication::initSocket()
{
    int compteur = 0;
    while (!socket.connect(address, port) && compteur < 0) {
        printf("Unable to connect to (%s) on port (%d)\n", address, port);
        ++compteur;
        wait(1);
    }
    printf("Connected to Server at %s\n",address);
}

void TCP_Communication::sendDataSocket(char *data)
{
    printf("Sending  message data to Server : '%s' length %i \n",data, strlen(data));
    socket.send_all(data, strlen(data));
}


void TCP_Communication::closeSocketConnection()
{
    socket.close();
}