#include "mbed.h"
#include "rtos.h"
#include "PC_Comm.h"
#include "ConfigurationFile.h"
#include "ConfigEthernet.h"
#include "TCP_COMM.h"
#include "Websocket.h"
#include "WebSocket_COMM.h"


DigitalOut myled(LED1);
Serial *pc;

LocalFileSystem local("local");
const char* ECHO_SERVER_ADDRESS = "192.168.0.101    ";
const int ECHO_SERVER_PORT = 7;

void testServer()
{
    printf("Read Config File\n");
    ConfigurationFile config;
    config.readConfigurationFile("/local/server.cfg");
    config.readServerEthernetConfiguration();
    
    printf("Init Ethernet connection \n");
    ConfigEthernet ethernet(config.getIP(),config.getMask(),config.getGateway());
    ethernet.initConnection();
    
    TCP_Communication tcp();
}

void testSocket()
{
    printf("Read Config File\n");
    ConfigurationFile config;
    config.readConfigurationFile("/local/server.cfg");
    config.readServerEthernetConfiguration();
    
    printf("Init Ethernet connection \n");
    ConfigEthernet ethernet(config.getIP(),config.getMask(),config.getGateway());
    ethernet.initConnection();
    
    // Create TCP Object
    printf("Create TCP Socket Object \n");
    TCP_Communication tcp(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
    
    // Init TCP Socket Connexion
    printf("Init Socket connexion \n");
    tcp.initSocket();
    
    // Send Data with Socket
    printf("Send Data to server\n");
    tcp.sendDataSocket("Hello World");
    tcp.sendDataSocket("Hello Wolrd 1!!!");
    tcp.sendDataSocket("Hello Wolrd 2!!!");
    tcp.sendDataSocket("Hello Wolrd 3!!!");
}

void testWebSocket()
{
    
    printf("Read Config File\n");
    ConfigurationFile config;
    config.readConfigurationFile("/local/server.cfg");
    config.readServerEthernetConfiguration();
    
    printf("Init Ethernet connection \n");
    ConfigEthernet ethernet(config.getIP(),config.getMask(),config.getGateway());
    ethernet.initConnection();
    
    WebSocket_Communication ws(config.getURL());
    ws.initWebSocket();
    ws.sendDataWebSocket("Hello Socket Server !");
    
}


int main() 
{
    //testWebSocket();
    testSocket();
    //Thread::wait(osWaitForever);
}
