#include "mbed.h"
 
BusOut leds(P1_13, P1_14, P1_22, P0_17, P0_18, P0_19, P1_15, P0_1);

void rotate1();
void rotate2();
void rotate3();
 
int main() {
    while(1) {
        leds = 0xff;
        wait(1);
        leds = 0x00;
        wait(1);
        leds = 0xff;
        wait(0.8);
        leds = 0x00;
        wait(0.8);
        leds = 0xff;
        wait(0.6);
        leds = 0x00;
        wait(0.6);
        leds = 0xff;
        wait(0.4);
        leds = 0x00;
        wait(0.4);
        leds = 0xff;
        wait(0.2);
        leds = 0x00;
        wait(0.2);
        rotate1();
        wait(0.25);
        rotate2();
        wait(0.25);
        rotate3();
        wait(0.25);
        leds = 11111110;
        wait(0.2);
        leds = 11111101;
        wait(0.2);
        leds = 11111011;
        wait(0.2);
        leds = 11110111;
        wait(0.2);
        leds = 11101111;
        wait(0.2);
        leds = 11011111;
        wait(0.2);
        leds = 10111111;
        wait(0.2);
        leds = 01111111;
        wait(0.2);
    }
}

void rotate1()
{
    volatile uint8_t i;
    for(i = 0x00; i < 8; i++)
    {
        leds = 1 << i;
        wait(1/i);
    }

    
}

void rotate2()
{
    volatile uint8_t i;
    for(i = 0x00; i < 8; i++)
    {
        leds = 10000000 >> i;
        wait(i/8);
    }

    
}

void rotate3()
{
    volatile uint8_t i;
    for(i = 0x00; i < 6; i++)
    {
        leds = 101 << i;
        wait(i*i/6);
    }

    
}