#include "mbed.h"

BusOut leds(P1_13, P1_14, P1_22, P0_17, P0_18, P0_19, P1_15, P0_1);

void rotate1();
void rotate2();
void rotate3();
void all1();
void sitei();
void all2();

int main()
{

    while(1)
    {
        rotate1();
        rotate2();
        rotate3();
        wait(0.2);
        all1();
        sitei();
        all2();
        all2();
        all2();
        all2();
    }
}

void rotate1()
{
    volatile uint8_t i ;
    for(i = 0; i < 8; i++)
    {
        leds = 1 << i;
        wait(0.3);
    }
}

void rotate2()
{
    volatile uint8_t j ;
    for(j = 0; j < 7; j=j+2)
    {
        leds = 192 >> j;
        wait(0.3);
    }
}

void rotate3()
{
    volatile uint8_t k ;
    for(k = 0; k < 5; k=k+4)
    {
        leds = 15 << k;
        wait(0.3);
    }
}

void all1()
{
    leds=0xff;
    wait(0.5);
    leds=0x00;
    wait(0.3);
}

void sitei()
{
    leds=0x01;
    wait(0.3);
    leds=0x80;
    wait(0.3);
    leds=0x02;
    wait(0.3);
    leds=0x40;
    wait(0.3);
    leds=0x04;
    wait(0.3);
    leds=0x20;
    wait(0.3);
    leds=0x08;
    wait(0.3);
    leds=0x10;
    wait(0.3);
    leds=0x18;
    wait(0.3);
    leds=0x3c;
    wait(0.3);
    leds=0x7e;
    wait(0.3);
}

void all2()
{
    leds=0xff;
    wait(0.125);
    leds=0x00;
    wait(0.125);
}