#ifndef BME280_H
#define BME280_H

#include "mbed.h"

#define BME280_ADDR_H       (0x77)
#define BME280_ADDR_L       (0x76)

#define BME280_CTRL_HUM     (0xF2)
#define BME280_CTRL_MEAS    (0xF4)

typedef enum {
    BME280_SAMPLING_X1    = 0x01,
    BME280_SAMPLING_X2    = 0x02,
    BME280_SAMPLING_X4    = 0x03,
    BME280_SAMPLING_X8    = 0x04,
    BME280_SAMPLING_X16   = 0x05,
} bme280_sampling_t;

typedef enum{
    BME280_MODE_SLEEP   = 0x00,
    BME280_MODE_FORCED1 = 0x01,
    BME280_MODE_FORCED2 = 0x02,
    BME280_MODE_NORMAL  = 0x03,
} bme280_mode_t;

class BME280
{
public:
    BME280(I2C& bme280_i2c, uint8_t bme280_addr=BME280_ADDR_H);
    //virtual ~BME280();
    bool init(void);
    float getTemperature(void);
    float getPressure(void);
    float getHumidity(void);

protected:
    I2C         _i2c;
    uint8_t     _addr;
    bool        _init;
    uint16_t    dig_T1;
    int16_t     dig_T2, dig_T3;
    uint16_t    dig_P1;
    int16_t     dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9;
    uint16_t    dig_H1, dig_H3;
    int16_t     dig_H2, dig_H4, dig_H5, dig_H6;
    int32_t     t_fine;
};

#endif