#ifndef LOCOMOTION_H
#define LOCOMOTION_H

#include "mbed.h"
#include "LOCALIZE.h"

#define SPEED_TURN_MIN  0.20
#define SPEED_TURN_MAX  0.65

enum {
    ANGLE_TURN  = 0,
    ANGLE_BIAS  = 1,
};

class LOCOMOTION
{
public:
    LOCOMOTION(PinName motor1F, PinName motor1B,PinName motor2F, PinName motor2B, PinName forward1, PinName forward2);
    PwmOut _m1f;
    PwmOut _m1b;
    PwmOut _m2f;
    PwmOut _m2b;
    DigitalOut _m1dir;
    DigitalOut _m2dir;
    bool setXPos(int target, int current, int error, int angle);
    bool setYPos(int target, int current, int error, int angle);
    bool setAngle(int target, int current, int error, int mode);
    int wrap(int num);

protected:
    float s;
};
#endif