#include "QEI.h"
#include "mbed.h"
#include "MODSERIAL.h" 

// Definiëren van alle poorten

DigitalIn encoder1A (D13); //Channel A van Encoder 1
DigitalIn encoder1B (D12); //Channel B van Encoder 1
DigitalIn button_cw (D11); //Clockwise rotation
DigitalIn button_ccw (D9); //Counterclockwise rotation
DigitalOut Ledcw (D10); 
DigitalOut Ledccw (D2);
DigitalOut motor1 (D4);
PwmOut pwm_motor1 (D5);
MODSERIAL pc(USBTX, USBRX);
 
 //constanten
 const in CW = 2.5; //Clockwise 'lage waarde'
 const in CCW= 0; // Counterclockwise 'hoge waarde
 
int main() {
    
    pc.baud(115200); //snelheid contact computer
    QEI Encoder(D12, D13, NC, 32); //maakt de encoder aan
    int counts;
 
    while(true){
        if (button_cw==0){ 
            ledcw=1;
            motor1= CW;
            pwm_motor1=2.5;
            counts = Encoder.getPulses();
            pc.printf("Encoder counts: %i \r\n", counts);
            }
        else if (button_ccw==0) {
            ledccw=1;
            motor1= CCW;
            pwm_motor1=2.5;
            counts = Encoder.getPulses();
            pc.printf("Encoder counts: %i \r\n", counts);
            }
        else{
            ledcw=0;
            ledccw=0;
            pwm_motor1=0;
            }
         }
 
}
 
 