#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"

//Ticker vanuit EMGsample
Ticker emgSampleTicker;

AnalogIn emg(A0); //Analoge ingang voor EMG signaal
HIDScope (2); // 2 kanalen

BiQuadChain bqc;
BiQuad bq1( //get numbers from butter filter MATLAB
BiQuad bq2( //get numbers from butter filter MATLAB

//Implementeren van de functie
void emgSample(){
    double in=emg.read();
    double out=bqc.step();
    
    scope.set(0,in); //channel 0
    scope.set(1,out); //channel 1
    
    scope.send();
    }


int main()
{
    bqc.add(&bq1).add(&bq2);
    emgSampleTicker.attach(&emgSample, 0.01f); //frequentie van 100 HZ
    while(1){ //niet terugkomen uit de main
        }
    }
}