/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "stdio.h"
/* Reference resistor in series with the thermistor is of 10 KOhm */
#define R_REFERENCE (float)(10000)
/* Beta constant of this thermistor is 3380 Kelvin. See the thermistor
   (NCP18XH103F03RB) data sheet for more details. */
#define B_CONSTANT (float)(3380)
/* Resistance of the thermistor is 10K at 25 degrees C (from data sheet)
   Therefore R0 = 10000 Ohm, and T0 = 298.15 Kelvin, which gives
   R_INFINITY = R0 e^(-B_CONSTANT / T0) = 0.1192855 */
#define R_INFINITY (float)(0.1192855)
/* Zero Kelvin in degree C */
#define ABSOLUTE_ZERO (float)(-273.15)
//static DigitalIn thermVDD(P10_0);  // if wing is detached and powered from 3.3v
//static DigitalIn thermGND(P10_3);  // don't need to control power to thermistor
   

// Blinking rate in milliseconds
#define BLINKING_RATE_MS 500
//  #define SW2 P0_4
//  #define SW3 P12_3

char buffer[80];
/* prototype of function */
void displayAt( int x, int y, char *buffer );

int main()
{
    // Initialise the digital pin LED1 as an output
//    DigitalOut led(LED1);
//    DigitalIn pushButton(SW2, PullUp);
    AnalogIn vTherm(P10_1);  //Input pin of Thermister potential divider
    AnalogIn lightLevel(P10_4);  //  
    DigitalOut redLed2 (P10_5);
    DigitalOut greenLed (P10_0);
    DigitalOut yellowLed (P0_5);
    DigitalIn switch3 (P12_3);
    AnalogIn pot (P10_2);
    
    printf("\033[2J\033[H"); // clear screen and move the cursor to 0, 0
    printf("\033[?25l"); // Turn off visible cursor
    printf("Environmental Control System");
//    printf( "\033[34m" );
    fflush(stdout); // send the codes to the terminal
 
    while (true) {
        if (switch3 == 1)  
        redLed2 = !redLed2;
        
        float potValue = pot.read();
        if (potValue < 0.3)  
        greenLed = !greenLed;
        
        if (potValue > 0.7)
        yellowLed = !yellowLed;
 //       thread_sleep_for(BLINKING_RATE_MS);  
/*        if (pushButton == 0) {
            led = !led;
            // read thermistor Voltage 
    float refVoltage = vTherm.read() * 2.4; // Range of ADC 0->2*Vref
    float refCurrent = refVoltage  / 10000.0; // 10k Reference Resistor
    float thermVoltage = 3.3 - refVoltage;    // Assume supply voltage is 3.3v
    float thermResistance = thermVoltage / refCurrent; 
    float logrT = (float32_t)log((float64_t)thermResistance);
 
    // Calculate temperature from the resistance of thermistor using Steinhart-Hart Equation 
    float stEqn = (float32_t)((0.0009032679) + ((0.000248772) * logrT) + 
                             ((2.041094E-07) * pow((float64)logrT, (float32)3)));
 
    float temperatureC = (float32_t)(((1.0 / stEqn) - 273.15)  + 0.5);

            sprintf(buffer, "Temperature is %2.1f\r\n", temperatureC);
            displayAt(0, 3, buffer);

        float lightPercent = ( 1 - lightLevel.read()) * 100;
        sprintf( buffer, "Ambient Light is: %3.1f", lightPercent );
        displayAt(1, 4, buffer);
        thread_sleep_for(BLINKING_RATE_MS);  */
    }
}

void displayAt( int x, int y, char *buffer ) {
    printf( "\033[%d;%dH%s", y, x, buffer);
    fflush(stdout);
    }