/* Hello World! for the Emwin TFT Library */

#include "mbed.h"
#include "GUI.h"
#include "cy8ckit_028_tft.h"

#define LED_DIAMETER    (8)
#define LED_RADIUS      (LED_DIAMETER/2)
#define DISPLAY_X       (320)
#define DISPLAY_Y       (240)
#define NUMLEDS_X       (DISPLAY_X/LED_DIAMETER)
#define NUMLEDS_Y       (DISPLAY_Y/LED_DIAMETER)
#define LED_OFF         (0)
#define LED_ON          (1)
#define TITLE_OFFSET    (16+LED_RADIUS)    

AnalogIn lightlevel(P10_0);  
DigitalOut lights(LED4);
DigitalOut lightsR(LED1);
DigitalOut lightsG(LED3);
DigitalOut lightsB(LED2);


bool lightStatus;

void Display_Init(void)
{
    /* Initialise EmWin driver*/
    GUI_Init();

    /* Set font size, foreground and background Colours */
    GUI_SetFont(GUI_FONT_24B_1);
    GUI_SetColor(GUI_WHITE);
    GUI_SetBkColor(GUI_BLACK);

    /* Clear screen and print splash screen */
    GUI_Clear();
    GUI_SetTextAlign(GUI_TA_HCENTER);
    GUI_DispStringAt("LIGHT SENSOR", 160, 0);
}

int main()
{
    int lowThresh, highThresh;
    lowThresh = 40;
    highThresh = 70;
    lights, 0;
    

    /* Initialise display */
    Display_Init();

    printf("LIGHT LEVEL CONTROL\r\n");
    lightStatus = false;

    GUI_SetFont(GUI_FONT_D80);
    GUI_SetColor(GUI_BLUE);
    while(true){
        int lightpercent;
        lightpercent = (lightlevel.read_u16()*100)/65535;
        printf("light level is %d\r\n", lightpercent);
        if(lightpercent > highThresh) lightStatus = 1;
        else if(lightpercent < lowThresh) lightStatus = 0;
        lights = lightStatus;
        if(lightpercent > highThresh) {
            lightsB = 0;
            lightsR = 1;
            lightsG = 1;
            }
        if(lightpercent < highThresh && lightpercent > lowThresh) {
            lightsB = 1;
            lightsR = 1;
            lightsG = 0;
            }
         if(lightpercent < lowThresh) {
            lightsB = 1;
            lightsR = 0;
            lightsG = 1;
            }
            
        ThisThread::sleep_for(1000);
        char buffer[16];
        sprintf(buffer, "%d", lightpercent);
        GUI_DispStringAt(buffer, 30, 30);
        GUI_SetColor(GUI_DARKGREEN);
        GUI_FillRect(260, 30, 300, 220);
        GUI_SetColor(GUI_GREEN);
        GUI_FillRect(260, 220 - lightpercent * 2, 300, 220);
         
        }
    
}



