/* Hello World! for the Emwin TFT Library */

#include "mbed.h"
#include "GUI.h"
#include "cy8ckit_028_tft.h"

#define LED_DIAMETER    (32)
#define LED_RADIUS      (LED_DIAMETER/2)
#define DISPLAY_X       (320)
#define DISPLAY_Y       (240)
#define NUMLEDS_X       (DISPLAY_X/LED_DIAMETER)
#define NUMLEDS_Y       (DISPLAY_Y/LED_DIAMETER)
#define LED_OFF         (0)
#define LED_ON          (1)
#define TITLE_OFFSET    (16+LED_RADIUS)      

AnalogIn lightLevel(P10_0);
DigitalOut lights(LED4);
DigitalOut lightsR(LED1);
DigitalOut lightsG(LED2);
DigitalOut lightsB(LED3);
bool lightStatus;

void Display_Init(void)
{
    /* Initialise EmWin driver*/
    GUI_Init();

    /* Set font size, foreground and background Colours */
    GUI_SetFont(GUI_FONT_24B_1);
    GUI_SetColor(GUI_WHITE);
    GUI_SetBkColor(GUI_BLACK);

    /* Clear screen and print splash screen */
    GUI_Clear();
    GUI_SetTextAlign(GUI_TA_HCENTER);
    GUI_DispStringAt("CITY3032 Light Level", 160, 0);
}

int main()
{
    int lowThresh, highThresh;
    lowThresh = 40;
    highThresh = 70;
    lights = 0;  
    /* Initialise display */
    Display_Init();

    printf("Light Level Control\r\n");
    lightStatus = false;
    GUI_SetFont(GUI_FONT_D60X80);
    GUI_SetColor(GUI_WHITE);
    while(true) {
        GUI_SetColor(GUI_WHITE);
        int lightPercent;
        lightPercent = (lightLevel.read_u16()*100)/65535;
        printf("light level is %d\r\n",lightPercent);
        if(lightPercent > highThresh) lightStatus = 1;
        else if (lightPercent < lowThresh) lightStatus = 0;
        lights = lightStatus;
        if(lightPercent > highThresh) {
            lightsB = 0;
            lightsR = 1;
            lightsG = 1;
            }
        if(lightPercent < highThresh && lightPercent > lowThresh) {
            lightsB = 1;
            lightsR = 1;
            lightsG = 0;
            } 
        if(lightPercent < lowThresh) {
            lightsB = 1;
            lightsR = 0;
            lightsG = 1;
            }
            
        ThisThread::sleep_for(1000);
        char buffer[16];
        sprintf(buffer,"%d",lightPercent);
        GUI_SetTextAlign(GUI_TA_HCENTER);
        GUI_DispStringAt(buffer,160,40);
        GUI_SetColor(GUI_WHITE);
        GUI_DrawRect(260, 20, 300, 220);
        GUI_SetColor(GUI_CYAN);
        GUI_FillRect(260, 220 - lightPercent * 2, 300, 220 );
    }
 
}



