/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_MCM_REGISTERS_H__
#define __HW_MCM_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 MCM
 *
 * Core Platform Miscellaneous Control Module
 *
 * Registers defined in this header file:
 * - HW_MCM_PLASC - Crossbar Switch (AXBS) Slave Configuration
 * - HW_MCM_PLAMC - Crossbar Switch (AXBS) Master Configuration
 * - HW_MCM_CR - Control Register
 * - HW_MCM_ISCR - Interrupt Status Register
 * - HW_MCM_ETBCC - ETB Counter Control register
 * - HW_MCM_ETBRL - ETB Reload register
 * - HW_MCM_ETBCNT - ETB Counter Value register
 * - HW_MCM_PID - Process ID register
 *
 * - hw_mcm_t - Struct containing all module registers.
 */

#define HW_MCM_INSTANCE_COUNT (1U) /*!< Number of instances of the MCM module. */

/*******************************************************************************
 * HW_MCM_PLASC - Crossbar Switch (AXBS) Slave Configuration
 ******************************************************************************/

/*!
 * @brief HW_MCM_PLASC - Crossbar Switch (AXBS) Slave Configuration (RO)
 *
 * Reset value: 0x001FU
 *
 * PLASC is a 16-bit read-only register identifying the presence/absence of bus
 * slave connections to the device's crossbar switch.
 */
typedef union _hw_mcm_plasc
{
    uint16_t U;
    struct _hw_mcm_plasc_bitfields
    {
        uint16_t ASC : 8;              /*!< [7:0] Each bit in the ASC field indicates
                                        * whether there is a corresponding connection to the crossbar switch's slave
                                        * input port. */
        uint16_t RESERVED0 : 8;        /*!< [15:8]  */
    } B;
} hw_mcm_plasc_t;

/*!
 * @name Constants and macros for entire MCM_PLASC register
 */
/*@{*/
#define HW_MCM_PLASC_ADDR(x)     ((x) + 0x8U)

#define HW_MCM_PLASC(x)          (*(__I hw_mcm_plasc_t *) HW_MCM_PLASC_ADDR(x))
#define HW_MCM_PLASC_RD(x)       (HW_MCM_PLASC(x).U)
/*@}*/

/*
 * Constants & macros for individual MCM_PLASC bitfields
 */

/*!
 * @name Register MCM_PLASC, field ASC[7:0] (RO)
 *
 * Values:
 * - 0 - A bus slave connection to AXBS input port n is absent
 * - 1 - A bus slave connection to AXBS input port n is present
 */
/*@{*/
#define BP_MCM_PLASC_ASC     (0U)          /*!< Bit position for MCM_PLASC_ASC. */
#define BM_MCM_PLASC_ASC     (0x00FFU)     /*!< Bit mask for MCM_PLASC_ASC. */
#define BS_MCM_PLASC_ASC     (8U)          /*!< Bit field size in bits for MCM_PLASC_ASC. */

/*! @brief Read current value of the MCM_PLASC_ASC field. */
#define BR_MCM_PLASC_ASC(x)  (HW_MCM_PLASC(x).B.ASC)
/*@}*/

/*******************************************************************************
 * HW_MCM_PLAMC - Crossbar Switch (AXBS) Master Configuration
 ******************************************************************************/

/*!
 * @brief HW_MCM_PLAMC - Crossbar Switch (AXBS) Master Configuration (RO)
 *
 * Reset value: 0x0037U
 *
 * PLAMC is a 16-bit read-only register identifying the presence/absence of bus
 * master connections to the device's crossbar switch.
 */
typedef union _hw_mcm_plamc
{
    uint16_t U;
    struct _hw_mcm_plamc_bitfields
    {
        uint16_t AMC : 8;              /*!< [7:0] Each bit in the AMC field indicates
                                        * whether there is a corresponding connection to the AXBS master input port. */
        uint16_t RESERVED0 : 8;        /*!< [15:8]  */
    } B;
} hw_mcm_plamc_t;

/*!
 * @name Constants and macros for entire MCM_PLAMC register
 */
/*@{*/
#define HW_MCM_PLAMC_ADDR(x)     ((x) + 0xAU)

#define HW_MCM_PLAMC(x)          (*(__I hw_mcm_plamc_t *) HW_MCM_PLAMC_ADDR(x))
#define HW_MCM_PLAMC_RD(x)       (HW_MCM_PLAMC(x).U)
/*@}*/

/*
 * Constants & macros for individual MCM_PLAMC bitfields
 */

/*!
 * @name Register MCM_PLAMC, field AMC[7:0] (RO)
 *
 * Values:
 * - 0 - A bus master connection to AXBS input port n is absent
 * - 1 - A bus master connection to AXBS input port n is present
 */
/*@{*/
#define BP_MCM_PLAMC_AMC     (0U)          /*!< Bit position for MCM_PLAMC_AMC. */
#define BM_MCM_PLAMC_AMC     (0x00FFU)     /*!< Bit mask for MCM_PLAMC_AMC. */
#define BS_MCM_PLAMC_AMC     (8U)          /*!< Bit field size in bits for MCM_PLAMC_AMC. */

/*! @brief Read current value of the MCM_PLAMC_AMC field. */
#define BR_MCM_PLAMC_AMC(x)  (HW_MCM_PLAMC(x).B.AMC)
/*@}*/

/*******************************************************************************
 * HW_MCM_CR - Control Register
 ******************************************************************************/

/*!
 * @brief HW_MCM_CR - Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * CR defines the arbitration and protection schemes for the two system RAM
 * arrays.
 */
typedef union _hw_mcm_cr
{
    uint32_t U;
    struct _hw_mcm_cr_bitfields
    {
        uint32_t RESERVED0 : 24;       /*!< [23:0]  */
        uint32_t SRAMUAP : 2;          /*!< [25:24] SRAM_U arbitration priority */
        uint32_t SRAMUWP : 1;          /*!< [26] SRAM_U write protect */
        uint32_t RESERVED1 : 1;        /*!< [27]  */
        uint32_t SRAMLAP : 2;          /*!< [29:28] SRAM_L arbitration priority */
        uint32_t SRAMLWP : 1;          /*!< [30] SRAM_L Write Protect */
        uint32_t RESERVED2 : 1;        /*!< [31]  */
    } B;
} hw_mcm_cr_t;

/*!
 * @name Constants and macros for entire MCM_CR register
 */
/*@{*/
#define HW_MCM_CR_ADDR(x)        ((x) + 0xCU)

#define HW_MCM_CR(x)             (*(__IO hw_mcm_cr_t *) HW_MCM_CR_ADDR(x))
#define HW_MCM_CR_RD(x)          (HW_MCM_CR(x).U)
#define HW_MCM_CR_WR(x, v)       (HW_MCM_CR(x).U = (v))
#define HW_MCM_CR_SET(x, v)      (HW_MCM_CR_WR(x, HW_MCM_CR_RD(x) |  (v)))
#define HW_MCM_CR_CLR(x, v)      (HW_MCM_CR_WR(x, HW_MCM_CR_RD(x) & ~(v)))
#define HW_MCM_CR_TOG(x, v)      (HW_MCM_CR_WR(x, HW_MCM_CR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCM_CR bitfields
 */

/*!
 * @name Register MCM_CR, field SRAMUAP[25:24] (RW)
 *
 * Defines the arbitration scheme and priority for the processor and SRAM
 * backdoor accesses to the SRAM_U array.
 *
 * Values:
 * - 00 - Round robin
 * - 01 - Special round robin (favors SRAM backoor accesses over the processor)
 * - 10 - Fixed priority. Processor has highest, backdoor has lowest
 * - 11 - Fixed priority. Backdoor has highest, processor has lowest
 */
/*@{*/
#define BP_MCM_CR_SRAMUAP    (24U)         /*!< Bit position for MCM_CR_SRAMUAP. */
#define BM_MCM_CR_SRAMUAP    (0x03000000U) /*!< Bit mask for MCM_CR_SRAMUAP. */
#define BS_MCM_CR_SRAMUAP    (2U)          /*!< Bit field size in bits for MCM_CR_SRAMUAP. */

/*! @brief Read current value of the MCM_CR_SRAMUAP field. */
#define BR_MCM_CR_SRAMUAP(x) (HW_MCM_CR(x).B.SRAMUAP)

/*! @brief Format value for bitfield MCM_CR_SRAMUAP. */
#define BF_MCM_CR_SRAMUAP(v) ((uint32_t)((uint32_t)(v) << BP_MCM_CR_SRAMUAP) & BM_MCM_CR_SRAMUAP)

/*! @brief Set the SRAMUAP field to a new value. */
#define BW_MCM_CR_SRAMUAP(x, v) (HW_MCM_CR_WR(x, (HW_MCM_CR_RD(x) & ~BM_MCM_CR_SRAMUAP) | BF_MCM_CR_SRAMUAP(v)))
/*@}*/

/*!
 * @name Register MCM_CR, field SRAMUWP[26] (RW)
 *
 * When this bit is set, writes to SRAM_U array generates a bus error.
 */
/*@{*/
#define BP_MCM_CR_SRAMUWP    (26U)         /*!< Bit position for MCM_CR_SRAMUWP. */
#define BM_MCM_CR_SRAMUWP    (0x04000000U) /*!< Bit mask for MCM_CR_SRAMUWP. */
#define BS_MCM_CR_SRAMUWP    (1U)          /*!< Bit field size in bits for MCM_CR_SRAMUWP. */

/*! @brief Read current value of the MCM_CR_SRAMUWP field. */
#define BR_MCM_CR_SRAMUWP(x) (HW_MCM_CR(x).B.SRAMUWP)

/*! @brief Format value for bitfield MCM_CR_SRAMUWP. */
#define BF_MCM_CR_SRAMUWP(v) ((uint32_t)((uint32_t)(v) << BP_MCM_CR_SRAMUWP) & BM_MCM_CR_SRAMUWP)

/*! @brief Set the SRAMUWP field to a new value. */
#define BW_MCM_CR_SRAMUWP(x, v) (HW_MCM_CR_WR(x, (HW_MCM_CR_RD(x) & ~BM_MCM_CR_SRAMUWP) | BF_MCM_CR_SRAMUWP(v)))
/*@}*/

/*!
 * @name Register MCM_CR, field SRAMLAP[29:28] (RW)
 *
 * Defines the arbitration scheme and priority for the processor and SRAM
 * backdoor accesses to the SRAM_L array.
 *
 * Values:
 * - 00 - Round robin
 * - 01 - Special round robin (favors SRAM backoor accesses over the processor)
 * - 10 - Fixed priority. Processor has highest, backdoor has lowest
 * - 11 - Fixed priority. Backdoor has highest, processor has lowest
 */
/*@{*/
#define BP_MCM_CR_SRAMLAP    (28U)         /*!< Bit position for MCM_CR_SRAMLAP. */
#define BM_MCM_CR_SRAMLAP    (0x30000000U) /*!< Bit mask for MCM_CR_SRAMLAP. */
#define BS_MCM_CR_SRAMLAP    (2U)          /*!< Bit field size in bits for MCM_CR_SRAMLAP. */

/*! @brief Read current value of the MCM_CR_SRAMLAP field. */
#define BR_MCM_CR_SRAMLAP(x) (HW_MCM_CR(x).B.SRAMLAP)

/*! @brief Format value for bitfield MCM_CR_SRAMLAP. */
#define BF_MCM_CR_SRAMLAP(v) ((uint32_t)((uint32_t)(v) << BP_MCM_CR_SRAMLAP) & BM_MCM_CR_SRAMLAP)

/*! @brief Set the SRAMLAP field to a new value. */
#define BW_MCM_CR_SRAMLAP(x, v) (HW_MCM_CR_WR(x, (HW_MCM_CR_RD(x) & ~BM_MCM_CR_SRAMLAP) | BF_MCM_CR_SRAMLAP(v)))
/*@}*/

/*!
 * @name Register MCM_CR, field SRAMLWP[30] (RW)
 *
 * When this bit is set, writes to SRAM_L array generates a bus error.
 */
/*@{*/
#define BP_MCM_CR_SRAMLWP    (30U)         /*!< Bit position for MCM_CR_SRAMLWP. */
#define BM_MCM_CR_SRAMLWP    (0x40000000U) /*!< Bit mask for MCM_CR_SRAMLWP. */
#define BS_MCM_CR_SRAMLWP    (1U)          /*!< Bit field size in bits for MCM_CR_SRAMLWP. */

/*! @brief Read current value of the MCM_CR_SRAMLWP field. */
#define BR_MCM_CR_SRAMLWP(x) (HW_MCM_CR(x).B.SRAMLWP)

/*! @brief Format value for bitfield MCM_CR_SRAMLWP. */
#define BF_MCM_CR_SRAMLWP(v) ((uint32_t)((uint32_t)(v) << BP_MCM_CR_SRAMLWP) & BM_MCM_CR_SRAMLWP)

/*! @brief Set the SRAMLWP field to a new value. */
#define BW_MCM_CR_SRAMLWP(x, v) (HW_MCM_CR_WR(x, (HW_MCM_CR_RD(x) & ~BM_MCM_CR_SRAMLWP) | BF_MCM_CR_SRAMLWP(v)))
/*@}*/

/*******************************************************************************
 * HW_MCM_ISCR - Interrupt Status Register
 ******************************************************************************/

/*!
 * @brief HW_MCM_ISCR - Interrupt Status Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_mcm_iscr
{
    uint32_t U;
    struct _hw_mcm_iscr_bitfields
    {
        uint32_t RESERVED0 : 1;        /*!< [0]  */
        uint32_t IRQ : 1;              /*!< [1] Normal Interrupt Pending */
        uint32_t NMI : 1;              /*!< [2] Non-maskable Interrupt Pending */
        uint32_t DHREQ : 1;            /*!< [3] Debug Halt Request Indicator */
        uint32_t RESERVED1 : 4;        /*!< [7:4]  */
        uint32_t FIOC : 1;             /*!< [8] FPU invalid operation interrupt status */
        uint32_t FDZC : 1;             /*!< [9] FPU divide-by-zero interrupt status */
        uint32_t FOFC : 1;             /*!< [10] FPU overflow interrupt status */
        uint32_t FUFC : 1;             /*!< [11] FPU underflow interrupt status */
        uint32_t FIXC : 1;             /*!< [12] FPU inexact interrupt status */
        uint32_t RESERVED2 : 2;        /*!< [14:13]  */
        uint32_t FIDC : 1;             /*!< [15] FPU input denormal interrupt status */
        uint32_t RESERVED3 : 8;        /*!< [23:16]  */
        uint32_t FIOCE : 1;            /*!< [24] FPU invalid operation interrupt enable
                                        * */
        uint32_t FDZCE : 1;            /*!< [25] FPU divide-by-zero interrupt enable */
        uint32_t FOFCE : 1;            /*!< [26] FPU overflow interrupt enable */
        uint32_t FUFCE : 1;            /*!< [27] FPU underflow interrupt enable */
        uint32_t FIXCE : 1;            /*!< [28] FPU inexact interrupt enable */
        uint32_t RESERVED4 : 2;        /*!< [30:29]  */
        uint32_t FIDCE : 1;            /*!< [31] FPU input denormal interrupt enable */
    } B;
} hw_mcm_iscr_t;

/*!
 * @name Constants and macros for entire MCM_ISCR register
 */
/*@{*/
#define HW_MCM_ISCR_ADDR(x)      ((x) + 0x10U)

#define HW_MCM_ISCR(x)           (*(__IO hw_mcm_iscr_t *) HW_MCM_ISCR_ADDR(x))
#define HW_MCM_ISCR_RD(x)        (HW_MCM_ISCR(x).U)
#define HW_MCM_ISCR_WR(x, v)     (HW_MCM_ISCR(x).U = (v))
#define HW_MCM_ISCR_SET(x, v)    (HW_MCM_ISCR_WR(x, HW_MCM_ISCR_RD(x) |  (v)))
#define HW_MCM_ISCR_CLR(x, v)    (HW_MCM_ISCR_WR(x, HW_MCM_ISCR_RD(x) & ~(v)))
#define HW_MCM_ISCR_TOG(x, v)    (HW_MCM_ISCR_WR(x, HW_MCM_ISCR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCM_ISCR bitfields
 */

/*!
 * @name Register MCM_ISCR, field IRQ[1] (W1C)
 *
 * If ETBCC[RSPT] is set to 01b, this bit is set when the ETB counter expires.
 *
 * Values:
 * - 0 - No pending interrupt
 * - 1 - Due to the ETB counter expiring, a normal interrupt is pending
 */
/*@{*/
#define BP_MCM_ISCR_IRQ      (1U)          /*!< Bit position for MCM_ISCR_IRQ. */
#define BM_MCM_ISCR_IRQ      (0x00000002U) /*!< Bit mask for MCM_ISCR_IRQ. */
#define BS_MCM_ISCR_IRQ      (1U)          /*!< Bit field size in bits for MCM_ISCR_IRQ. */

/*! @brief Read current value of the MCM_ISCR_IRQ field. */
#define BR_MCM_ISCR_IRQ(x)   (HW_MCM_ISCR(x).B.IRQ)

/*! @brief Format value for bitfield MCM_ISCR_IRQ. */
#define BF_MCM_ISCR_IRQ(v)   ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_IRQ) & BM_MCM_ISCR_IRQ)

/*! @brief Set the IRQ field to a new value. */
#define BW_MCM_ISCR_IRQ(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_IRQ) | BF_MCM_ISCR_IRQ(v)))
/*@}*/

/*!
 * @name Register MCM_ISCR, field NMI[2] (W1C)
 *
 * If ETBCC[RSPT] is set to 10b, this bit is set when the ETB counter expires.
 *
 * Values:
 * - 0 - No pending NMI
 * - 1 - Due to the ETB counter expiring, an NMI is pending
 */
/*@{*/
#define BP_MCM_ISCR_NMI      (2U)          /*!< Bit position for MCM_ISCR_NMI. */
#define BM_MCM_ISCR_NMI      (0x00000004U) /*!< Bit mask for MCM_ISCR_NMI. */
#define BS_MCM_ISCR_NMI      (1U)          /*!< Bit field size in bits for MCM_ISCR_NMI. */

/*! @brief Read current value of the MCM_ISCR_NMI field. */
#define BR_MCM_ISCR_NMI(x)   (HW_MCM_ISCR(x).B.NMI)

/*! @brief Format value for bitfield MCM_ISCR_NMI. */
#define BF_MCM_ISCR_NMI(v)   ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_NMI) & BM_MCM_ISCR_NMI)

/*! @brief Set the NMI field to a new value. */
#define BW_MCM_ISCR_NMI(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_NMI) | BF_MCM_ISCR_NMI(v)))
/*@}*/

/*!
 * @name Register MCM_ISCR, field DHREQ[3] (RO)
 *
 * Indicates that a debug halt request is initiated due to a ETB counter
 * expiration, ETBCC[2:0] = 3b111 & ETBCV[10:0] = 11h0. This bit is cleared when the
 * counter is disabled or when the ETB counter is reloaded.
 *
 * Values:
 * - 0 - No debug halt request
 * - 1 - Debug halt request initiated
 */
/*@{*/
#define BP_MCM_ISCR_DHREQ    (3U)          /*!< Bit position for MCM_ISCR_DHREQ. */
#define BM_MCM_ISCR_DHREQ    (0x00000008U) /*!< Bit mask for MCM_ISCR_DHREQ. */
#define BS_MCM_ISCR_DHREQ    (1U)          /*!< Bit field size in bits for MCM_ISCR_DHREQ. */

/*! @brief Read current value of the MCM_ISCR_DHREQ field. */
#define BR_MCM_ISCR_DHREQ(x) (HW_MCM_ISCR(x).B.DHREQ)
/*@}*/

/*!
 * @name Register MCM_ISCR, field FIOC[8] (RO)
 *
 * This read-only bit is a copy of the core's FPSCR[IOC] bit and signals an
 * illegal operation has been detected in the processor's FPU. Once set, this bit
 * remains set until software clears the FPSCR[IOC] bit.
 *
 * Values:
 * - 0 - No interrupt
 * - 1 - Interrupt occurred
 */
/*@{*/
#define BP_MCM_ISCR_FIOC     (8U)          /*!< Bit position for MCM_ISCR_FIOC. */
#define BM_MCM_ISCR_FIOC     (0x00000100U) /*!< Bit mask for MCM_ISCR_FIOC. */
#define BS_MCM_ISCR_FIOC     (1U)          /*!< Bit field size in bits for MCM_ISCR_FIOC. */

/*! @brief Read current value of the MCM_ISCR_FIOC field. */
#define BR_MCM_ISCR_FIOC(x)  (HW_MCM_ISCR(x).B.FIOC)
/*@}*/

/*!
 * @name Register MCM_ISCR, field FDZC[9] (RO)
 *
 * This read-only bit is a copy of the core's FPSCR[DZC] bit and signals a
 * divide by zero has been detected in the processor's FPU. Once set, this bit remains
 * set until software clears the FPSCR[DZC] bit.
 *
 * Values:
 * - 0 - No interrupt
 * - 1 - Interrupt occurred
 */
/*@{*/
#define BP_MCM_ISCR_FDZC     (9U)          /*!< Bit position for MCM_ISCR_FDZC. */
#define BM_MCM_ISCR_FDZC     (0x00000200U) /*!< Bit mask for MCM_ISCR_FDZC. */
#define BS_MCM_ISCR_FDZC     (1U)          /*!< Bit field size in bits for MCM_ISCR_FDZC. */

/*! @brief Read current value of the MCM_ISCR_FDZC field. */
#define BR_MCM_ISCR_FDZC(x)  (HW_MCM_ISCR(x).B.FDZC)
/*@}*/

/*!
 * @name Register MCM_ISCR, field FOFC[10] (RO)
 *
 * This read-only bit is a copy of the core's FPSCR[OFC] bit and signals an
 * overflow has been detected in the processor's FPU. Once set, this bit remains set
 * until software clears the FPSCR[OFC] bit.
 *
 * Values:
 * - 0 - No interrupt
 * - 1 - Interrupt occurred
 */
/*@{*/
#define BP_MCM_ISCR_FOFC     (10U)         /*!< Bit position for MCM_ISCR_FOFC. */
#define BM_MCM_ISCR_FOFC     (0x00000400U) /*!< Bit mask for MCM_ISCR_FOFC. */
#define BS_MCM_ISCR_FOFC     (1U)          /*!< Bit field size in bits for MCM_ISCR_FOFC. */

/*! @brief Read current value of the MCM_ISCR_FOFC field. */
#define BR_MCM_ISCR_FOFC(x)  (HW_MCM_ISCR(x).B.FOFC)
/*@}*/

/*!
 * @name Register MCM_ISCR, field FUFC[11] (RO)
 *
 * This read-only bit is a copy of the core's FPSCR[UFC] bit and signals an
 * underflow has been detected in the processor's FPU. Once set, this bit remains set
 * until software clears the FPSCR[UFC] bit.
 *
 * Values:
 * - 0 - No interrupt
 * - 1 - Interrupt occurred
 */
/*@{*/
#define BP_MCM_ISCR_FUFC     (11U)         /*!< Bit position for MCM_ISCR_FUFC. */
#define BM_MCM_ISCR_FUFC     (0x00000800U) /*!< Bit mask for MCM_ISCR_FUFC. */
#define BS_MCM_ISCR_FUFC     (1U)          /*!< Bit field size in bits for MCM_ISCR_FUFC. */

/*! @brief Read current value of the MCM_ISCR_FUFC field. */
#define BR_MCM_ISCR_FUFC(x)  (HW_MCM_ISCR(x).B.FUFC)
/*@}*/

/*!
 * @name Register MCM_ISCR, field FIXC[12] (RO)
 *
 * This read-only bit is a copy of the core's FPSCR[IXC] bit and signals an
 * inexact number has been detected in the processor's FPU. Once set, this bit
 * remains set until software clears the FPSCR[IXC] bit.
 *
 * Values:
 * - 0 - No interrupt
 * - 1 - Interrupt occurred
 */
/*@{*/
#define BP_MCM_ISCR_FIXC     (12U)         /*!< Bit position for MCM_ISCR_FIXC. */
#define BM_MCM_ISCR_FIXC     (0x00001000U) /*!< Bit mask for MCM_ISCR_FIXC. */
#define BS_MCM_ISCR_FIXC     (1U)          /*!< Bit field size in bits for MCM_ISCR_FIXC. */

/*! @brief Read current value of the MCM_ISCR_FIXC field. */
#define BR_MCM_ISCR_FIXC(x)  (HW_MCM_ISCR(x).B.FIXC)
/*@}*/

/*!
 * @name Register MCM_ISCR, field FIDC[15] (RO)
 *
 * This read-only bit is a copy of the core's FPSCR[IDC] bit and signals input
 * denormalized number has been detected in the processor's FPU. Once set, this
 * bit remains set until software clears the FPSCR[IDC] bit.
 *
 * Values:
 * - 0 - No interrupt
 * - 1 - Interrupt occurred
 */
/*@{*/
#define BP_MCM_ISCR_FIDC     (15U)         /*!< Bit position for MCM_ISCR_FIDC. */
#define BM_MCM_ISCR_FIDC     (0x00008000U) /*!< Bit mask for MCM_ISCR_FIDC. */
#define BS_MCM_ISCR_FIDC     (1U)          /*!< Bit field size in bits for MCM_ISCR_FIDC. */

/*! @brief Read current value of the MCM_ISCR_FIDC field. */
#define BR_MCM_ISCR_FIDC(x)  (HW_MCM_ISCR(x).B.FIDC)
/*@}*/

/*!
 * @name Register MCM_ISCR, field FIOCE[24] (RW)
 *
 * Values:
 * - 0 - Disable interrupt
 * - 1 - Enable interrupt
 */
/*@{*/
#define BP_MCM_ISCR_FIOCE    (24U)         /*!< Bit position for MCM_ISCR_FIOCE. */
#define BM_MCM_ISCR_FIOCE    (0x01000000U) /*!< Bit mask for MCM_ISCR_FIOCE. */
#define BS_MCM_ISCR_FIOCE    (1U)          /*!< Bit field size in bits for MCM_ISCR_FIOCE. */

/*! @brief Read current value of the MCM_ISCR_FIOCE field. */
#define BR_MCM_ISCR_FIOCE(x) (HW_MCM_ISCR(x).B.FIOCE)

/*! @brief Format value for bitfield MCM_ISCR_FIOCE. */
#define BF_MCM_ISCR_FIOCE(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_FIOCE) & BM_MCM_ISCR_FIOCE)

/*! @brief Set the FIOCE field to a new value. */
#define BW_MCM_ISCR_FIOCE(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_FIOCE) | BF_MCM_ISCR_FIOCE(v)))
/*@}*/

/*!
 * @name Register MCM_ISCR, field FDZCE[25] (RW)
 *
 * Values:
 * - 0 - Disable interrupt
 * - 1 - Enable interrupt
 */
/*@{*/
#define BP_MCM_ISCR_FDZCE    (25U)         /*!< Bit position for MCM_ISCR_FDZCE. */
#define BM_MCM_ISCR_FDZCE    (0x02000000U) /*!< Bit mask for MCM_ISCR_FDZCE. */
#define BS_MCM_ISCR_FDZCE    (1U)          /*!< Bit field size in bits for MCM_ISCR_FDZCE. */

/*! @brief Read current value of the MCM_ISCR_FDZCE field. */
#define BR_MCM_ISCR_FDZCE(x) (HW_MCM_ISCR(x).B.FDZCE)

/*! @brief Format value for bitfield MCM_ISCR_FDZCE. */
#define BF_MCM_ISCR_FDZCE(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_FDZCE) & BM_MCM_ISCR_FDZCE)

/*! @brief Set the FDZCE field to a new value. */
#define BW_MCM_ISCR_FDZCE(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_FDZCE) | BF_MCM_ISCR_FDZCE(v)))
/*@}*/

/*!
 * @name Register MCM_ISCR, field FOFCE[26] (RW)
 *
 * Values:
 * - 0 - Disable interrupt
 * - 1 - Enable interrupt
 */
/*@{*/
#define BP_MCM_ISCR_FOFCE    (26U)         /*!< Bit position for MCM_ISCR_FOFCE. */
#define BM_MCM_ISCR_FOFCE    (0x04000000U) /*!< Bit mask for MCM_ISCR_FOFCE. */
#define BS_MCM_ISCR_FOFCE    (1U)          /*!< Bit field size in bits for MCM_ISCR_FOFCE. */

/*! @brief Read current value of the MCM_ISCR_FOFCE field. */
#define BR_MCM_ISCR_FOFCE(x) (HW_MCM_ISCR(x).B.FOFCE)

/*! @brief Format value for bitfield MCM_ISCR_FOFCE. */
#define BF_MCM_ISCR_FOFCE(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_FOFCE) & BM_MCM_ISCR_FOFCE)

/*! @brief Set the FOFCE field to a new value. */
#define BW_MCM_ISCR_FOFCE(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_FOFCE) | BF_MCM_ISCR_FOFCE(v)))
/*@}*/

/*!
 * @name Register MCM_ISCR, field FUFCE[27] (RW)
 *
 * Values:
 * - 0 - Disable interrupt
 * - 1 - Enable interrupt
 */
/*@{*/
#define BP_MCM_ISCR_FUFCE    (27U)         /*!< Bit position for MCM_ISCR_FUFCE. */
#define BM_MCM_ISCR_FUFCE    (0x08000000U) /*!< Bit mask for MCM_ISCR_FUFCE. */
#define BS_MCM_ISCR_FUFCE    (1U)          /*!< Bit field size in bits for MCM_ISCR_FUFCE. */

/*! @brief Read current value of the MCM_ISCR_FUFCE field. */
#define BR_MCM_ISCR_FUFCE(x) (HW_MCM_ISCR(x).B.FUFCE)

/*! @brief Format value for bitfield MCM_ISCR_FUFCE. */
#define BF_MCM_ISCR_FUFCE(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_FUFCE) & BM_MCM_ISCR_FUFCE)

/*! @brief Set the FUFCE field to a new value. */
#define BW_MCM_ISCR_FUFCE(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_FUFCE) | BF_MCM_ISCR_FUFCE(v)))
/*@}*/

/*!
 * @name Register MCM_ISCR, field FIXCE[28] (RW)
 *
 * Values:
 * - 0 - Disable interrupt
 * - 1 - Enable interrupt
 */
/*@{*/
#define BP_MCM_ISCR_FIXCE    (28U)         /*!< Bit position for MCM_ISCR_FIXCE. */
#define BM_MCM_ISCR_FIXCE    (0x10000000U) /*!< Bit mask for MCM_ISCR_FIXCE. */
#define BS_MCM_ISCR_FIXCE    (1U)          /*!< Bit field size in bits for MCM_ISCR_FIXCE. */

/*! @brief Read current value of the MCM_ISCR_FIXCE field. */
#define BR_MCM_ISCR_FIXCE(x) (HW_MCM_ISCR(x).B.FIXCE)

/*! @brief Format value for bitfield MCM_ISCR_FIXCE. */
#define BF_MCM_ISCR_FIXCE(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_FIXCE) & BM_MCM_ISCR_FIXCE)

/*! @brief Set the FIXCE field to a new value. */
#define BW_MCM_ISCR_FIXCE(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_FIXCE) | BF_MCM_ISCR_FIXCE(v)))
/*@}*/

/*!
 * @name Register MCM_ISCR, field FIDCE[31] (RW)
 *
 * Values:
 * - 0 - Disable interrupt
 * - 1 - Enable interrupt
 */
/*@{*/
#define BP_MCM_ISCR_FIDCE    (31U)         /*!< Bit position for MCM_ISCR_FIDCE. */
#define BM_MCM_ISCR_FIDCE    (0x80000000U) /*!< Bit mask for MCM_ISCR_FIDCE. */
#define BS_MCM_ISCR_FIDCE    (1U)          /*!< Bit field size in bits for MCM_ISCR_FIDCE. */

/*! @brief Read current value of the MCM_ISCR_FIDCE field. */
#define BR_MCM_ISCR_FIDCE(x) (HW_MCM_ISCR(x).B.FIDCE)

/*! @brief Format value for bitfield MCM_ISCR_FIDCE. */
#define BF_MCM_ISCR_FIDCE(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ISCR_FIDCE) & BM_MCM_ISCR_FIDCE)

/*! @brief Set the FIDCE field to a new value. */
#define BW_MCM_ISCR_FIDCE(x, v) (HW_MCM_ISCR_WR(x, (HW_MCM_ISCR_RD(x) & ~BM_MCM_ISCR_FIDCE) | BF_MCM_ISCR_FIDCE(v)))
/*@}*/

/*******************************************************************************
 * HW_MCM_ETBCC - ETB Counter Control register
 ******************************************************************************/

/*!
 * @brief HW_MCM_ETBCC - ETB Counter Control register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_mcm_etbcc
{
    uint32_t U;
    struct _hw_mcm_etbcc_bitfields
    {
        uint32_t CNTEN : 1;            /*!< [0] Counter Enable */
        uint32_t RSPT : 2;             /*!< [2:1] Response Type */
        uint32_t RLRQ : 1;             /*!< [3] Reload Request */
        uint32_t ETDIS : 1;            /*!< [4] ETM-To-TPIU Disable */
        uint32_t ITDIS : 1;            /*!< [5] ITM-To-TPIU Disable */
        uint32_t RESERVED0 : 26;       /*!< [31:6]  */
    } B;
} hw_mcm_etbcc_t;

/*!
 * @name Constants and macros for entire MCM_ETBCC register
 */
/*@{*/
#define HW_MCM_ETBCC_ADDR(x)     ((x) + 0x14U)

#define HW_MCM_ETBCC(x)          (*(__IO hw_mcm_etbcc_t *) HW_MCM_ETBCC_ADDR(x))
#define HW_MCM_ETBCC_RD(x)       (HW_MCM_ETBCC(x).U)
#define HW_MCM_ETBCC_WR(x, v)    (HW_MCM_ETBCC(x).U = (v))
#define HW_MCM_ETBCC_SET(x, v)   (HW_MCM_ETBCC_WR(x, HW_MCM_ETBCC_RD(x) |  (v)))
#define HW_MCM_ETBCC_CLR(x, v)   (HW_MCM_ETBCC_WR(x, HW_MCM_ETBCC_RD(x) & ~(v)))
#define HW_MCM_ETBCC_TOG(x, v)   (HW_MCM_ETBCC_WR(x, HW_MCM_ETBCC_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCM_ETBCC bitfields
 */

/*!
 * @name Register MCM_ETBCC, field CNTEN[0] (RW)
 *
 * Enables the ETB counter.
 *
 * Values:
 * - 0 - ETB counter disabled
 * - 1 - ETB counter enabled
 */
/*@{*/
#define BP_MCM_ETBCC_CNTEN   (0U)          /*!< Bit position for MCM_ETBCC_CNTEN. */
#define BM_MCM_ETBCC_CNTEN   (0x00000001U) /*!< Bit mask for MCM_ETBCC_CNTEN. */
#define BS_MCM_ETBCC_CNTEN   (1U)          /*!< Bit field size in bits for MCM_ETBCC_CNTEN. */

/*! @brief Read current value of the MCM_ETBCC_CNTEN field. */
#define BR_MCM_ETBCC_CNTEN(x) (HW_MCM_ETBCC(x).B.CNTEN)

/*! @brief Format value for bitfield MCM_ETBCC_CNTEN. */
#define BF_MCM_ETBCC_CNTEN(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ETBCC_CNTEN) & BM_MCM_ETBCC_CNTEN)

/*! @brief Set the CNTEN field to a new value. */
#define BW_MCM_ETBCC_CNTEN(x, v) (HW_MCM_ETBCC_WR(x, (HW_MCM_ETBCC_RD(x) & ~BM_MCM_ETBCC_CNTEN) | BF_MCM_ETBCC_CNTEN(v)))
/*@}*/

/*!
 * @name Register MCM_ETBCC, field RSPT[2:1] (RW)
 *
 * Values:
 * - 00 - No response when the ETB count expires
 * - 01 - Generate a normal interrupt when the ETB count expires
 * - 10 - Generate an NMI when the ETB count expires
 * - 11 - Generate a debug halt when the ETB count expires
 */
/*@{*/
#define BP_MCM_ETBCC_RSPT    (1U)          /*!< Bit position for MCM_ETBCC_RSPT. */
#define BM_MCM_ETBCC_RSPT    (0x00000006U) /*!< Bit mask for MCM_ETBCC_RSPT. */
#define BS_MCM_ETBCC_RSPT    (2U)          /*!< Bit field size in bits for MCM_ETBCC_RSPT. */

/*! @brief Read current value of the MCM_ETBCC_RSPT field. */
#define BR_MCM_ETBCC_RSPT(x) (HW_MCM_ETBCC(x).B.RSPT)

/*! @brief Format value for bitfield MCM_ETBCC_RSPT. */
#define BF_MCM_ETBCC_RSPT(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ETBCC_RSPT) & BM_MCM_ETBCC_RSPT)

/*! @brief Set the RSPT field to a new value. */
#define BW_MCM_ETBCC_RSPT(x, v) (HW_MCM_ETBCC_WR(x, (HW_MCM_ETBCC_RD(x) & ~BM_MCM_ETBCC_RSPT) | BF_MCM_ETBCC_RSPT(v)))
/*@}*/

/*!
 * @name Register MCM_ETBCC, field RLRQ[3] (RW)
 *
 * Reloads the ETB packet counter with the MCM_ETBRL RELOAD value. If IRQ or NMI
 * interrupts were enabled and an NMI or IRQ interrupt was generated on counter
 * expiration, setting this bit clears the pending NMI or IRQ interrupt request.
 * If debug halt was enabled and a debug halt request was asserted on counter
 * expiration, setting this bit clears the debug halt request.
 *
 * Values:
 * - 0 - No effect
 * - 1 - Clears pending debug halt, NMI, or IRQ interrupt requests
 */
/*@{*/
#define BP_MCM_ETBCC_RLRQ    (3U)          /*!< Bit position for MCM_ETBCC_RLRQ. */
#define BM_MCM_ETBCC_RLRQ    (0x00000008U) /*!< Bit mask for MCM_ETBCC_RLRQ. */
#define BS_MCM_ETBCC_RLRQ    (1U)          /*!< Bit field size in bits for MCM_ETBCC_RLRQ. */

/*! @brief Read current value of the MCM_ETBCC_RLRQ field. */
#define BR_MCM_ETBCC_RLRQ(x) (HW_MCM_ETBCC(x).B.RLRQ)

/*! @brief Format value for bitfield MCM_ETBCC_RLRQ. */
#define BF_MCM_ETBCC_RLRQ(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ETBCC_RLRQ) & BM_MCM_ETBCC_RLRQ)

/*! @brief Set the RLRQ field to a new value. */
#define BW_MCM_ETBCC_RLRQ(x, v) (HW_MCM_ETBCC_WR(x, (HW_MCM_ETBCC_RD(x) & ~BM_MCM_ETBCC_RLRQ) | BF_MCM_ETBCC_RLRQ(v)))
/*@}*/

/*!
 * @name Register MCM_ETBCC, field ETDIS[4] (RW)
 *
 * Disables the trace path from ETM to TPIU.
 *
 * Values:
 * - 0 - ETM-to-TPIU trace path enabled
 * - 1 - ETM-to-TPIU trace path disabled
 */
/*@{*/
#define BP_MCM_ETBCC_ETDIS   (4U)          /*!< Bit position for MCM_ETBCC_ETDIS. */
#define BM_MCM_ETBCC_ETDIS   (0x00000010U) /*!< Bit mask for MCM_ETBCC_ETDIS. */
#define BS_MCM_ETBCC_ETDIS   (1U)          /*!< Bit field size in bits for MCM_ETBCC_ETDIS. */

/*! @brief Read current value of the MCM_ETBCC_ETDIS field. */
#define BR_MCM_ETBCC_ETDIS(x) (HW_MCM_ETBCC(x).B.ETDIS)

/*! @brief Format value for bitfield MCM_ETBCC_ETDIS. */
#define BF_MCM_ETBCC_ETDIS(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ETBCC_ETDIS) & BM_MCM_ETBCC_ETDIS)

/*! @brief Set the ETDIS field to a new value. */
#define BW_MCM_ETBCC_ETDIS(x, v) (HW_MCM_ETBCC_WR(x, (HW_MCM_ETBCC_RD(x) & ~BM_MCM_ETBCC_ETDIS) | BF_MCM_ETBCC_ETDIS(v)))
/*@}*/

/*!
 * @name Register MCM_ETBCC, field ITDIS[5] (RW)
 *
 * Disables the trace path from ITM to TPIU.
 *
 * Values:
 * - 0 - ITM-to-TPIU trace path enabled
 * - 1 - ITM-to-TPIU trace path disabled
 */
/*@{*/
#define BP_MCM_ETBCC_ITDIS   (5U)          /*!< Bit position for MCM_ETBCC_ITDIS. */
#define BM_MCM_ETBCC_ITDIS   (0x00000020U) /*!< Bit mask for MCM_ETBCC_ITDIS. */
#define BS_MCM_ETBCC_ITDIS   (1U)          /*!< Bit field size in bits for MCM_ETBCC_ITDIS. */

/*! @brief Read current value of the MCM_ETBCC_ITDIS field. */
#define BR_MCM_ETBCC_ITDIS(x) (HW_MCM_ETBCC(x).B.ITDIS)

/*! @brief Format value for bitfield MCM_ETBCC_ITDIS. */
#define BF_MCM_ETBCC_ITDIS(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ETBCC_ITDIS) & BM_MCM_ETBCC_ITDIS)

/*! @brief Set the ITDIS field to a new value. */
#define BW_MCM_ETBCC_ITDIS(x, v) (HW_MCM_ETBCC_WR(x, (HW_MCM_ETBCC_RD(x) & ~BM_MCM_ETBCC_ITDIS) | BF_MCM_ETBCC_ITDIS(v)))
/*@}*/

/*******************************************************************************
 * HW_MCM_ETBRL - ETB Reload register
 ******************************************************************************/

/*!
 * @brief HW_MCM_ETBRL - ETB Reload register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_mcm_etbrl
{
    uint32_t U;
    struct _hw_mcm_etbrl_bitfields
    {
        uint32_t RELOAD : 11;          /*!< [10:0] Byte Count Reload Value */
        uint32_t RESERVED0 : 21;       /*!< [31:11]  */
    } B;
} hw_mcm_etbrl_t;

/*!
 * @name Constants and macros for entire MCM_ETBRL register
 */
/*@{*/
#define HW_MCM_ETBRL_ADDR(x)     ((x) + 0x18U)

#define HW_MCM_ETBRL(x)          (*(__IO hw_mcm_etbrl_t *) HW_MCM_ETBRL_ADDR(x))
#define HW_MCM_ETBRL_RD(x)       (HW_MCM_ETBRL(x).U)
#define HW_MCM_ETBRL_WR(x, v)    (HW_MCM_ETBRL(x).U = (v))
#define HW_MCM_ETBRL_SET(x, v)   (HW_MCM_ETBRL_WR(x, HW_MCM_ETBRL_RD(x) |  (v)))
#define HW_MCM_ETBRL_CLR(x, v)   (HW_MCM_ETBRL_WR(x, HW_MCM_ETBRL_RD(x) & ~(v)))
#define HW_MCM_ETBRL_TOG(x, v)   (HW_MCM_ETBRL_WR(x, HW_MCM_ETBRL_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCM_ETBRL bitfields
 */

/*!
 * @name Register MCM_ETBRL, field RELOAD[10:0] (RW)
 *
 * Indicates the 0-mod-4 value the counter reloads to. Writing a non-0-mod-4
 * value to this field results in a bus error.
 */
/*@{*/
#define BP_MCM_ETBRL_RELOAD  (0U)          /*!< Bit position for MCM_ETBRL_RELOAD. */
#define BM_MCM_ETBRL_RELOAD  (0x000007FFU) /*!< Bit mask for MCM_ETBRL_RELOAD. */
#define BS_MCM_ETBRL_RELOAD  (11U)         /*!< Bit field size in bits for MCM_ETBRL_RELOAD. */

/*! @brief Read current value of the MCM_ETBRL_RELOAD field. */
#define BR_MCM_ETBRL_RELOAD(x) (HW_MCM_ETBRL(x).B.RELOAD)

/*! @brief Format value for bitfield MCM_ETBRL_RELOAD. */
#define BF_MCM_ETBRL_RELOAD(v) ((uint32_t)((uint32_t)(v) << BP_MCM_ETBRL_RELOAD) & BM_MCM_ETBRL_RELOAD)

/*! @brief Set the RELOAD field to a new value. */
#define BW_MCM_ETBRL_RELOAD(x, v) (HW_MCM_ETBRL_WR(x, (HW_MCM_ETBRL_RD(x) & ~BM_MCM_ETBRL_RELOAD) | BF_MCM_ETBRL_RELOAD(v)))
/*@}*/

/*******************************************************************************
 * HW_MCM_ETBCNT - ETB Counter Value register
 ******************************************************************************/

/*!
 * @brief HW_MCM_ETBCNT - ETB Counter Value register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_mcm_etbcnt
{
    uint32_t U;
    struct _hw_mcm_etbcnt_bitfields
    {
        uint32_t COUNTER : 11;         /*!< [10:0] Byte Count Counter Value */
        uint32_t RESERVED0 : 21;       /*!< [31:11]  */
    } B;
} hw_mcm_etbcnt_t;

/*!
 * @name Constants and macros for entire MCM_ETBCNT register
 */
/*@{*/
#define HW_MCM_ETBCNT_ADDR(x)    ((x) + 0x1CU)

#define HW_MCM_ETBCNT(x)         (*(__I hw_mcm_etbcnt_t *) HW_MCM_ETBCNT_ADDR(x))
#define HW_MCM_ETBCNT_RD(x)      (HW_MCM_ETBCNT(x).U)
/*@}*/

/*
 * Constants & macros for individual MCM_ETBCNT bitfields
 */

/*!
 * @name Register MCM_ETBCNT, field COUNTER[10:0] (RO)
 *
 * Indicates the current 0-mod-4 value of the counter.
 */
/*@{*/
#define BP_MCM_ETBCNT_COUNTER (0U)         /*!< Bit position for MCM_ETBCNT_COUNTER. */
#define BM_MCM_ETBCNT_COUNTER (0x000007FFU) /*!< Bit mask for MCM_ETBCNT_COUNTER. */
#define BS_MCM_ETBCNT_COUNTER (11U)        /*!< Bit field size in bits for MCM_ETBCNT_COUNTER. */

/*! @brief Read current value of the MCM_ETBCNT_COUNTER field. */
#define BR_MCM_ETBCNT_COUNTER(x) (HW_MCM_ETBCNT(x).B.COUNTER)
/*@}*/

/*******************************************************************************
 * HW_MCM_PID - Process ID register
 ******************************************************************************/

/*!
 * @brief HW_MCM_PID - Process ID register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register drives the M0_PID and M1_PID values in the Memory Protection
 * Unit(MPU). System software loads this register before passing control to a given
 * user mode process. If the PID of the process does not match the value in this
 * register, a bus error occurs. See the MPU chapter for more details.
 */
typedef union _hw_mcm_pid
{
    uint32_t U;
    struct _hw_mcm_pid_bitfields
    {
        uint32_t PID : 8;              /*!< [7:0] M0_PID And M1_PID For MPU */
        uint32_t RESERVED0 : 24;       /*!< [31:8]  */
    } B;
} hw_mcm_pid_t;

/*!
 * @name Constants and macros for entire MCM_PID register
 */
/*@{*/
#define HW_MCM_PID_ADDR(x)       ((x) + 0x30U)

#define HW_MCM_PID(x)            (*(__IO hw_mcm_pid_t *) HW_MCM_PID_ADDR(x))
#define HW_MCM_PID_RD(x)         (HW_MCM_PID(x).U)
#define HW_MCM_PID_WR(x, v)      (HW_MCM_PID(x).U = (v))
#define HW_MCM_PID_SET(x, v)     (HW_MCM_PID_WR(x, HW_MCM_PID_RD(x) |  (v)))
#define HW_MCM_PID_CLR(x, v)     (HW_MCM_PID_WR(x, HW_MCM_PID_RD(x) & ~(v)))
#define HW_MCM_PID_TOG(x, v)     (HW_MCM_PID_WR(x, HW_MCM_PID_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual MCM_PID bitfields
 */

/*!
 * @name Register MCM_PID, field PID[7:0] (RW)
 *
 * Drives the M0_PID and M1_PID values in the MPU.
 */
/*@{*/
#define BP_MCM_PID_PID       (0U)          /*!< Bit position for MCM_PID_PID. */
#define BM_MCM_PID_PID       (0x000000FFU) /*!< Bit mask for MCM_PID_PID. */
#define BS_MCM_PID_PID       (8U)          /*!< Bit field size in bits for MCM_PID_PID. */

/*! @brief Read current value of the MCM_PID_PID field. */
#define BR_MCM_PID_PID(x)    (HW_MCM_PID(x).B.PID)

/*! @brief Format value for bitfield MCM_PID_PID. */
#define BF_MCM_PID_PID(v)    ((uint32_t)((uint32_t)(v) << BP_MCM_PID_PID) & BM_MCM_PID_PID)

/*! @brief Set the PID field to a new value. */
#define BW_MCM_PID_PID(x, v) (HW_MCM_PID_WR(x, (HW_MCM_PID_RD(x) & ~BM_MCM_PID_PID) | BF_MCM_PID_PID(v)))
/*@}*/

/*******************************************************************************
 * hw_mcm_t - module struct
 ******************************************************************************/
/*!
 * @brief All MCM module registers.
 */
#pragma pack(1)
typedef struct _hw_mcm
{
    uint8_t _reserved0[8];
    __I hw_mcm_plasc_t PLASC;              /*!< [0x8] Crossbar Switch (AXBS) Slave Configuration */
    __I hw_mcm_plamc_t PLAMC;              /*!< [0xA] Crossbar Switch (AXBS) Master Configuration */
    __IO hw_mcm_cr_t CR;                   /*!< [0xC] Control Register */
    __IO hw_mcm_iscr_t ISCR;               /*!< [0x10] Interrupt Status Register */
    __IO hw_mcm_etbcc_t ETBCC;             /*!< [0x14] ETB Counter Control register */
    __IO hw_mcm_etbrl_t ETBRL;             /*!< [0x18] ETB Reload register */
    __I hw_mcm_etbcnt_t ETBCNT;            /*!< [0x1C] ETB Counter Value register */
    uint8_t _reserved1[16];
    __IO hw_mcm_pid_t PID;                 /*!< [0x30] Process ID register */
} hw_mcm_t;
#pragma pack()

/*! @brief Macro to access all MCM registers. */
/*! @param x MCM module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_MCM(MCM_BASE)</code>. */
#define HW_MCM(x)      (*(hw_mcm_t *)(x))

#endif /* __HW_MCM_REGISTERS_H__ */
/* EOF */
