#include "mbed.h"
#include "ADT7410.h"

ADT7410::ADT7410(PinName sda, PinName scl) : i2c(sda, scl) {
    // set config (16bit resolution)
    send(ADT7410_CFG_ADDR, 0x80);
}

void ADT7410::send(char data_0, char data_1) {
    buf[0] = data_0;
    buf[1] = data_1;

    i2c.write(ADT7410_I2C_ADDR, buf, 2);
}

void ADT7410::recv(char data) {
    buf[0] = data;

    // no stop condition (restared)
    i2c.write(ADT7410_I2C_ADDR, buf, 1, true);
    i2c.read(ADT7410_I2C_ADDR, buf, 2);
}

float ADT7410::temp_value() {
    int temp;
    float temp_fix;

    // set config (16bit resolution with one shot mode)
    send(ADT7410_CFG_ADDR, 0xA0);
    wait_ms(250);
    // recieve temperatue value(high and low)
    recv(ADT7410_TMPH_ADDR);
    temp = buf[0] << 0x08;
    temp += buf[1];

    if (temp & 0x8000) {
        temp_fix = (float)(temp - 65536) / 128;
    } else {
        temp_fix = (float)temp / 128;
    }

    return temp_fix;
}
