#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "TCPPacket.h"

/**** Selection of PEACH *****/
#define USE_PEACH       (1)     /* 1(PEACH No1) or 2(PEACH No2) or 3(PEACH No3) */
/*****************************/

#if USE_PEACH == 1      /* in case of PEACH No1 */
Thread            TCPTask;
EthernetInterface eth;
DigitalOut        led1(LED1);

static tcp_packet send_packet;

int TCP_send(tcp_packet* send_data, int length, const char* adress, int port) {
    int ret;
    int retry_cnt = 0;
    TCPSocket socket;

    ret = socket.open(&eth);
    if (ret == 0) {
        printf("Now connecting...\n");
        while (socket.connect(adress, port) < 0) {
            printf("Unable to connect to (%s) on port (%d)\n", adress, port);
            retry_cnt++;
            if (retry_cnt >= TCPSEND_CONN_RETRY_MAX) {
                socket.close();
                return -1;
            }
        }
        ret = socket.send((char*)send_data, length);
        socket.close();
    }

    return ret;
}

void tcp_comm_task(void) {
    int ret;

    memset(&send_packet, 0, sizeof(send_packet));
    eth.set_network(PEACH_1_IP_ADDRESS, SUB_NET_MASK, DEFAULT_GATEWAY);
    ret = eth.connect();
    if (ret == 0) {
        printf("IP Address is %s\n", eth.get_ip_address());

        send_packet.data = 0;
        while (1) {
            // create data
            if (send_packet.data < 0xFF) {
                send_packet.data++;
            } else {
                send_packet.data = 0;
            }
            // Send message
            ret = TCP_send(&send_packet, sizeof(send_packet), PEACH_2_IP_ADDRESS, PEACH_2_PORT);
            if (ret >= 0) {
                printf("Send  message : %d\n", send_packet.data);
                led1 = !led1;
            } else {
                printf("send failed!!\n");
            }
            Thread::wait(1000);
        }
    } else {
        printf("Network Connect Error \n");
    }
}

/****** main ******/
int main(void) {
    printf("GR-PEACH No1 sample start!!\n");

    /* Start TCP communicationl processing */
    TCPTask.start(callback(tcp_comm_task));

    /* Wait for the threads to finish */
    TCPTask.join();
}

// set mac address
void mbed_mac_address(char *mac) {
    mac[0] = 0x74;
    mac[1] = 0x90;
    mac[2] = 0x50;
    mac[3] = 0x00;
    mac[4] = 0x56;
    mac[5] = 0xA1;
}

#elif USE_PEACH == 2    /* in case of PEACH No2 */
Thread            TCPTask;
EthernetInterface eth;
TCPServer         server;
DigitalOut        led2(LED2);

#define CONNECT_PENDING_NUM         (2)
static tcp_packet send_packet;
static tcp_packet recv_packet;

int TCP_send(tcp_packet* send_data, int length, const char* adress, int port) {
    int ret;
    int retry_cnt = 0;
    TCPSocket socket;

    ret = socket.open(&eth);
    if (ret == 0) {
        printf("Now connecting...\n");
        while (socket.connect(adress, port) < 0) {
            printf("Unable to connect to (%s) on port (%d)\n", adress, port);
            retry_cnt++;
            if (retry_cnt >= TCPSEND_CONN_RETRY_MAX) {
                socket.close();
                return -1;
            }
        }
        ret = socket.send((char*)send_data, length);
        socket.close();
    }

    return ret;
}

static int TCP_receive(tcp_packet* recv_data, int length) {
    int ret;
    TCPSocket client;

    ret = server.accept(&client);
    if (ret == 0) {
        client.set_blocking(false);
        client.set_timeout(1500); // Timeout after 1.5s(default)

        ret = client.recv((char*)recv_data, length);
        client.close();
    }

    return ret;
}

void tcp_comm_task(void) {
    int ret;

    memset(&send_packet, 0, sizeof(send_packet));
    memset(&recv_packet, 0, sizeof(recv_packet));
    eth.set_network(PEACH_2_IP_ADDRESS, SUB_NET_MASK, DEFAULT_GATEWAY);
    ret = eth.connect();
    if (ret == 0) {
        printf("IP Address is %s\n", eth.get_ip_address());

        server.open(&eth);
        server.bind(PEACH_2_PORT);
        server.listen(CONNECT_PENDING_NUM);   // number of pending connections
        while (1) {
            // Receive message
            ret = TCP_receive(&recv_packet, sizeof(recv_packet));
            if (ret >= 0) {
                printf("Received message : %d\n", recv_packet.data);
                // Send message
                memcpy(&send_packet, &recv_packet, sizeof(send_packet));
                ret = TCP_send(&send_packet, sizeof(send_packet), PEACH_3_IP_ADDRESS, PEACH_3_PORT);
                if (ret >= 0) {
                    printf("Send  message : %d\n", send_packet.data);
                    led2 = !led2;
                } else {
                    printf("send failed!!\n");
                }
            } else {
                printf("receive failed!!\n");
            }
            Thread::wait(100);
        }
    } else {
        printf("Network Connect Error \n");
    }
}

/****** main ******/
int main(void) {
    printf("GR-PEACH No2 sample start!!\n");

    /* Start TCP communicationl processing */
    TCPTask.start(callback(tcp_comm_task));

    /* Wait for the threads to finish */
    TCPTask.join();
}

// set mac address
void mbed_mac_address(char *mac) {
    mac[0] = 0x74;
    mac[1] = 0x90;
    mac[2] = 0x50;
    mac[3] = 0x00;
    mac[4] = 0x56;
    mac[5] = 0xA2;
}

#elif USE_PEACH == 3    /* in case of PEACH No3 */
Thread            TCPTask;
EthernetInterface eth;
TCPServer         server;
DigitalOut        led3(LED3);

#define CONNECT_PENDING_NUM         (2)
static tcp_packet recv_packet;

static int TCP_receive(tcp_packet* recv_data, int length) {
    int ret;
    TCPSocket client;

    ret = server.accept(&client);
    if (ret == 0) {
        client.set_blocking(false);
        client.set_timeout(1500); // Timeout after 1.5s(default)

        ret = client.recv((char*)recv_data, length);
        client.close();
    }

    return ret;
}

void tcp_comm_task(void) {
    int ret;

    memset(&recv_packet, 0, sizeof(recv_packet));
    eth.set_network(PEACH_3_IP_ADDRESS, SUB_NET_MASK, DEFAULT_GATEWAY);
    ret = eth.connect();
    if (ret == 0) {
        printf("IP Address is %s\n", eth.get_ip_address());

        server.open(&eth);
        server.bind(PEACH_3_PORT);
        server.listen(CONNECT_PENDING_NUM);   // number of pending connections
        while (1) {
            // Receive message
            ret = TCP_receive(&recv_packet, sizeof(recv_packet));
            if (ret >= 0) {
                printf("Received message : %d\n", recv_packet.data);
                led3 = !led3;
            } else {
                printf("receive failed!!\n");
            }
            Thread::wait(100);
        }
    } else {
        printf("Network Connect Error \n");
    }
}

/****** main ******/
int main(void) {
    printf("GR-PEACH No3 sample start!!\n");

    /* Start TCP communicationl processing */
    TCPTask.start(callback(tcp_comm_task));

    /* Wait for the threads to finish */
    TCPTask.join();
}

// set mac address
void mbed_mac_address(char *mac) {
    mac[0] = 0x74;
    mac[1] = 0x90;
    mac[2] = 0x50;
    mac[3] = 0x00;
    mac[4] = 0x56;
    mac[5] = 0xA3;
}

#endif
