/*
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "rga_func.h"
#include "Images/BinaryImage_RZ_A1H.h"

#define ZOOM_SRC_CENTER_X                   IMAGE_WIDTH_ZOOM_FUNC / 2
#define ZOOM_SRC_CENTER_Y                   IMAGE_HEIGHT_ZOOM_FUNC / 2

Canvas2D_ContextClass canvas2d;

void Set_RGAObject(frame_buffer_t* frmbuf_info) {
    errnum_t err;
    Canvas2D_ContextConfigClass config;

    config.frame_buffer = frmbuf_info;
    canvas2d = R_RGA_New_Canvas2D_ContextClass(config);
    err = R_OSPL_GetErrNum();
    if (err != 0) {
        printf("Line %d, error %d\n", __LINE__, err);
        while (1);
    }
}

void RGA_Func_Zoom(frame_buffer_t* frmbuf_info, int src_height_pos) {
    /* Clear */
    canvas2d.clearRect(0, 0, frmbuf_info->width, frmbuf_info->height);
    /* Zoom out */
    canvas2d.drawImage(Landscape_wide_jpg_File,
                        /* src X */     ZOOM_SRC_CENTER_X - (src_height_pos * IMG_DRAW_WIDTH / IMG_DRAW_HEIGHT),
                        /* src Y */     ZOOM_SRC_CENTER_Y - src_height_pos,
                        /* src W */     src_height_pos * 2 * IMG_DRAW_WIDTH / IMG_DRAW_HEIGHT,
                        /* src H */     src_height_pos * 2,
                        /* dst   */     10, 10, IMG_DRAW_WIDTH, IMG_DRAW_HEIGHT);

    /* Complete drawing */
    R_GRAPHICS_Finish(canvas2d.c_LanguageContext);
}
