/*
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "rga_func.h"

Canvas2D_ContextClass canvas2d;

void Set_RGAObject(frame_buffer_t* frmbuf_info) {
    errnum_t err;
    Canvas2D_ContextConfigClass config;

    config.frame_buffer = frmbuf_info;
    canvas2d = R_RGA_New_Canvas2D_ContextClass(config);
    err = R_OSPL_GetErrNum();
    if (err != 0) {
        printf("Line %d, error %d\n", __LINE__, err);
        while (1);
    }
}

void RGA_Func_DrawTopScreen(frame_buffer_t* frmbuf_info, const graphics_image_t* image) {
    canvas2d.drawImage((const graphics_image_t*)image, 0, 0);

    /* Complete drawing */
    R_GRAPHICS_Finish(canvas2d.c_LanguageContext);
}

void RGA_Func_Scroll(frame_buffer_t* frmbuf_info, const graphics_image_t* image_old, const graphics_image_t* image_new,
                     int direction, float32_t scroll) {
    canvas2d.drawImage((const graphics_image_t*)image_old, 0, 0);

    /* Scroll */
    switch (direction) {
        case DIREC_RIGHT:
            canvas2d.drawImage((const graphics_image_t*)image_new,
                               ((int)(frmbuf_info->width * scroll) - frmbuf_info->width) * 1, 0,
                               frmbuf_info->width, frmbuf_info->height);
            break;
        case DIREC_LEFT:
            canvas2d.drawImage((const graphics_image_t*)image_new,
                               ((int)(frmbuf_info->width * scroll) - frmbuf_info->width) * -1, 0,
                               frmbuf_info->width, frmbuf_info->height);
            break;
        case DIREC_UP:
            canvas2d.drawImage((const graphics_image_t*)image_new,
                               0, ((int)(frmbuf_info->height * scroll) - frmbuf_info->height) * -1, 
                               frmbuf_info->width, frmbuf_info->height);
            break;
        case DIREC_DOWN:
            canvas2d.drawImage((const graphics_image_t*)image_new,
                               0, ((int)(frmbuf_info->height * scroll) - frmbuf_info->height) * 1, 
                               frmbuf_info->width, frmbuf_info->height);
            break;
        default :
            break;
    }

    /* Complete drawing */
    R_GRAPHICS_Finish(canvas2d.c_LanguageContext);
}

