/*
Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "rga_func.h"
#include "Images/BinaryImage_RZ_A1H.h"

Canvas2D_ContextClass canvas2d;

void Set_RGAObject(frame_buffer_t* frmbuf_info) {
    errnum_t err;
    Canvas2D_ContextConfigClass config;

    config.frame_buffer = frmbuf_info;
    canvas2d = R_RGA_New_Canvas2D_ContextClass(config);
    err = R_OSPL_GetErrNum();
    if (err != 0) {
        printf("Line %d, error %d\n", __LINE__, err);
        while (1);
    }
}

void RGA_Func_Rotation(frame_buffer_t* frmbuf_info, graphics_matrix_float_t image_angle) {
    /* Rotate the image */
    /* Clear */
    canvas2d.clearRect(0, 0, frmbuf_info->width, frmbuf_info->height);

    /* Move to drawing position */
    canvas2d.translate((155 + (IMG_DRAW_WIDTH / 2)), (73 + (IMG_DRAW_HEIGHT / 2)));

    /* Rotate */
    canvas2d.rotate(image_angle * (3.14159 / 180));

    /* Move to center to rotate */
    canvas2d.translate((-IMG_DRAW_WIDTH / 2), (-IMG_DRAW_HEIGHT / 2));
    canvas2d.drawImage(Flower_jpg_File, 0, 0);
    canvas2d.setTransform(1, 0, 0, 1, 0, 0);

    /* Complete drawing */
    R_GRAPHICS_Finish(canvas2d.c_LanguageContext);
}
