#include "mbed.h"

AnalogIn ain(A0);
DigitalOut led1(LED_RED);
Ticker flipper;
int f_sen = 0;

void flip() {
    float tmp1 = 0;
    float tmp2 = 0;
    float data;
    float distance;

    tmp1 = ain;
    tmp2 = ain;
    data = (tmp1 + tmp2) / 2.0f;

    if ((0.121 <= data) && (data <= 0.970)) {
        distance = 26.663 * pow((data * 3.3),-1.25);
        printf("Distance : %4.3f[cm]\n",distance);
        f_sen = 1;
    } else {
        printf("Distance : ------[cm]\n");
        f_sen = 0;
    }
}

int main() {

    printf("Sensor start!\n");
    flipper.attach_us(&flip, 500000);//500ms 
    while(1) {
        if(f_sen == 1){
            led1 = 1;
        } else {
            led1 = 0;
        }
        wait(0.5);
    }
}
