#include "Snake.h"


#define WIDTH 84
#define HEIGHT 48
#define CEILING 8
#define FLOOR 48

snakePart snak;
int LIFE[7][7] = {
    
    {0,1,0,0,0,1,0},
    {1,1,1,0,1,1,1},
    {1,1,1,1,1,1,1},
    {0,1,1,1,1,1,0},
    {0,0,1,1,1,0,0},
    {0,0,0,1,0,0,0},
    };


Snake::Snake()
{

}
Snake::~Snake()
{
  
}

/************************Functions************************/

void Snake::init(int x, int y, int length, int _live){//initalizing the starting variables     
    live=_live;
    _length = length;    
    _food.init();
    initx=x;
    inity=y;
    initl=length;
    snak._x[0] = x;
    snak._y[0] = y;
    snak._dirc[0] = 1;
    for (int i=1; i < _length ;i++)
    {   
        snak._x[i]=snak._x[0]+i;
        snak._y[i]=snak._y[0];
        snak._dirc[i]=1;
    }
    snak._x[_length]=x+_length-1;
    snak._y[_length]=y;
    snak._dirc[_length]=1;
}

void Snake::drawsnake(N5110 &lcd, Gamepad &pad){
        check_WallCollision(lcd,pad);
        check_TailCollision(lcd,pad);
            if (live!=0){
                lcd.clear();
                waitExpect=((float)_length/4)+6;
                waitTime=(1/(waitExpect+_speed));
                wait(waitTime);                
                _food.drawfood(lcd);
                lcd.drawRect(0,8,84,48-9,FILL_TRANSPARENT);
                drawscore(lcd);
                for ( int i=0; i < _length ;i++){
                    
                                    lcd.setPixel(snak._x[i],snak._y[i]);
                lcd.refresh();
                }
       }
       
}
void Snake::snakemov(Gamepad &pad){
     
     if (live!=0){
              d=pad.get_direction();
              if (d==N){
                
                        if (snak._dirc[_length-1]!=4)
                            {
                                snak._dirc[_length-1] = 2;   
                                snak._dirc[_length] = 2;                          
                            }

            }
            
            if (d==E){
                
                        if (snak._dirc[_length-1]!=3)
                            {
                                snak._dirc[_length-1] = 1;
                                snak._dirc[_length] = 1;                                    
                            }
                
                }
                
            if (d==W){
                
                        if (snak._dirc[_length-1]!=1)
                            {
                                snak._dirc[_length-1] = 3;
                                snak._dirc[_length] = 3;     
                            }
                
                
                }
                
            if (d==S){
                
                        if (snak._dirc[_length-1]!=2)
                            {
                                snak._dirc[_length-1] = 4;
                                snak._dirc[_length] = 4;     
                            }
                
                
                }
                
            if (snak._dirc[_length-1]==1)
                {   
                    snak._x[_length] = snak._x[_length] + 1; 
                   
                }
            
            if (snak._dirc[_length-1]==2)
                {
                    snak._y[_length] = snak._y[_length] - 1;

                
                }
            
            if (snak._dirc[_length-1]==3)
                {
                    snak._x[_length] = snak._x[_length] - 1; 
                  
                }
                
            if (snak._dirc[_length-1]==4)
                {
                    snak._y[_length] = snak._y[_length] + 1;                                        
                }
                for (int i=0 ;i < _length ;i++)
                {                      
                    snak._x[i]=snak._x[i+1];
                    snak._y[i]=snak._y[i+1];                   
                }
            eat(pad);
        }
}

void Snake::eat(Gamepad &pad){
    
    Foodpos foodPos = _food.returnPos();
    if(snak._x[_length-1]==foodPos.x && snak._y[_length-1]== foodPos.y)
        {
            _length=_length+1;
            snak._x[_length] = snak._x[_length - 1];
            snak._y[_length] = snak._y[_length - 1];
            _food.createfood();
            Tone_1(pad);
        }
}

int Snake::dead(N5110 &lcd, Gamepad &pad){
        
       
        live--; 
        while(live==0) {
            lcd.clear();
            lcd.printString("Game Over",0,1);
            lcd.printString("Press Reset",0,2);
            lcd.printString("To Back",0,4);
            lcd.refresh();
            
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(784.0,0.75); //5-
            wait(0.75);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(587.0,0.5); //2
            wait(0.5);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            pad.tone(587.0,0.5); //2
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(440.0,0.25); //l6.
            wait(0.25);
            pad.tone(659.0,0.75); //3-
            wait(0.75);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(494.0,0.5); //l7
            wait(0.5);
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            pad.tone(494.0,0.5); //l7
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(440.0,0.5); //l6
            wait(0.5);
            pad.tone(494.0,0.5); //l7
            wait(0.5);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(392.0,0.5); //l5
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                } 
            pad.tone(523.0,0.5); //1
            wait(0.5);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(698.0,0.5); //4
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(587.0,0.5); //2
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(0.0,5); //gap
            wait(0.5);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(784.0,0.75); //5-
            wait(0.75);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(587.0,0.5); //2
            wait(0.5);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(587.0,0.5); //2
            wait(0.5);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }
            pad.tone(440.0,0.25); //l6.
            wait(0.25);
            pad.tone(440.0,0.5); //l6
            wait(0.5);
            pad.tone(494.0,0.25); //l7.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(392.0,0.5); //l5
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            pad.tone(0.0,0.25); //gap.
            wait(0.25);
            pad.tone(494.0,0.5); //l7
            wait(0.5);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(392.0,0.5); //l5
            wait(0.5);
            pad.tone(523.0,0.5); //1
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(698.0,0.5); //4
            wait(0.5);
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(523.0,0.5); //1
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(784.0,0.5); //5
            wait(0.5);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(784.0,0.25); //5.
            wait(0.25);
            pad.tone(880.0,0.25); //6.
            wait(0.25);
            pad.tone(784.0,0.25); //5.
            wait(0.25);
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(659.0,0.5); //3
            wait(0.5);
            pad.tone(659.0,0.5); //3
            wait(0.5);
            pad.tone(659.0,0.5); //3
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(659.0,0.5); //3
            wait(0.5);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(523.0,0.5); //1
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(523.0,0.5); //1
            wait(0.5);
            pad.tone(523.0,0.5); //1.
            wait(0.5);
            pad.tone(494.0,0.25); //l7.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(440.0,0.5); //l6
            wait(0.5);
            pad.tone(494.0,0.5); //l7
            wait(0.5);
            pad.tone(494.0,0.25); //l7.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            pad.tone(587.0,0.5); //2
            wait(0.5);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.5); //2
            wait(0.5);
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(784.0,0.5); //5
            wait(0.5);
            pad.tone(784.0,0.5); //5
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(784.0,0.25); //5.
            wait(0.25);
            pad.tone(880.0,0.25); //6.
            wait(0.25);
            pad.tone(784.0,0.25); //5.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            pad.tone(659.0,0.5); //3
            wait(0.5);
            pad.tone(659.0,0.5); //3
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(659.0,0.5); //3
            wait(0.5);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(698.0,0.25); //4.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            
            pad.tone(494.0,0.25); //l7.
            wait(0.25);
            pad.tone(440.0,0.5); //l6
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(440.0,0.25); //l6.
            wait(0.25);
            pad.tone(494.0,0.25); //l7.
            wait(0.25);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(392.0,0.5); //l5
            wait(0.5);
            pad.tone(523.0,0.5); //1
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(659.0,0.25); //3.
            wait(0.25);
            pad.tone(587.0,0.75); //2-
            wait(0.75);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(587.0,0.25); //2.
            wait(0.25);
            pad.tone(523.0,0.25); //1.
            wait(0.25);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  
            pad.tone(523.0,0.5); //1
            wait(0.5);
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            pad.tone(0.0,0.5); //gap
            wait(0.5);
            if(pad.check_event(Gamepad::BACK_PRESSED) == true){
                  return 0;
                }  

        }
        if(Highest_score < (_length - 5)){ 
        Highest_score = _length - 5;
        }
        init(initx,inity,initl,live);
//end of deadSnake
                  return 0;
}

void Snake::Tone_1(Gamepad &pad){
         pad.tone(750.0,0.1);
         }
         
void Snake::check_WallCollision(N5110 &lcd, Gamepad &pad){
    
    if (snak._x[_length] == 0 || snak._x[_length] == WIDTH)//if snake head hits side walls
        {   
            game_music(pad);
            dead(lcd,pad);
        }
    if (snak._y[_length]== FLOOR ||snak._y[_length]== CEILING )
        {   
            game_music(pad);
            dead(lcd,pad);
        }
    
}

void Snake::check_TailCollision(N5110 &lcd, Gamepad &pad){
    for (int i=0 ;i < (_length - 2) ;i++){
                                          
                    if (snak._x[_length-1]==snak._x[i] && snak._y[_length-1]==snak._y[i])
                        {   
                            game_music(pad);
                            dead(lcd,pad);
                        }
                }
    
    
}

void Snake::game_music(Gamepad &pad){
    
    pad.tone(1046.0,0.125); 
    wait(0.125);
    pad.tone(1075.0,0.125); 
    wait(0.125);
    pad.tone(1318.0,0.125); 
    wait(0.125);
    }

void Snake::drawscore(N5110 &lcd){
        char buffer_1[15];
        char buffer_2[15];
        sprintf(buffer_1,"%2d",live);
        sprintf(buffer_2,"%2d",_length-5);
        lcd.printString(buffer_1,20,0);
        lcd.printString(buffer_2,70,0);
        lcd.drawSprite(6,1,7,7,(int *)LIFE);
        lcd.printString(":",17,0);
        lcd.printString("Score:",40,0);
    
}