#ifndef SNAKE_H
#define SNAKE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Food.h"

/**snakePart struct */
struct snakePart{
    char _x[4000];/**< Arrays to store snake X coordinate*/
    char _y[4000];/**< Arrays to store snake y coordinate*/
    char _dirc[4000];/**< Arrays to store snake direction*/
    
    };
    


/** My Snake Class
* @brief Class for defining snake's properties and states
* @author Li Saiwen
* @date May, 2019
*/
class Snake{

    public:
    
        /** Constructor */
        Snake();
        
        /** Destructor */
        ~Snake();
        
        /** initial snake's property
        * @param  value of the initial cooridnate_x(int) of snake tail
        * @param  value of the initial coordinate_y(int) of snake tail
        * @param  value of the initial length(int) of snake
        * @param  value of the initial live(int) of snake
        */
        void init(int x, int y, int length,int _live);
        
        /** draw snake on the map
        * @param lcd the subclass of N5110
        * @param pad the subclass of Gamepad
        */
        void drawsnake(N5110 &lcd, Gamepad &pad);
        
        /** Determine the movement direction of snake
        * @param pad the subclass of Gamepad
        */
        void snakemov(Gamepad &pad);
        
        /** Determine if the snake is dead
        * @param lcd the subclass of N5110
        * @param pad the subclass of Gamepad
        * @return  return 0 to end loop
        */
        int dead(N5110 &lcd, Gamepad &pad);
        
        /** Determine if the snake eats food
        * @param pad the subclass of Gamepad
        */
        void eat(Gamepad &pad);
        
        /** Determine if the snake collide the wall
        * @param lcd the subclass of N5110 
        * @param pad the subclass of Gamepad
        */
        void check_WallCollision(N5110 &lcd, Gamepad &pad);
        
        /** Determine if the snake collide the tail
        * @param lcd the subclass of N5110 
        * @param pad the subclass of Gamepad
        */
        void check_TailCollision(N5110 &lcd, Gamepad &pad);
        
        /** Draw the current health points and score
        * @param lcd the subclass of N5110
        */
        void drawscore(N5110 &lcd);
        
        /** Make a noise when eating food
        * @param pad the subclass of Gamepad
        */
        void Tone_1(Gamepad &pad);
        
        /** Make a noise when collide wall
        * @param pad the subclass of Gamepad
        */
        void game_music(Gamepad &pad);
        
        int _length;
        int live;
        float waitTime;
        float waitExpect;
        int _speed;
        int Highest_score;
        
        
           
    private:
        
        int _direction;
        int initx;
        int inity;
        int initl;
        int x;
        Direction d;
        Food _food;
        
        
};
    
    #endif