#include "mbed.h"

PwmOut r(p36);
PwmOut g(p5);
PwmOut b(p34);
AnalogIn pot(p15);
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
InterruptIn tr(P1_16);
InterruptIn tg(P0_23);
InterruptIn tb(P0_10);
InterruptIn wt(P0_15);
AnalogIn licht(p16);
Serial pc(USBTX, USBRX);
Timer T;

int x1=0, x2=0, x3=0, wtv=0;
float f;

void ir()
{
    
    if(x1==1)
    {x1=0;}
    else
    if(x1==0)
    {x1=1;}
    wait(0.2);
    
}

void ig()
{
    
    if(x2==1)
    {x2=0;}
    else
    if(x2==0)
    {x2=1;}
    wait(0.2);
    
}

void ib()
{
    
    if(x3==1)
    {x3=0;}
    else
    if(x3==0)
    {x3=1;}
    wait(0.2);
    
}

void wti()
{
    
    if(wtv==0)
    {wtv=1;}
    else
    if(wtv==1)
    {wtv=0;}
    wait(0.2);
    
}

int main()
{
        
    tr.rise(&ir);
    tg.rise(&ig);
    tb.rise(&ib);
    wt.rise(&wti);
        
    r.period(0.001);
    g.period(0.001);
    b.period(0.001);
    
    while(1)
        {
            T.start();
            if(x1==1)
            {r=1;}
            else
            if(x1==0)
            {r=0;}
            
            if(x2==1)
            {g=1;}
            else
            if(x2==0)
            {g=0;}
            
            if(x3==1)
            {b=1;}
            else
            if(x3==0)
            {b=0;}
            
            leds = 0xFFF;
            
            if(wtv==0)
            {wait(pot);}
            else
            if(wtv==1)
            {wait(licht);}
            
            r=1;
            g=1;
            b=1;
            
            leds = 0x0000;
            
            if(wtv==0)
            {wait(pot);}
            else
            if(wtv==1)
            {wait(licht);}
            
            T.stop();
            f=1/T;
            if(wtv==0)
            {pc.printf("Potentiometer Frequenz: %.2f Hz \n\r", float(f));}
            else
            if(wtv==1)
            {pc.printf("Helligkeitssensor Frequenz: %.2f Hz \n\r", float(f));}
            T.reset();
         
        }
        
    
}