#include "mbed.h"   // this tells us to load mbed related functions
#include "Servo.h"  // library for the Servo
#include "DHT22.h"  // library for the Temp&Humidity sensor

DigitalOut myled(LED1);  // used as an output for the sensor
Servo myservo(p10);       // p10 works, using other pins is possible too
DHT22 sensor(p6);        // the pin of the connected grove port
Ticker fan;

void fanFunction()
{
    // YOUR CODE HERE: to reverse myservo between 0 and 1
    
}

// this code runs when the microcontroller starts up
int main()
{
    bool status;
    float temp = 0;
    float hum = 0;

    // spin a main loop all the time
    while (1) {
        // led hearbeat
        myled = !myled;
        status = sensor.sample();

        // sensor checksum successful
        if (status) {
            // printf the temperature and humidity from the sensor
            temp = sensor.getTemperature()/10.0f;
            hum = sensor.getHumidity()/10.0f;
            printf("Temperature is %f C \r\n", temp); 
            printf("Humidity is %f \r\n", hum);

            // start fanning if temperature > 25C or humidity > 90%
            if(temp > 25 && hum > 80) {
                printf("Starting Fan! \r\n");
                fan.attach(fanFunction,0.5);
            } else {
                printf("Stopping Fan! \r\n");
                fan.detach();
            }
        } else {  // sensor checksum failed
            printf("Error reading sample \r\n");
        }
        wait(2.0f);
    }
}