#include "mbed.h"
#include "Robot.h"
#include "Declarations.h"

#include <cstdlib>

//DistanceSensors related:
//Serial pc(SERIAL_TX, SERIAL_RX);

AnalogIn sensorVoltage(PB_1);
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);

//Leds related:
DigitalOut leds[6] = { PC_8, PC_6, PB_12, PA_7, PC_0, PC_9 };

//motor related:
PwmOut          left(PA_8);
PwmOut          right(PA_9);

DigitalOut      powerSignal(PB_2);
DigitalIn       errorSignal(PB_14);
DigitalIn       overtemperatur(PB_15);

//Farbsensor:
AnalogIn farbVoltage(A0);
DigitalOut enableFS(D3);


Robot sam( &left, &right, &powerSignal, leds, &farbVoltage ); //Implement the Farbsensor into the Robot init function!!



void initializeDistanceSensors(){
    for( int ii = 0; ii<6; ++ii) {
        sam.sensors[ii].init(&sensorVoltage, &bit0, &bit1, &bit2, ii);

    enable = 1;
    }
}

/* */
int main(){
    initializeDistanceSensors();        //Initialises IR-Sensors.
    int counter = 0;                    //Counts how many times the robot has turned, before driving
    int timer = 0;                      //Is used, to reset the robot. Returns time in [0.1s]
    //int lastFun = -1;                   //Is used, to check if the same action in Robot::search() was made multiple times.
    
    while( 1 ){
        if ( timer > TIMEOUT ){
            NVIC_SystemReset();         //Resets Sam.
        }
            
        sam.search(&counter, &timer);
        wait( 0.1f );
    }
    return 0;
}

/* * /
int main(){
    
    initializeDistanceSensors();
    sam.stop();
    
    while ( 1 ){
        for (int i=0; i<6; i++){
            sam.sensors[i] < NEAR ? sam.leds[i] = 1 : sam.leds[i] = 0;
        }
        
        sam.turnLeftS();
        
        while (sam.sensors[FWD] < NEAR){
            wait(0.05f);
            sam.stop();
        }
        
    }
    return 0;
}
/* */