#ifndef ROBOT_H
#define ROBOT_H

#include <cstdlib>
#include <mbed.h>
#include "Servo.h"

#include "mbed.h"


/* Declarations for the Motors in the Robot in order to drive -------- */

class DistanceSensors
{
    public:
        
        DistanceSensors(AnalogIn* sensorVoltage, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        DistanceSensors();
        
        void init(AnalogIn* sensorVoltage, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        virtual ~DistanceSensors();    
        float read();
        
        operator float();           //Is here to constantly return the value of read.
        
    private:
        
        AnalogIn*       sensorVoltage;
        DigitalOut*     bit0;
        DigitalOut*     bit1;
        DigitalOut*     bit2;
        
        int             number;

};

class Farbsensor
{
    public:
     
        Farbsensor();
        Farbsensor(AnalogIn* FarbVoltage);
    
        void init(AnalogIn* FarbVoltage);
        int read();
        operator int();
    
    private:
    
        AnalogIn*   FarbVoltage;
};

class Arm{
    
    public:
        
        Arm();
        void init();
        
        void collecttodown();
        void downtocollect();
        void collecttoback();
        void backtocollect();
        
    private:
        float angle;
        
};


class Robot
{
    
    public:
        
        //Robot related:
        Robot(PwmOut* left, PwmOut* right, DigitalOut* enableSignal, DigitalOut* leds, AnalogIn* FarbVoltage );
        
        //Drive Functions
        void drive();
        void driveB();

        void turnLeft();
        void turnLeftS();
        void turnRight();
        void turnRightS();
        void turnAround(int left);
        void stop();
        
        //Functions that use the drive functions
        void wallRight(int* counter, int* timer, int* lastAct);
        void wallLeft(int* counter, int* timer, int* lastAct);
        void wallFront(int* counter, int* timer, int* lastAct);
        void counterMax(int* counter, int* timer, int* lastAct, int* rando);
        
        void legoFront(int* counter, int* timer, int* lastAct, int* legoFound);
        void legoRight(int* counter, int* timer, int* lastAct, int* legoFound);
        void legoLeft(int* counter, int* timer, int* lastAct, int* legoFound);
        
        void nothingFound(int* counter, int* timer, int* lastAct);
        
        void search(int* counter, int* timer);
        void lego(int* counter, Timer* t);
        
        //DistanceSensors related:
        DistanceSensors sensors[6];
        
        void initializeDistanceSensors();
        //void init();
        
        //LEDS related:
        DigitalOut*      leds;
        
        //Farbsensors related:
        Farbsensor FarbVoltage;
        
    private:
    
        //Robot related:
        PwmOut*         left;
        PwmOut*         right;
    
        DigitalOut*     powerSignal;
        DigitalIn*      errorSignal;
        DigitalIn*      overtemperatur;
        

};

#endif