#include "mbed.h"
#include "Pixy.h"
#include "PID_Control.h"

//------------------------------------
// Example for PIxy UART connection.
// Driver version 0.1
// BUGS::
// DO NOT USE PRINTF IN MAIN LOOP FOR PROPER OPERATION
// Pixy has to be configured for UART with 460800 Baud
// Pixy connected by UART (PA_9 and PA_10) with 230400 Baud
//------------------------------------

//communication
Serial pc(USBTX, USBRX);
Serial cam(PA_9, PA_10);

DigitalOut myled(LED1);

//motor stuff
DigitalOut enableMotorDriver(PB_2);
PwmOut pwmL(PA_8);
PwmOut pwmR(PA_9);

Pixy pixy(cam);

int main()
{
    PID_Control pid;
    
    pid.setPIDValues( 0.001f, 0.001f, 0.00015f, 0.3f, -0.3f, 1000);
    
    pc.baud( 115200 );
    pwmL.period(0.00005f); // Setzt die Periode auf 50 μs
    pwmR.period(0.00005f);
    enableMotorDriver = 1;

    //int skipper = 0;

    while(1) {
        wait( 0.005f );

        //  if( ++skipper % 100 == 0)
        //      printf("x=%d\n\r", pixy.getX());

        float e = 160-pixy.getX();
        float diff = pid.calc( e, 0.005f );
        
        pwmL = 0.5f - diff;
        pwmR = 0.5f - diff;
    }
}
