#include "mbed.h"
#include "Robot.h"

#include <cstdlib>

//DistanceSensors related:
Serial pc(SERIAL_TX, SERIAL_RX);

AnalogIn sensorVoltage(PB_1);
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);

//Leds related:
DigitalOut leds[6] = { PC_8, PC_6, PB_12, PA_7, PC_0, PC_9 };

//motor related:
PwmOut          left(PA_8);
PwmOut          right(PA_9);

DigitalOut      powerSignal(PB_2);
DigitalIn       errorSignal(PB_14);
DigitalIn       overtemperatur(PB_15);

//Farbsensor:
AnalogIn FarbVoltage(A0);

Robot sam( &left, &right, &powerSignal, leds, &FarbVoltage ); //Implement the Farbsensor into the Robot init function!!

void initializeDistanceSensors(){
    for( int ii = 0; ii<6; ++ii) {
        sam.sensors[ii].init(&sensorVoltage, &bit0, &bit1, &bit2, ii);

    enable = 1;
    }
}

/* */
int main(){
    Timer t;
    t.start();
    
    initializeDistanceSensors();
    int counter = 0;                //counts how many times the robot has turned, before driving
        
    while( 1 ){
        if ( t.read() > TIMEOUT ){
            NVIC_SystemReset();     //Resets Sam.
        }
            
        sam.search(&counter, &t);
        wait( 0.1f );
    }
    return 0;
}