#ifndef ROBOT_H
#define ROBOT_H

#include <cstdlib>
#include <mbed.h>

#include "mbed.h"

//DistanceSensors:
#define NEAR 0.1f           //Used for distance Sensors. If they're to near to a wall -> turn
#define LEFT 5              //Arrayindex of the left Sensor & left LED
#define FWD 0               //Arrayindex of the front Sensor & front LED
#define RIGHT 1             //Arrayindex of the right Sensor & right LED.

//ColorSensors:
#define RED_UPLIMIT 500     //Default limit in mV
#define GREEN_DOWNLIMIT 501 //Default limit in mV
#define GREEN_UPLIMIT 1200  //Default limit in mV
#define GREEN 1
#define NOBLOCK 0
#define RED -1

//Misc:
#define TIMEOUT 20


/* Declarations for the Motors in the Robot in order to drive -------- */

class DistanceSensors
{
    public:
        
        DistanceSensors(AnalogIn* sensorVoltage, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        DistanceSensors();
        
        void init(AnalogIn* sensorVoltage, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        virtual ~DistanceSensors();    
        float read();
        
        operator float();           //Is here to constantly return the value of read.
        
    private:
        
        AnalogIn*       sensorVoltage;
        DigitalOut*     bit0;
        DigitalOut*     bit1;
        DigitalOut*     bit2;
        
        int             number;

};

class Farbsensor
{
    public:
     
        Farbsensor();
        Farbsensor(AnalogIn* FarbVoltage);
    
        void init(AnalogIn* FarbVoltage);
        int read();
        operator int();
    
    private:
    
        AnalogIn*   FarbVoltage;
};

class Robot
{
    
    public:
        
        //Robot related:
        Robot(PwmOut* left, PwmOut* right, DigitalOut* enableSignal, DigitalOut* leds, AnalogIn* FarbVoltage );
        void drive();
        void turnLeft();
        void turnRight();
        void turnAround(int left);
        void stop();
        
        void search(int* counter, Timer* t);
        
        //DistanceSensors related:
        DistanceSensors sensors[6];
        
        void initializeDistanceSensors();
        //void init();
        
        //LEDS related:
        DigitalOut*      leds;
        
        //Farbsensors related:
        Farbsensor FarbVoltage;
        
    private:
    
        //Robot related:
        PwmOut*         left;
        PwmOut*         right;
    
        DigitalOut*     powerSignal;
        DigitalIn*      errorSignal;
        DigitalIn*      overtemperatur;
        

};

#endif