#ifndef ROBOT_H
#define ROBOT_H

#include <cstdlib>
#include <mbed.h>
#include "mbed.h"
#include "Declarations.h"
#include "Pixy.h"
#include "Servo.h"
#include "ServoArm.h"



/* Declarations for the Motors in the Robot in order to drive -------- */

class DistanceSensors
{
    public:
        
        DistanceSensors(AnalogIn* sensorVoltage, AnalogIn* frontS, AnalogIn* leftS, AnalogIn* rightS, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        DistanceSensors();
        
        void init(AnalogIn* sensorVoltage, AnalogIn* frontS, AnalogIn* leftS, AnalogIn* rightS, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        virtual ~DistanceSensors();    
        float read();
        
        operator float();           //Is here to constantly return the value of read.
        
    private:
        
        AnalogIn*       sensorVoltage;
        AnalogIn*       frontS;
        AnalogIn*       leftS;
        AnalogIn*       rightS;
        
        DigitalOut*     bit0;
        DigitalOut*     bit1;
        DigitalOut*     bit2;
        
        int             number;
};

class Farbsensor
{
    public:
     
        Farbsensor();
        Farbsensor(AnalogIn* FarbVoltage);
    
        void init(AnalogIn* FarbVoltage);
        int read();
        operator int(); //Is here to constantly return the value of read.
    
    private:
    
        AnalogIn*       FarbVoltage;
};

class Arm{
    
    public:
        
        Arm();
        Arm(ServoArm* servoArm);
        
        void init(ServoArm* servoArm);
        
        int collectToBack();
        int downToBack();
        int backToDown();
        
    private:
    
        ServoArm*  arm;        
};

class Greifer{
    
    public:
    
        Greifer(Servo* greifer);
        Greifer();
        
        void init(Servo* greifer);
        int take();
        int leave();
        
    private:
    
        Servo* greifer;        

};

class Robot{
    
    public:
        
        //Robot related:
        Robot(PwmOut* left, PwmOut* right, DigitalOut* powerSignal, DigitalOut* leds, AnalogIn* FarbVoltage, AnalogIn* frontS, AnalogIn* leftS, AnalogIn* rightS, ServoArm* Arm, Servo* Greifer, Pixy* pixy );
        
        //Drive Functions
        void drive();
        void driveB();
        void setLeft(float pwm);
        void setRight(float pwm);

        void turnLeft();
        void turnLeftS();
        void turnRight();
        void turnRightS();
        void turnAround(int left);
        void stop();
        
        //Functions that use the drive functions
        void driveSlowly();
        void driveBackSlowly();
        void search(int* time);
        
        int getErrorMotor();
        
        //DistanceSensors related:
        DistanceSensors sensors[9];
        AnalogIn* frontS;
        AnalogIn* leftS;
        AnalogIn* rightS;
        
        
        void initializeDistanceSensors();
        
        //LEDS related:
        DigitalOut*     leds;
        
        //Farbsensors related:
        //Farbsensor      FarbVoltage;
        //DigitalOut*     led;
        
        //Arm related:
        Arm             Arm;
        
        //Greifer related:
        Greifer         Greifer;
        
        //Cam:
        Pixy*           pixy;
        
    private:
    
        //Robot related:
        PwmOut*         left;
        PwmOut*         right;
        DigitalIn*      errorMotor;
    
        DigitalOut*     powerSignal;
        DigitalIn*      errorSignal;
        DigitalIn*      overtemperatur;
        
        Servo*          greifer;
        ServoArm*       arm;
};

#endif