#include "Robot.h"
#include "Declarations.h"
Serial pc1(USBTX, USBRX);

Farbsensor::Farbsensor()
{   
}

Farbsensor::Farbsensor(AnalogIn* FarbVoltage)
{
    init(FarbVoltage);  
}

void Farbsensor::init(AnalogIn* FarbVoltage)
{
    this->FarbVoltage= FarbVoltage;
}

int Farbsensor::read()
{
    static int time=0;
    static float messungen=0.0f;
    if( time < 10 ){
        messungen += FarbVoltage->read();
        time++;
        return -1;
    }
    else{
        float Ufarbsensor = messungen/10.0;
        Ufarbsensor = Ufarbsensor*3300;//Set the Voltage between 0mV und 3300mV
        pc1.printf("measure = %.0f mV\n", Ufarbsensor); 
        
        messungen = 0.0f;
        time = 0;
        if ((Ufarbsensor > GREEN_DOWNLIMIT) && (Ufarbsensor < GREEN_UPLIMIT))
            {
             return GREEN;
            }
        else if(Ufarbsensor < RED_UPLIMIT)
            {
             return RED;
            }
        else 
            {
             return NOBLOCK;
            }
        }
}

Farbsensor::operator int()
{
    return read();
}