#ifndef ROBOT_H
#define ROBOT_H

#include <cstdlib>
#include <mbed.h>
#include "Servo.h"
#include "ServoArm.h"

#include "mbed.h"


/* Declarations for the Motors in the Robot in order to drive -------- */

class DistanceSensors
{
    public:
        
        DistanceSensors(AnalogIn* sensorVoltage, AnalogIn* frontS, AnalogIn* leftS, AnalogIn* rightS, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        DistanceSensors();
        
        void init(AnalogIn* sensorVoltage, AnalogIn* frontS, AnalogIn* leftS, AnalogIn* rightS, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
        virtual ~DistanceSensors();    
        float read();
        
        operator float();           //Is here to constantly return the value of read.
        
    private:
        
        AnalogIn*       sensorVoltage;
        AnalogIn*       frontS;
        AnalogIn*       leftS;
        AnalogIn*       rightS;
        
        DigitalOut*     bit0;
        DigitalOut*     bit1;
        DigitalOut*     bit2;
        
        int             number;

};

class Farbsensor
{
    public:
     
        Farbsensor();
        Farbsensor(AnalogIn* FarbVoltage);
    
        void init(AnalogIn* FarbVoltage);
        int read();
        operator int();
    
    private:
    
        AnalogIn*   FarbVoltage;
};

class Arm{
    
    public:
        
        Arm();
        Arm(ServoArm* servoArm);
        
        void init(ServoArm* servoArm);
        
        int collectToDown();
        int downToCollect();
        int collectToBack();
        int backToCollect();
        
    private:
        ServoArm*  arm;
        float   angle;
        
};

class Greifer
{
    
    public:
    
        Greifer(Servo* greifer);
        Greifer();
        
        void init(Servo* greifer);
        int take();
        int leave();
        
    private:
        Servo* greifer;        

};

class Robot
{
    
    public:
        
        //Robot related:
        Robot(PwmOut* left, PwmOut* right, DigitalOut* powerSignal, DigitalOut* leds, AnalogIn* FarbVoltage, AnalogIn* frontS, AnalogIn* leftS, AnalogIn* rightS, ServoArm* Arm, Servo* Greifer );
        
        //Drive Functions
        void drive();
        void driveB();

        void turnLeft();
        void turnLeftS();
        void turnRight();
        void turnRightS();
        void turnAround(int left);
        void stop();
        
        //Functions that use the drive functions
        void wallRight(int* counter, int* timer, int* lastAct);
        void wallLeft(int* counter, int* timer, int* lastAct);
        void wallFront(int* counter, int* timer, int* lastAct);
        void counterMax(int* counter, int* timer, int* lastAct, int* rando);
        
        void legoFront(int* counter, int* timer, int* lastAct, int* legoFound, int* found);
        void legoRight(int* counter, int* timer, int* lastAct, int* legoFound);
        void legoLeft(int* counter, int* timer, int* lastAct, int* legoFound);
        
        void nothingFound(int* counter, int* timer, int* lastAct);
        
        int search(int* timer);
        
        int getErrorMotor();
        
        //DistanceSensors related:
        DistanceSensors sensors[9];
        AnalogIn* frontS;
        AnalogIn* leftS;
        AnalogIn* rightS;
        
        
        void initializeDistanceSensors();
        //void init();
        
        //LEDS related:
        DigitalOut*     leds;
        
        //Farbsensors related:
        Farbsensor      FarbVoltage;
        
        //Arm related:
        Arm             Arm;
        
        //Greifer related:
        Greifer         Greifer;
        
    private:
    
        //Robot related:
        PwmOut*         left;
        PwmOut*         right;
        DigitalIn*      errorMotor;
    
        DigitalOut*     powerSignal;
        DigitalIn*      errorSignal;
        DigitalIn*      overtemperatur;
        
        Servo*          greifer;
        ServoArm*       arm;
};

#endif