#include "Ultraschall.h"
 
 
Ultraschall::Ultraschall(PinName TrigPin,PinName EchoPin):
    trigger(TrigPin), echo(EchoPin)
{
    pulsetime.stop();
    pulsetime.reset();
    echo.rise(this,&Ultraschall::isr_rise);
    echo.fall(this,&Ultraschall::isr_fall);
    trigger=0;
}
 
Ultraschall::~Ultraschall()
{
}
 
void Ultraschall::isr_rise(void)
{
    pulsetime.start();
}
void Ultraschall::start(void)
{
    trigger=1;
    wait_us(10);
    trigger=0;
}
 
void Ultraschall::isr_fall(void)
{
    pulsetime.stop();
    pulsedur = pulsetime.read_us();
    distance= (pulsedur*343)/20000;
    pulsetime.reset();
}
 
void Ultraschall::rise (void (*fptr)(void))
{
    echo.rise(fptr);
}
void Ultraschall::fall (void (*fptr)(void))
{
    echo.fall(fptr);
}
 
unsigned int Ultraschall::get_dist_cm()
{
    return distance;
}
unsigned int Ultraschall::get_pulse_us()
{
    return pulsedur;
}