#include "mbed.h"
#include "Robot.h"
#include "Declarations.h"

#include <cstdlib>

//DistanceSensors related bottom:
Serial pc(SERIAL_TX, SERIAL_RX);

AnalogIn sensorVoltage(PB_1);
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);

//DistanceSensors top:
AnalogIn frontS(A1);
AnalogIn leftS(A2);
AnalogIn rightS(A3);

//Leds related:
DigitalOut leds[6] = { PC_8, PC_6, PB_12, PA_7, PC_0, PC_9 };

//motor related:
PwmOut          left(PA_8);
PwmOut          right(PA_9);

DigitalOut      powerSignal(PB_2);
DigitalIn       errorSignal(PB_14);
DigitalIn       overtemperatur(PB_15);

//Arm:
//Servo arm(PC_7);

//Farbsensor:
AnalogIn FarbVoltage(A0);

Robot sam( &left, &right, &powerSignal, leds, &FarbVoltage, &frontS, &leftS, &rightS ); //Implement the Farbsensor into the Robot init function!!

void initializeDistanceSensors(){
    for( int ii = 0; ii<9; ++ii) {
        sam.sensors[ii].init(&sensorVoltage, &frontS, &leftS, &rightS, &bit0, &bit1, &bit2, ii);

    enable = 1;
    }
}

/* */
int main(){
    initializeDistanceSensors();        //Initialises IR-Sensors.
    int counter = 0;                    //Counts how many times the robot has turned, before driving
    int timer = 0;                      //Is used, to reset the robot. Returns time in [0.1s]
    //int lastFun = -1;                   //Is used, to check if the same action in Robot::search() was made multiple times.
    int found = 0;                      //0:= no block available, 1 := a lego is ready to be picked up
    
    while( 1 ){
        if(sam.sensors[FWD_L]<0.14) leds[2]=1;
        else leds[2]=0;
        if(sam.sensors[RIGHT_L]<0.14) leds[1]=1;
        else leds[1]=0;
        if(sam.sensors[LEFT_L]<0.14) leds[5]=1;
        else leds[5]=0;
        if ( timer > TIMEOUT ){
            NVIC_SystemReset();         //Resets Sam.
        }
        else if (found == 0){
            sam.search(&counter, &timer, &found);
        }
        else{
            //pick up lego
            //found = 0;
            sam.stop(); //Nur zum Testen
        }
        
        wait( 0.1f );
    }
   // return 0;
}

/* * /
int main(){
    
    initializeDistanceSensors();
    sam.stop();
    
    while ( 1 ){
        for (int i=0; i<6; i++){
            sam.sensors[i] < NEAR ? sam.leds[i] = 1 : sam.leds[i] = 0;
        }
        
        sam.turnLeftS();
        
        while (sam.sensors[FWD] < NEAR){
            wait(0.05f);
            sam.stop();
        }
        
    }
    return 0;
}
/* */

/* * /
int main(){
    for(float p=0; p<1.0; p += 0.1) {
      //  arm = p;
        wait(0.2);
    }
}
/* */