#include "Farbsensor.h"


Farbsensor::Farbsensor()
{   
}

Farbsensor::Farbsensor(AnalogIn* FarbVoltage)
{
    init(FarbVoltage);  
}

void Farbsensor::init(AnalogIn* FarbVoltage)
{
    this->FarbVoltage= FarbVoltage;
}

int Farbsensor::read()
{
    int farbe;
    static float Messungen = 0.0f;
    static int i=0;
    
    if(i<10){   
        Messungen+=FarbVoltage->read();
        i++;
        return -1;
    }   
    else{         
        float Ufarbsensor = Messungen/(i+1);
        Ufarbsensor = Ufarbsensor*3300; //Set the Voltage between 0mV und 3300mV

        if ((Ufarbsensor > GREEN_DOWNLIMIT) && (Ufarbsensor < GREEN_UPLIMIT))
            {
             farbe=1;
            }
        else if(Ufarbsensor < RED_UPLIMIT)
            {
             farbe=2;
            }
        else 
            {
             farbe=0;
            }
        Messungen=0.0f;
        i=0;
        return farbe;
    }

}

Farbsensor::operator int()
{
    return read();
}