#ifndef _SNS_DD_PIXART_PPG_H
#define _SNS_DD_PIXART_PPG_H

//#define DEBUG_8001    //Run test pattern, HR should be 88.599
#define I2C_ADDR     (0x66) //I2C address shift 1-bit
#define PAH8001_ADDR I2C_ADDR
#define Target  0x30
void PAH8001_init(void);
void writeRegister(uint8_t addr, uint8_t data);
uint8_t readRegister(uint8_t addr);
static bool Pixart_HRD(void);
#define PAH8001_Poll    40      //Polling rate, in ms
const uint16_t HR_Rpt = 200/PAH8001_Poll; //Heart report rate
static volatile uint16_t HR_Cnt = 0;

int32_t alg_version;
float myHR;
float grade=0;

typedef struct {
    uint8_t HRD_Data[13];
    float MEMS_Data[3];
}ppg_mems_data_t;
#define FIFO_SIZE 30
#define FIFO_SIZE_M1 (FIFO_SIZE-1)
bool isFIFOEmpty(void);
bool Push(ppg_mems_data_t *data);
bool Pop(ppg_mems_data_t *data);
static volatile int _read_index = 0;
static volatile int _write_index = 0;

static ppg_mems_data_t _ppg_mems_data[FIFO_SIZE];
static uint8_t Frame_Count = 0;
ppg_mems_data_t ppg_mems_data;
unsigned char ready_flag = 0;
unsigned char motion_flag = 0;
float MEMS_Data[3] = {0};

/***********************LED Control Start***********************************/
#define LED_INC_DEC_STEP 2
#define LED_CTRL_EXPO_TIME_HI_BOUND 496
#define LED_CTRL_EXPO_TIME_LOW_BOUND 32
#define LED_CTRL_EXPO_TIME_HI 420
#define LED_CTRL_EXPO_TIME_LOW 64
#define LED_CURRENT_HI 31
#define LED_CURRENT_LOW 1
#define STATE_COUNT_TH 3
#define DEFAULT_LED_STEP 10
void led_ctrl(uint8_t);

static uint8_t _led_step = DEFAULT_LED_STEP;
static uint8_t _state = 0, _state_count = 0;
static uint8_t _led_current_change_flag = 0;
static uint8_t _sleepflag = 1 ;
/***********************LED Control End ***********************************/

const uint8_t init_ppg_register_array[][2] = {  //based on ap note v0.93
{0x7F,0x00},//Switch bank
{0x09,0x5A},
{0x05,0x99},
{0x17,0xA2},//Make sure MSB =1, without changing other bits
{0x27,0xFF},
{0x28,0xFA},
{0x29,0x0A},
{0x2A,0xC8},
{0x2B,0xA0},
{0x2C,0x8C},
{0x2D,0x64},
{0x42,0x20},
{0x48,0x00},
{0x4D,0x18},//0x1A-->wrist application; 0x18--> Finger tip
{0x7A,0xB5},
{0x7F,0x01},//Switch bank
{0x07,0x48},
{0x23,0x3C},
{0x26,0x0F},
{0x2E,0x48},
{0x38,0xEA},
{0x42,0xA4},
{0x43,0x41},
{0x44,0x41},
{0x45,0x24},
{0x46,0xC0},
{0x52,0x32},
{0x53,0x28},
{0x56,0x60},
{0x57,0x28},
{0x6D,0x02},
{0x0F,0xC8},
{0x7F,0x00},//Switch bank
{0x5D,0x81},//Start ppg
};

#define INIT_PPG_REG_ARRAY_SIZE (sizeof(init_ppg_register_array)/sizeof(init_ppg_register_array[0]))
#endif /* End include guard _SNS_DD_PIXART_PPG_H */

#ifdef DEBUG_8001
#define PPG_PATTERN_SIZE (sizeof(PPG_Data)/sizeof(PPG_Data[0]))
#if 1
//new pattern for V30 and later
//@algo_v30.1, first HR: 79.7418, last HR: 82.1134
//@algo_v30.2, first HR: 80.9915, last HR: 82.4043
const float iMEMS_Data[][3] = {
//{-12607, 1281, -5119},
{-11775, 769, -6399},
{-11839, 961, -6335},
{-11711, 897, -6463},
{-12031, 1281, -6207},
{-11775, 1409, -6399},
{-12159, 705, -6143},
{-11903, 449, -6207},
{-12095, 833, -6207},
{-12287, 1089, -5823},
{-12031, 1025, -6143},
{-12543, 961, -5439},
{-11839, 1857, -6335},
{-12095, 1025, -5759},
{-12287, 705, -5567},
{-12479, 833, -5567},
{-12287, 1153, -5823},
{-11839, 1409, -6207},
{-12095, 961, -6079},
{-12415, 1153, -5631},
{-12223, 769, -6079},
{-12223, 769, -5759},
{-11839, 1025, -6271},
{-12287, 1025, -5887},
{-12159, 769, -5823},
{-12223, 641, -5759},
{-12159, 833, -5887},
{-12223, 833, -5695},
{-12287, 961, -5375},
{-12159, 769, -5631},
{-12031, 769, -5823},
{-12223, 641, -5759},
{-12159, 833, -5503},
{-12095, 705, -5695},
{-12287, 769, -5631},
{-12095, 769, -5567},
{-12095, 641, -5951},
{-12223, 705, -5695},
{-12159, 897, -5759},
{-12223, 961, -5119},
{-12223, 705, -5823},
{-12095, 769, -5887},
{-12479, 833, -4735},
{-11967, 769, -5823},
{-12223, 705, -5823},
{-12095, 705, -5695},
{-12159, 897, -5695},
{-12223, 769, -5695},
{-12223, 961, -5439},
{-12223, 833, -5823},
{-12159, 769, -5695},
{-11967, 769, -5759},
{-12095, 705, -5759},
{-12223, 769, -5631},
{-12095, 641, -5631},
{-12095, 769, -5631},
{-12159, 897, -5695},
{-12095, 705, -5695},
{-12351, 769, -5503},
{-12159, 769, -5567},
{-12223, 769, -5567},
{-12223, 833, -5567},
{-12351, 769, -5567},
{-12415, 705, -5439},
{-12351, 705, -5311},
{-12287, 705, -5439},
{-12159, 769, -5439},
{-12351, 897, -5503},
{-12351, 833, -5567},
{-12159, 769, -5439},
{-12351, 705, -5567},
{-12287, 705, -5375},
{-12159, 897, -5247},
{-12415, 897, -5375},
{-12415, 769, -5311},
{-12159, 769, -6143},
{-12159, 705, -5311},
{-11967, 705, -6591},
{-12223, 641, -5567},
{-12095, 961, -5759},
{-12863, 385, -5183},
{-12543, 705, -5759},
{-12159, 1345, -4863},
{-11775, 1345, -4671},
{-12031, 1537, -4991},
{-12671, -63, -5183},
{-12543, 705, -4927},
{-12543, 705, -3967},
{-12671, 385, -5823},
{-12543, 833, -4671},
{-12607, 641, -4607},
{-12671, 833, -4735},
{-12607, 705, -4671},
{-12607, 705, -4479},
{-12543, 769, -4543},
{-12479, 705, -4607},
{-12543, 705, -4671},
{-12479, 769, -4671},
{-12543, 641, -4671},
{-12607, 705, -4607},
{-12607, 641, -4607},
{-12671, 705, -4607},
{-12543, 705, -4607},
{-12607, 641, -4607},
{-12607, 513, -4607},
{-12735, 705, -4607},
{-12671, 705, -4607},
{-12607, 897, -4799},
{-12607, 769, -4735},
{-12607, 1089, -4863},
{-12543, 769, -4735},
{-12543, 705, -4671},
{-12479, 769, -4671},
{-12607, 769, -4671},
{-12543, 769, -4607},
{-12543, 705, -4671},
{-12607, 641, -4607},
{-12543, 897, -4543},
{-12607, 833, -4671},
{-12479, 705, -4735},
{-12543, 577, -4671},
{-12607, 897, -4479},
{-12479, 769, -4735},
{-12543, 641, -4799},
{-12479, 833, -4735},
{-12671, 769, -4671},
{-12543, 705, -4607},
{-12543, 769, -4671},
{-12543, 705, -4607},
{-12543, 705, -4735},
{-12607, 641, -4607},
{-12671, 641, -4543},
{-12607, 769, -4671},
{-12543, 769, -4607},
{-12543, 833, -4735},
{-12543, 705, -4799},
{-12607, 705, -4799},
{-12607, 641, -4671},
{-12543, 641, -4799},
{-12479, 769, -4799},
{-12543, 769, -4607},
{-12543, 705, -4863},
{-12543, 897, -4735},
{-12671, 897, -4671},
{-12671, 833, -4671},
{-12607, 833, -4863},
{-12607, 897, -4735},
{-12671, 833, -4799},
{-12607, 833, -4799},
{-12671, 705, -4735},
{-12735, 769, -4735},
{-12479, 769, -4735},
{-12671, 705, -4735},
{-12479, 705, -4543},
{-12607, 705, -4735},
{-12607, 769, -4799},
{-12543, 641, -4735},
{-12607, 769, -4735},
{-12607, 769, -4735},
{-12671, 833, -4735},
{-12671, 705, -4799},
{-12543, 705, -4863},
{-12607, 833, -4735},
{-12543, 705, -4735},
{-12607, 833, -4607},
{-12543, 641, -4863},
{-12607, 769, -4671},
{-12415, 769, -4671},
{-12543, 897, -4671},
{-12543, 769, -4863},
{-12543, 769, -4799},
{-12479, 641, -4799},
{-12607, 769, -4735},
{-12543, 769, -4735},
{-12543, 705, -4671},
{-12607, 705, -4735},
{-12607, 833, -4543},
{-12543, 833, -4735},
{-12543, 641, -4735},
{-12607, 705, -4671},
{-12671, 769, -4735},
{-12671, 705, -4735},
{-12607, 705, -4735},
{-12671, 705, -4671},
{-12607, 833, -4735},
{-12479, 833, -4799},
{-12735, 705, -4735},
{-12479, 833, -4799},
{-12607, 897, -4735},
{-12671, 705, -4735},
{-12607, 769, -4607},
{-12543, 769, -4671},
{-12607, 769, -4799},
{-12671, 769, -4799},
{-12543, 705, -4607},
{-12607, 641, -4671},
{-12671, 705, -4543},
{-12671, 641, -4607},
{-12735, 833, -4735},
{-12543, 705, -4671},
{-12607, 705, -4671},
{-12671, 833, -4671},
{-12607, 705, -4735},
{-12607, 705, -4607},
{-12479, 833, -4671},
{-12607, 833, -4735},
{-12607, 705, -4671},
{-12607, 833, -4607},
{-12671, 705, -4671},
{-12671, 769, -4799},
{-12671, 769, -4735},
{-12543, 577, -4607},
{-12607, 705, -4735},
{-12607, 769, -4671},
{-12671, 705, -4543},
{-12607, 705, -4607},
{-12543, 769, -4671},
{-12735, 833, -4735},
{-12671, 705, -4543},
{-12607, 705, -4607},
{-12607, 769, -4671},
{-12543, 705, -4607},
{-12607, 833, -4607},
{-12479, 769, -4671},
{-12671, 833, -4671},
{-12671, 705, -4799},
{-12735, 769, -4543},
{-12607, 769, -4671},
{-12671, 705, -4671},
{-12479, 705, -4671},
{-12671, 769, -4671},
{-12671, 705, -4671},
{-12671, 833, -4671},
{-12735, 705, -4735},
{-12479, 769, -4607},
{-12607, 833, -4671},
{-12607, 833, -4671},
{-12671, 769, -4607},
{-12415, 769, -4607},
{-12735, 769, -4543},
{-12607, 705, -4543},
{-12671, 897, -4479},
{-12607, 705, -4671},
{-12671, 641, -4671},
{-12607, 769, -4607},
{-12607, 641, -4543},
{-12479, 897, -4479},
{-12671, 833, -4607},
{-12543, 769, -4543},
{-12735, 833, -4671},
{-12735, 833, -4607},
{-12671, 769, -4543},
{-12671, 833, -4671},
{-12671, 833, -4607},
{-12735, 769, -4671},
{-12607, 705, -4415},
{-12671, 769, -4543},
{-12543, 769, -4863},
{-12607, 961, -4543},
{-12735, 833, -4543},
{-12735, 833, -4543},
{-12543, 769, -4479},
{-12543, 705, -4415},
{-12543, 961, -4479},
{-12671, 897, -4479},
{-12543, 833, -4479},
{-12543, 833, -4479},
{-12607, 833, -4479},
{-12671, 897, -4543},
{-12607, 833, -4479},
{-12671, 833, -4543},
{-12671, 833, -4415},
{-12735, 769, -4543},
{-12607, 705, -4351},
{-12607, 833, -4607},
{-12735, 769, -4543},
{-12735, 833, -4671},
{-12735, 769, -4543},
{-12607, 833, -4735},
{-12607, 833, -4671},
{-12671, 705, -4543},
{-12543, 769, -4543},
{-12799, 705, -4351},
{-12863, 833, -4479},
{-12607, 833, -4543},
{-12543, 641, -4543},
{-12607, 833, -4735},
{-12671, 641, -4607},
{-12671, 769, -4607},
{-12735, 897, -4607},
{-12671, 897, -4543},
{-12735, 705, -4543},
{-12671, 897, -4479},
{-12607, 769, -4415},
{-12607, 769, -4415},
{-12735, 833, -4543},
{-12735, 705, -4543},
{-12607, 705, -4543},
{-12671, 769, -4479},
{-12543, 833, -4607},
{-12671, 897, -4479},
{-12735, 833, -4543},
{-12543, 833, -4543},
{-12607, 769, -4479},
{-12671, 833, -4607},
{-12543, 833, -4543},
{-12671, 769, -4607},
{-12607, 705, -4543},
{-12799, 833, -4607},
{-12735, 705, -4607},
{-12735, 897, -4607},
{-12735, 705, -4543},
{-12671, 769, -4671},
{-12863, 897, -4671},
{-12735, 705, -4543},
{-12607, 705, -4543},
{-12671, 897, -4671},
{-12607, 769, -4799},
{-12543, 833, -4479},
{-12735, 705, -4607},
{-12671, 705, -4415},
{-12671, 577, -4799},
{-12735, 705, -4543},
{-12735, 705, -4607},
{-12607, 833, -4479},
{-12671, 769, -4415},
{-12671, 769, -4479},
{-12735, 641, -4479},
{-12415, 769, -5759},
{-12735, 833, -4479},
{-12735, 897, -4479},
{-12735, 833, -4479},
{-12735, 705, -4479},
{-12735, 769, -4479},
{-12799, 705, -4415},
{-12735, 769, -4351},
{-12671, 769, -4479},
{-12735, 769, -4351},
{-12799, 833, -4543},
{-12863, 705, -4543},
{-12671, 833, -4543},
{-12671, 769, -4543},
{-12735, 705, -4415},
{-12735, 833, -4479},
{-12863, 833, -4479},
{-12735, 833, -4415},
{-12671, 705, -4543},
{-12671, 705, -4607},
{-12735, 769, -4479},
{-12735, 833, -4415},
{-12735, 833, -4479},
{-12863, 705, -4479},
{-12863, 705, -4479},
{-12799, 833, -4415},
{-12863, 769, -4543},
{-12799, 833, -4351},
{-12735, 833, -4607},
{-12863, 833, -4479},
{-12799, 833, -4479},
{-12671, 833, -4479},
{-12799, 705, -4607},
{-12735, 769, -4607},
{-12671, 833, -4607},
{-12671, 705, -4479},
{-12671, 769, -4479},
{-12671, 769, -4351},
{-12735, 705, -4543},
{-12735, 833, -4607},
{-12799, 769, -4543},
{-12671, 641, -4607},
{-12671, 705, -4543},
{-12799, 705, -4479},
{-12799, 769, -4479},
{-12799, 897, -4351},
{-12799, 769, -4415},
{-12671, 769, -4607},
{-12735, 897, -4543},
{-12863, 897, -4799},
{-12607, 833, -4479},
{-12735, 769, -4415},
{-12671, 705, -4543},
{-12671, 769, -4543},
{-12543, 705, -4607},
{-12863, 769, -4543},
{-12671, 833, -4543},
{-12671, 769, -4671},
{-12799, 833, -4543},
{-12799, 705, -4415},
{-12671, 705, -4607},
{-12671, 705, -4543},
{-12735, 833, -4415},
{-12799, 705, -4543},
{-12671, 769, -4543},
{-12735, 769, -4479},
{-12671, 705, -4543},
{-12735, 897, -4351},
{-12735, 769, -4479},
{-12799, 769, -4415},
{-12863, 769, -4479},
{-12671, 897, -4479},
{-12863, 769, -4479},
{-12863, 769, -4415},
{-12671, 769, -4479},
{-12607, 961, -4415},
{-12671, 833, -4543},
{-12735, 769, -4351},
{-12735, 769, -4479},
{-12671, 705, -4351},
{-12671, 833, -4415},
{-12799, 833, -4479},
{-12799, 769, -4415},
{-12735, 769, -4543},
{-12671, 897, -4543},
{-12863, 705, -4543},
{-12799, 769, -4479},
{-12799, 769, -4479},
{-12607, 833, -4543},
{-12671, 705, -4415},
{-12735, 833, -4479},
{-12735, 705, -4543},
{-12735, 769, -4479},
{-12735, 705, -4607},
{-12863, 641, -4479},
{-12799, 833, -4543},
{-12479, 705, -4479},
{-12927, 769, -4415},
{-12671, 705, -4607},
{-12799, 961, -4479},
{-12799, 769, -4543},
{-12799, 769, -4607},
{-12671, 769, -4479},
{-12671, 897, -4607},
{-12671, 833, -4479},
{-12735, 833, -4479},
{-12735, 769, -4415},
{-12735, 833, -4543},
{-12735, 769, -4415},
{-12735, 833, -4415},
{-12735, 769, -4671},
{-12607, 769, -4543},
{-12671, 769, -4479},
{-12607, 769, -4543},
{-12799, 833, -4543},
{-12799, 769, -4607},
{-12671, 769, -4543},
{-12735, 769, -4607},
{-12735, 769, -4479},
{-12671, 705, -4415},
{-12735, 769, -4351},
{-12799, 705, -4607},
{-12799, 897, -4543},
{-12799, 769, -4607},
{-12735, 833, -4607},
{-12671, 705, -4479},
{-12735, 769, -4543},
{-12735, 705, -4543},
{-12735, 833, -4415},
{-12607, 833, -4543},
{-12799, 769, -4607},
{-12671, 833, -4479},
{-12735, 769, -4479},
{-12735, 769, -4415},
{-12863, 769, -4543},
{-12799, 833, -4479},
{-12607, 833, -4415},
{-12735, 833, -4415},
{-12671, 705, -4607},
{-12607, 769, -4543},
{-12863, 769, -4543},
{-12799, 769, -4479},
{-12671, 769, -4415},
{-12671, 769, -4543},
{-12799, 897, -4479},
{-12735, 897, -4479},
{-12735, 769, -4415},
{-12799, 833, -4479},
{-12799, 833, -4671},
{-12735, 833, -4543},
{-12799, 705, -4607},
{-12799, 769, -4543},
{-12607, 705, -4479},
{-12735, 833, -4671},
{-12735, 705, -4607},
{-12799, 769, -4479},
{-12671, 897, -4415},
{-12607, 769, -4543},
{-12671, 769, -4415},
{-12799, 897, -4607},
{-12671, 833, -4543},
{-12671, 769, -4671},
{-12671, 833, -4543},
{-12735, 769, -4479},
{-12671, 705, -4479},
{-12735, 769, -4607},
{-12735, 641, -4479},
{-12671, 833, -4415},
{-12735, 769, -4543},
{-12671, 769, -4607},
{-12799, 769, -4543},
{-12735, 833, -4479},
{-12671, 769, -4543},
{-12799, 769, -4543},
{-12735, 833, -4479},
{-12863, 641, -4607},
{-12863, 833, -4415},
{-12799, 769, -4479},
{-12671, 897, -4479},
{-12863, 705, -4479},
{-12735, 833, -4415},
{-12735, 769, -4479},
{-12735, 769, -4607},
{-12735, 705, -4479},
{-12863, 833, -4479},
{-12735, 833, -4415},
{-12735, 833, -4479},
{-12863, 769, -4479},
{-12863, 769, -4543},
{-12671, 705, -4479},
{-12735, 705, -4351},
{-13375, 1729, -4287},
{-12607, 65, -4543},
{-13375, 1281, -4159},
{-12991, 705, -3711},
{-12991, 1025, -3775},
{-12671, 705, -4031},
{-12991, 705, -4095},
{-12927, 769, -4095},
{-12991, 833, -3903},
{-12927, 705, -4031},
{-13055, 705, -4031},
{-12799, 769, -3839},
{-12927, 769, -3903},
{-12991, 769, -3839},
{-12991, 641, -3775},
{-13119, 641, -3967},
{-12927, 769, -3967},
{-12927, 705, -3775},
{-12927, 769, -3839},
{-12927, 769, -4031},
{-12991, 833, -4031},
{-12991, 833, -3967},
{-12799, 705, -3967},
{-12991, 769, -3903},
{-12863, 641, -3903},
{-12991, 577, -4031},
{-12863, 769, -3903},
{-12991, 833, -4031},
{-12863, 641, -3903},
{-12863, 705, -4031},
{-12927, 641, -4095},
{-12927, 769, -3967},
{-12735, 705, -4223},
{-12863, 897, -4095},
{-12863, 705, -4095},
{-12863, 833, -3967},
{-12863, 833, -3967},
{-12991, 641, -3967},
{-12863, 641, -3967},
{-12863, 641, -4159},
{-12927, 769, -3967},
{-12991, 641, -4031},
{-12927, 705, -4095},
{-12799, 705, -4095},
{-12991, 641, -4159},
{-12863, 769, -4223},
{-12927, 705, -4159},
{-13055, 705, -4159},
{-12735, 705, -4159},
{-12863, 769, -4159},
{-12927, 769, -4159},
{-12991, 769, -4159},
{-12927, 769, -4095},
{-12863, 641, -4223},
{-12927, 769, -4159},
{-12863, 769, -4031},
{-12799, 705, -4287},
{-12799, 769, -4095},
{-12991, 641, -4159},
{-12991, 833, -4287},
{-12927, 769, -4351},
{-12927, 577, -4159},
{-12863, 769, -4223},
{-12991, 577, -4287},
{-12863, 641, -3967},
{-12927, 641, -4031},
{-12927, 641, -4287},
{-12927, 833, -4031},
{-12927, 769, -4095},
{-12799, 769, -4287},
{-12863, 577, -4223},
{-12799, 705, -4287},
{-12863, 705, -4223},
{-12927, 705, -4223},
{-12927, 705, -4159},
{-12863, 705, -4159},
{-12735, 705, -4031},
{-12927, 641, -4095},
{-12927, 705, -4223},
{-12927, 577, -4159},
{-12927, 641, -4223},

    
};
const unsigned char PPG_Data[][13] = {
//{1, 240, 167, 0, 1, 125, 141, 16, 233, 0, 0, 0, 141},
{1, 190, 94, 44, 1, 24, 158, 134, 234, 0, 0, 128, 158},
{1, 46, 148, 6, 3, 9, 154, 145, 235, 0, 0, 128, 154},
{1, 211, 233, 50, 6, 7, 186, 179, 236, 0, 0, 128, 186},
{1, 144, 85, 171, 11, 6, 194, 188, 237, 0, 0, 128, 194},
{1, 84, 180, 150, 14, 7, 176, 169, 238, 0, 0, 128, 176},
{1, 238, 1, 5, 14, 5, 160, 155, 239, 0, 0, 128, 160},
{1, 89, 40, 123, 17, 5, 177, 172, 240, 0, 1, 128, 177},
{1, 90, 111, 201, 18, 5, 179, 174, 241, 0, 0, 128, 179},
{1, 51, 150, 250, 19, 5, 185, 180, 242, 0, 0, 128, 185},
{1, 53, 46, 217, 20, 4, 194, 190, 243, 0, 1, 128, 194},
{1, 13, 249, 254, 19, 5, 165, 160, 244, 0, 0, 128, 165},
{1, 162, 253, 129, 18, 5, 167, 162, 245, 0, 0, 128, 167},
{1, 157, 177, 185, 18, 4, 169, 165, 246, 0, 0, 128, 169},
{1, 197, 242, 112, 18, 5, 136, 132, 247, 0, 0, 128, 136},
{1, 54, 90, 57, 15, 4, 137, 133, 248, 0, 0, 128, 137},
{1, 125, 204, 85, 15, 5, 138, 133, 249, 0, 0, 128, 138},
{1, 90, 243, 122, 15, 4, 139, 135, 250, 0, 1, 128, 139},
{1, 95, 252, 58, 12, 4, 145, 141, 251, 0, 0, 128, 145},
{1, 185, 78, 102, 11, 4, 146, 142, 252, 0, 0, 128, 146},
{1, 83, 196, 114, 11, 4, 147, 143, 253, 0, 1, 128, 147},
{1, 20, 92, 65, 9, 5, 160, 155, 254, 0, 0, 128, 160},
{1, 186, 58, 70, 6, 5, 161, 156, 255, 0, 0, 128, 161},
{1, 31, 65, 77, 6, 5, 161, 156, 0, 0, 0, 128, 161},
{1, 83, 180, 81, 6, 5, 162, 157, 1, 0, 0, 128, 162},
{1, 237, 77, 88, 6, 5, 162, 158, 2, 0, 0, 128, 162},
{1, 84, 14, 94, 6, 5, 163, 158, 3, 0, 0, 128, 163},
{1, 131, 36, 99, 6, 5, 163, 158, 4, 0, 0, 128, 163},
{1, 184, 233, 97, 6, 4, 162, 158, 5, 0, 0, 128, 162},
{1, 185, 60, 91, 6, 4, 162, 158, 6, 0, 0, 128, 162},
{1, 30, 27, 88, 6, 5, 163, 158, 7, 0, 0, 128, 163},
{1, 238, 199, 92, 6, 5, 163, 158, 8, 0, 0, 128, 163},
{1, 185, 48, 100, 6, 5, 164, 159, 9, 0, 0, 128, 164},
{1, 235, 184, 105, 6, 5, 164, 159, 10, 0, 0, 128, 164},
{1, 182, 206, 108, 6, 4, 164, 160, 11, 0, 0, 128, 164},
{1, 235, 168, 111, 6, 4, 165, 161, 12, 0, 0, 128, 165},
{1, 186, 211, 115, 6, 5, 165, 160, 13, 0, 0, 128, 165},
{1, 31, 78, 118, 6, 5, 166, 161, 14, 0, 0, 128, 166},
{1, 186, 206, 123, 6, 5, 166, 161, 15, 0, 0, 128, 166},
{1, 237, 152, 125, 6, 5, 166, 161, 16, 0, 0, 128, 166},
{1, 237, 215, 130, 6, 4, 167, 163, 17, 0, 0, 128, 167},
{1, 32, 2, 134, 6, 5, 167, 163, 18, 0, 0, 128, 167},
{1, 31, 102, 137, 6, 5, 167, 162, 19, 0, 0, 128, 167},
{1, 185, 79, 140, 6, 5, 167, 162, 20, 0, 0, 128, 167},
{1, 83, 102, 140, 6, 4, 166, 162, 21, 0, 0, 128, 166},
{1, 81, 41, 132, 6, 4, 166, 162, 22, 0, 0, 128, 166},
{1, 32, 153, 128, 6, 5, 166, 161, 23, 0, 0, 128, 166},
{1, 237, 109, 130, 6, 4, 167, 163, 24, 0, 0, 128, 167},
{1, 81, 25, 136, 6, 5, 168, 163, 25, 0, 0, 128, 168},
{1, 134, 241, 140, 6, 4, 168, 163, 26, 0, 0, 128, 168},
{1, 234, 211, 144, 6, 4, 168, 164, 27, 0, 0, 128, 168},
{1, 235, 142, 145, 6, 4, 168, 164, 28, 0, 0, 128, 168},
{1, 131, 152, 149, 6, 5, 169, 164, 29, 0, 0, 128, 169},
{1, 81, 252, 152, 6, 5, 169, 164, 30, 0, 0, 128, 169},
{1, 79, 171, 157, 6, 5, 169, 164, 31, 0, 0, 128, 169},
{1, 134, 8, 160, 6, 4, 169, 165, 32, 0, 0, 128, 169},
{1, 31, 100, 162, 6, 4, 169, 165, 33, 0, 0, 128, 169},
{1, 237, 217, 163, 6, 4, 170, 166, 34, 0, 0, 128, 170},
{1, 185, 148, 166, 6, 5, 170, 165, 35, 0, 0, 128, 170},
{1, 133, 74, 168, 6, 5, 170, 165, 36, 0, 0, 128, 170},
{1, 184, 191, 167, 6, 4, 170, 165, 37, 0, 0, 128, 170},
{1, 30, 70, 161, 6, 4, 169, 165, 38, 0, 0, 128, 169},
{1, 32, 20, 156, 6, 5, 169, 164, 39, 0, 0, 128, 169},
{1, 235, 84, 159, 6, 5, 169, 164, 40, 0, 0, 128, 169},
{1, 236, 79, 163, 6, 5, 170, 165, 41, 0, 0, 128, 170},
{1, 31, 213, 162, 6, 5, 170, 165, 42, 0, 0, 128, 170},
{1, 236, 33, 167, 6, 4, 170, 166, 43, 0, 0, 128, 170},
{1, 235, 99, 168, 6, 4, 170, 166, 44, 0, 0, 128, 170},
{1, 32, 25, 170, 6, 5, 170, 165, 45, 0, 0, 128, 170},
{1, 183, 32, 170, 6, 5, 170, 165, 46, 0, 0, 128, 170},
{1, 236, 81, 173, 6, 4, 171, 167, 47, 0, 0, 128, 171},
{1, 186, 170, 176, 6, 4, 171, 167, 48, 0, 0, 128, 171},
{1, 83, 127, 177, 6, 4, 171, 167, 49, 0, 0, 128, 171},
{1, 183, 131, 178, 6, 5, 171, 166, 50, 0, 0, 128, 171},
{1, 236, 179, 179, 6, 5, 170, 165, 51, 0, 0, 128, 170},
{1, 135, 73, 182, 6, 5, 171, 166, 52, 0, 0, 128, 171},
{1, 184, 129, 181, 6, 5, 171, 166, 53, 0, 0, 128, 171},
{1, 135, 13, 170, 6, 4, 168, 164, 54, 0, 0, 128, 168},
{1, 82, 15, 158, 6, 4, 169, 165, 55, 0, 0, 128, 169},
{1, 235, 100, 158, 6, 5, 169, 164, 56, 0, 0, 128, 169},
{1, 236, 0, 160, 6, 4, 169, 165, 57, 0, 0, 128, 169},
{1, 187, 195, 160, 6, 5, 169, 164, 58, 0, 0, 128, 169},
{1, 237, 206, 162, 6, 4, 169, 164, 59, 0, 0, 128, 169},
{1, 234, 143, 164, 6, 5, 170, 166, 60, 0, 0, 128, 170},
{1, 83, 112, 166, 6, 5, 170, 165, 61, 0, 0, 128, 170},
{1, 236, 205, 169, 6, 5, 171, 166, 62, 0, 0, 128, 171},
{1, 234, 187, 175, 6, 5, 171, 166, 63, 0, 0, 128, 171},
{1, 133, 168, 182, 6, 4, 171, 167, 64, 0, 0, 128, 171},
{1, 235, 143, 184, 6, 4, 172, 168, 65, 0, 0, 128, 172},
{1, 235, 236, 185, 6, 5, 171, 166, 66, 0, 0, 128, 171},
{1, 82, 21, 188, 6, 4, 172, 168, 67, 0, 0, 128, 172},
{1, 184, 156, 188, 6, 4, 172, 167, 68, 0, 0, 128, 172},
{1, 135, 45, 187, 6, 4, 171, 167, 69, 0, 0, 128, 171},
{1, 135, 49, 177, 6, 4, 170, 166, 70, 0, 0, 128, 170},
{1, 237, 6, 171, 6, 4, 170, 166, 71, 0, 0, 128, 170},
{1, 82, 138, 173, 6, 4, 171, 167, 72, 0, 0, 128, 171},
{1, 182, 241, 175, 6, 5, 171, 166, 73, 0, 0, 128, 171},
{1, 236, 183, 178, 6, 4, 171, 166, 74, 0, 0, 128, 171},
{1, 83, 41, 181, 6, 4, 171, 167, 75, 0, 0, 128, 171},
{1, 83, 77, 183, 6, 4, 172, 168, 76, 0, 0, 128, 172},
{1, 233, 80, 185, 6, 4, 172, 168, 77, 0, 0, 128, 172},
{1, 80, 241, 187, 6, 4, 171, 167, 78, 0, 0, 128, 171},
{1, 133, 47, 189, 6, 5, 172, 168, 79, 0, 0, 128, 172},
{1, 133, 44, 192, 6, 4, 172, 168, 80, 0, 0, 128, 172},
{1, 81, 245, 194, 6, 4, 173, 169, 81, 0, 0, 128, 173},
{1, 238, 249, 197, 6, 4, 173, 169, 82, 0, 0, 128, 173},
{1, 183, 231, 199, 6, 5, 173, 168, 83, 0, 0, 128, 173},
{1, 133, 128, 200, 6, 4, 172, 168, 84, 0, 0, 128, 172},
{1, 81, 81, 192, 6, 4, 171, 167, 85, 0, 0, 128, 171},
{1, 185, 74, 185, 6, 4, 172, 168, 86, 0, 0, 128, 172},
{1, 132, 134, 187, 6, 4, 172, 168, 87, 0, 0, 128, 172},
{1, 186, 224, 191, 6, 5, 173, 169, 88, 0, 0, 128, 173},
{1, 183, 119, 194, 6, 5, 173, 168, 89, 0, 0, 128, 173},
{1, 80, 40, 198, 6, 4, 173, 169, 90, 0, 0, 128, 173},
{1, 236, 158, 199, 6, 4, 173, 169, 91, 0, 0, 128, 173},
{1, 30, 83, 202, 6, 5, 173, 168, 92, 0, 0, 128, 173},
{1, 134, 70, 204, 6, 5, 174, 170, 93, 0, 0, 128, 174},
{1, 30, 239, 206, 6, 5, 174, 170, 94, 0, 0, 128, 174},
{1, 233, 215, 208, 6, 5, 174, 169, 95, 0, 0, 128, 174},
{1, 83, 123, 211, 6, 4, 175, 171, 96, 0, 0, 128, 175},
{1, 29, 100, 214, 6, 5, 174, 169, 97, 0, 0, 128, 174},
{1, 134, 169, 214, 6, 5, 174, 169, 98, 0, 0, 128, 174},
{1, 238, 168, 216, 6, 5, 175, 171, 99, 0, 0, 128, 175},
{1, 132, 240, 216, 6, 5, 174, 169, 100, 0, 0, 128, 174},
{1, 132, 144, 208, 6, 4, 174, 170, 101, 0, 0, 128, 174},
{1, 32, 46, 202, 6, 4, 174, 170, 102, 0, 0, 128, 174},
{1, 81, 190, 205, 6, 4, 174, 170, 103, 0, 0, 128, 174},
{1, 183, 166, 208, 6, 4, 174, 170, 104, 0, 0, 128, 174},
{1, 34, 92, 211, 6, 5, 174, 169, 105, 0, 0, 128, 174},
{1, 29, 230, 212, 6, 4, 175, 171, 106, 0, 0, 128, 175},
{1, 183, 173, 215, 6, 4, 175, 171, 107, 0, 0, 128, 175},
{1, 185, 208, 216, 6, 4, 175, 171, 108, 0, 0, 128, 175},
{1, 83, 3, 220, 6, 5, 176, 171, 109, 0, 0, 128, 176},
{1, 236, 123, 222, 6, 4, 176, 172, 110, 0, 0, 128, 176},
{1, 136, 39, 225, 6, 4, 176, 171, 111, 0, 0, 128, 176},
{1, 183, 174, 225, 6, 4, 176, 172, 112, 0, 0, 128, 176},
{1, 82, 205, 227, 6, 4, 176, 172, 113, 0, 0, 128, 176},
{1, 235, 232, 229, 6, 5, 176, 172, 114, 0, 0, 128, 176},
{1, 83, 194, 231, 6, 5, 176, 171, 115, 0, 0, 128, 176},
{1, 131, 237, 232, 6, 4, 176, 172, 116, 0, 0, 128, 176},
{1, 186, 204, 229, 6, 4, 175, 171, 117, 0, 0, 128, 175},
{1, 83, 90, 219, 6, 4, 175, 171, 118, 0, 0, 128, 175},
{1, 82, 154, 219, 6, 4, 175, 171, 119, 0, 0, 128, 175},
{1, 185, 164, 222, 6, 5, 176, 171, 120, 0, 0, 128, 176},
{1, 187, 194, 223, 6, 5, 176, 171, 121, 0, 0, 128, 176},
{1, 132, 133, 227, 6, 4, 176, 172, 122, 0, 0, 128, 176},
{1, 239, 241, 228, 6, 4, 176, 172, 123, 0, 0, 128, 176},
{1, 133, 101, 230, 6, 5, 176, 171, 124, 0, 0, 128, 176},
{1, 132, 10, 232, 6, 5, 177, 172, 125, 0, 0, 128, 177},
{1, 33, 201, 233, 6, 4, 177, 172, 126, 0, 0, 128, 177},
{1, 33, 97, 236, 6, 5, 177, 172, 127, 0, 0, 128, 177},
{1, 235, 47, 237, 6, 4, 177, 173, 128, 0, 0, 128, 177},
{1, 81, 56, 240, 6, 4, 177, 173, 129, 0, 0, 128, 177},
{1, 28, 49, 242, 6, 5, 178, 174, 130, 0, 0, 128, 178},
{1, 134, 230, 241, 6, 4, 176, 172, 131, 0, 0, 128, 176},
{1, 29, 64, 243, 6, 4, 177, 173, 132, 0, 0, 128, 177},
{1, 84, 0, 242, 6, 4, 176, 172, 133, 0, 0, 128, 176},
{1, 186, 86, 231, 6, 4, 176, 172, 134, 0, 0, 128, 176},
{1, 30, 42, 225, 6, 4, 176, 171, 135, 0, 0, 128, 176},
{1, 136, 60, 226, 6, 5, 176, 171, 136, 0, 0, 128, 176},
{1, 183, 23, 230, 6, 4, 176, 172, 137, 0, 0, 128, 176},
{1, 184, 159, 232, 6, 4, 177, 173, 138, 0, 0, 128, 177},
{1, 182, 172, 234, 6, 4, 177, 173, 139, 0, 0, 128, 177},
{1, 236, 4, 235, 6, 4, 177, 173, 140, 0, 0, 128, 177},
{1, 237, 190, 237, 6, 5, 177, 173, 141, 0, 0, 128, 177},
{1, 29, 88, 239, 6, 5, 177, 172, 142, 0, 0, 128, 177},
{1, 235, 98, 241, 6, 4, 178, 174, 143, 0, 0, 128, 178},
{1, 238, 143, 245, 6, 4, 178, 174, 144, 0, 0, 128, 178},
{1, 30, 189, 247, 6, 4, 178, 174, 145, 0, 0, 128, 178},
{1, 83, 158, 248, 6, 5, 178, 173, 146, 0, 0, 128, 178},
{1, 234, 170, 249, 6, 4, 178, 173, 147, 0, 0, 128, 178},
{1, 83, 97, 250, 6, 4, 178, 174, 148, 0, 0, 128, 178},
{1, 32, 152, 251, 6, 4, 178, 174, 149, 0, 0, 128, 178},
{1, 233, 151, 247, 6, 4, 177, 173, 150, 0, 0, 128, 177},
{1, 236, 142, 236, 6, 5, 176, 171, 151, 0, 0, 128, 176},
{1, 133, 132, 234, 6, 4, 177, 173, 152, 0, 0, 128, 177},
{1, 136, 211, 238, 6, 4, 177, 172, 153, 0, 0, 128, 177},
{1, 235, 153, 239, 6, 4, 177, 173, 154, 0, 0, 128, 177},
{1, 31, 89, 242, 6, 4, 178, 174, 155, 0, 0, 128, 178},
{1, 235, 74, 243, 6, 4, 178, 174, 156, 0, 0, 128, 178},
{1, 186, 0, 245, 6, 5, 178, 173, 157, 0, 0, 128, 178},
{1, 136, 83, 245, 6, 5, 178, 173, 158, 0, 0, 128, 178},
{1, 132, 31, 249, 6, 4, 178, 174, 159, 0, 0, 128, 178},
{1, 31, 44, 251, 6, 5, 178, 173, 160, 0, 0, 128, 178},
{1, 82, 116, 252, 6, 5, 178, 173, 161, 0, 0, 128, 178},
{1, 32, 197, 253, 6, 4, 179, 175, 162, 0, 0, 128, 179},
{1, 83, 217, 0, 7, 5, 179, 174, 163, 0, 0, 128, 179},
{1, 183, 95, 0, 7, 4, 179, 175, 164, 0, 0, 128, 179},
{1, 82, 113, 0, 7, 4, 179, 175, 165, 0, 0, 128, 179},
{1, 32, 131, 254, 6, 4, 178, 174, 166, 0, 0, 128, 178},
{1, 237, 13, 244, 6, 5, 177, 172, 167, 0, 0, 128, 177},
{1, 83, 125, 241, 6, 5, 177, 172, 168, 0, 0, 128, 177},
{1, 182, 232, 244, 6, 5, 178, 173, 169, 0, 0, 128, 178},
{1, 134, 41, 248, 6, 5, 178, 174, 170, 0, 0, 128, 178},
{1, 83, 204, 248, 6, 4, 178, 174, 171, 0, 0, 128, 178},
{1, 133, 55, 251, 6, 5, 177, 172, 172, 0, 0, 128, 177},
{1, 132, 221, 250, 6, 5, 179, 174, 173, 0, 0, 128, 179},
{1, 30, 201, 253, 6, 5, 179, 174, 174, 0, 0, 128, 179},
{1, 83, 219, 255, 6, 5, 179, 174, 175, 0, 0, 128, 179},
{1, 83, 234, 2, 7, 4, 179, 175, 176, 0, 0, 128, 179},
{1, 30, 179, 3, 7, 5, 179, 175, 177, 0, 0, 128, 179},
{1, 134, 91, 4, 7, 5, 179, 174, 178, 0, 0, 128, 179},
{1, 132, 230, 4, 7, 5, 179, 174, 179, 0, 0, 128, 179},
{1, 132, 187, 5, 7, 4, 179, 175, 180, 0, 0, 128, 179},
{1, 235, 209, 5, 7, 4, 179, 175, 181, 0, 0, 128, 179},
{1, 234, 91, 1, 7, 4, 178, 174, 182, 0, 0, 128, 178},
{1, 135, 55, 244, 6, 5, 178, 174, 183, 0, 0, 128, 178},
{1, 235, 13, 244, 6, 4, 178, 174, 184, 0, 0, 128, 178},
{1, 238, 4, 246, 6, 5, 178, 173, 185, 0, 0, 128, 178},
{1, 33, 215, 247, 6, 4, 178, 174, 186, 0, 0, 128, 178},
{1, 131, 251, 249, 6, 4, 178, 174, 187, 0, 0, 128, 178},
{1, 186, 168, 252, 6, 5, 178, 173, 188, 0, 0, 128, 178},
{1, 186, 214, 252, 6, 4, 180, 176, 189, 0, 0, 128, 180},
{1, 236, 140, 255, 6, 5, 179, 174, 190, 0, 0, 128, 179},
{1, 133, 156, 0, 7, 4, 179, 175, 191, 0, 0, 128, 179},
{1, 30, 172, 1, 7, 4, 179, 175, 192, 0, 0, 128, 179},
{1, 236, 62, 2, 7, 4, 179, 175, 193, 0, 0, 128, 179},
{1, 30, 63, 6, 7, 4, 179, 175, 194, 0, 0, 128, 179},
{1, 184, 246, 4, 7, 4, 180, 175, 195, 0, 0, 128, 180},
{1, 184, 29, 8, 7, 4, 180, 176, 196, 0, 0, 128, 180},
{1, 234, 217, 9, 7, 4, 179, 175, 197, 0, 0, 128, 179},
{1, 186, 92, 3, 7, 4, 178, 174, 198, 0, 0, 128, 178},
{1, 183, 223, 247, 6, 5, 177, 172, 199, 0, 0, 128, 177},
{1, 81, 112, 245, 6, 4, 178, 174, 200, 0, 0, 128, 178},
{1, 135, 3, 249, 6, 4, 178, 174, 201, 0, 0, 128, 178},
{1, 184, 41, 250, 6, 4, 178, 174, 202, 0, 0, 128, 178},
{1, 30, 65, 253, 6, 4, 179, 175, 203, 0, 0, 128, 179},
{1, 232, 39, 255, 6, 4, 179, 175, 204, 0, 0, 128, 179},
{1, 134, 138, 255, 6, 5, 178, 174, 205, 0, 0, 128, 178},
{1, 81, 25, 0, 7, 5, 180, 176, 206, 0, 0, 128, 180},
{1, 133, 80, 3, 7, 5, 179, 174, 207, 0, 0, 128, 179},
{1, 83, 171, 4, 7, 4, 179, 175, 208, 0, 0, 128, 179},
{1, 133, 69, 6, 7, 4, 179, 175, 209, 0, 0, 128, 179},
{1, 233, 230, 7, 7, 5, 180, 175, 210, 0, 0, 128, 180},
{1, 81, 136, 9, 7, 4, 180, 176, 211, 0, 0, 128, 180},
{1, 33, 21, 10, 7, 4, 180, 176, 212, 0, 0, 128, 180},
{1, 133, 149, 11, 7, 4, 180, 176, 213, 0, 0, 128, 180},
{1, 233, 240, 8, 7, 4, 179, 175, 214, 0, 0, 128, 179},
{1, 133, 47, 253, 6, 5, 178, 173, 215, 0, 0, 128, 178},
{1, 235, 240, 246, 6, 5, 178, 173, 216, 0, 0, 128, 178},
{1, 236, 17, 248, 6, 4, 178, 173, 217, 0, 0, 128, 178},
{1, 236, 225, 250, 6, 4, 178, 174, 218, 0, 0, 128, 178},
{1, 136, 138, 252, 6, 4, 179, 175, 219, 0, 0, 128, 179},
{1, 186, 210, 254, 6, 5, 179, 174, 220, 0, 0, 128, 179},
{1, 187, 190, 255, 6, 5, 179, 174, 221, 0, 0, 128, 179},
{1, 236, 55, 1, 7, 4, 179, 175, 222, 0, 0, 128, 179},
{1, 135, 46, 4, 7, 4, 179, 175, 223, 0, 0, 128, 179},
{1, 133, 142, 5, 7, 4, 179, 175, 224, 0, 0, 128, 179},
{1, 81, 44, 8, 7, 4, 180, 176, 225, 0, 0, 128, 180},
{1, 232, 247, 7, 7, 5, 180, 175, 226, 0, 0, 128, 180},
{1, 131, 34, 11, 7, 4, 180, 176, 227, 0, 0, 128, 180},
{1, 134, 128, 11, 7, 4, 180, 176, 228, 0, 0, 128, 180},
{1, 82, 31, 12, 7, 4, 180, 176, 229, 0, 0, 128, 180},
{1, 235, 191, 11, 7, 5, 179, 174, 230, 0, 0, 128, 179},
{1, 132, 245, 255, 6, 4, 177, 173, 231, 0, 0, 128, 177},
{1, 134, 83, 249, 6, 5, 178, 173, 232, 0, 0, 128, 178},
{1, 32, 187, 251, 6, 4, 179, 175, 233, 0, 0, 128, 179},
{1, 31, 217, 254, 6, 4, 179, 175, 234, 0, 0, 128, 179},
{1, 83, 113, 1, 7, 4, 180, 176, 235, 0, 0, 128, 180},
{1, 184, 222, 3, 7, 5, 180, 175, 236, 0, 0, 128, 180},
{1, 135, 198, 3, 7, 4, 179, 175, 237, 0, 0, 128, 179},
{1, 234, 240, 4, 7, 4, 179, 175, 238, 0, 0, 128, 179},
{1, 183, 244, 5, 7, 4, 179, 175, 239, 0, 0, 128, 179},
{1, 236, 103, 9, 7, 4, 180, 176, 240, 0, 0, 128, 180},
{1, 132, 255, 11, 7, 4, 180, 176, 241, 0, 0, 128, 180},
{1, 82, 200, 13, 7, 5, 180, 175, 242, 0, 0, 128, 180},
{1, 185, 231, 15, 7, 4, 180, 176, 243, 0, 0, 128, 180},
{1, 133, 72, 16, 7, 4, 180, 176, 244, 0, 0, 128, 180},
{1, 184, 196, 17, 7, 4, 180, 176, 245, 0, 0, 128, 180},
{1, 31, 120, 17, 7, 4, 179, 175, 246, 0, 0, 128, 179},
{1, 134, 93, 6, 7, 5, 179, 174, 247, 0, 0, 128, 179},
{1, 134, 43, 4, 7, 4, 179, 175, 248, 0, 0, 128, 179},
{1, 131, 225, 6, 7, 4, 180, 176, 249, 0, 0, 128, 180},
{1, 132, 168, 8, 7, 4, 180, 176, 250, 0, 0, 128, 180},
{1, 81, 43, 12, 7, 4, 180, 176, 251, 0, 0, 128, 180},
{1, 31, 43, 13, 7, 5, 180, 176, 252, 0, 0, 128, 180},
{1, 185, 147, 12, 7, 4, 180, 176, 253, 0, 0, 128, 180},
{1, 83, 151, 14, 7, 4, 180, 176, 254, 0, 0, 128, 180},
{1, 135, 0, 16, 7, 4, 180, 176, 255, 0, 0, 128, 180},
{1, 31, 5, 18, 7, 4, 181, 177, 0, 0, 0, 128, 181},
{1, 184, 39, 19, 7, 5, 182, 177, 1, 0, 0, 128, 182},
{1, 185, 109, 20, 7, 4, 181, 177, 2, 0, 0, 128, 181},
{1, 186, 208, 19, 7, 4, 181, 177, 3, 0, 0, 128, 181},
{1, 232, 112, 20, 7, 5, 181, 176, 4, 0, 0, 128, 181},
{1, 131, 75, 21, 7, 4, 181, 177, 5, 0, 0, 128, 181},
{1, 187, 47, 15, 7, 5, 179, 174, 6, 0, 0, 128, 179},
{1, 133, 236, 5, 7, 4, 179, 175, 7, 0, 0, 128, 179},
{1, 236, 139, 6, 7, 4, 180, 176, 8, 0, 0, 128, 180},
{1, 82, 104, 9, 7, 5, 180, 175, 9, 0, 0, 128, 180},
{1, 29, 178, 11, 7, 4, 180, 176, 10, 0, 0, 128, 180},
{1, 31, 116, 14, 7, 4, 180, 176, 11, 0, 0, 128, 180},
{1, 85, 246, 14, 7, 5, 180, 175, 12, 0, 0, 128, 180},
{1, 28, 112, 16, 7, 5, 181, 176, 13, 0, 0, 128, 181},
{1, 84, 114, 17, 7, 4, 180, 176, 14, 0, 0, 128, 180},
{1, 238, 123, 19, 7, 4, 181, 177, 15, 0, 0, 128, 181},
{1, 133, 146, 19, 7, 4, 181, 177, 16, 0, 0, 128, 181},
{1, 83, 88, 21, 7, 4, 181, 177, 17, 0, 0, 128, 181},
{1, 236, 101, 23, 7, 4, 181, 177, 18, 0, 0, 128, 181},
{1, 184, 184, 24, 7, 5, 181, 176, 19, 0, 0, 128, 181},
{1, 80, 209, 23, 7, 4, 181, 177, 20, 0, 0, 128, 181},
{1, 185, 75, 24, 7, 4, 181, 177, 21, 0, 0, 128, 181},
{1, 185, 158, 14, 7, 4, 180, 175, 22, 0, 0, 128, 180},
{1, 30, 129, 10, 7, 5, 180, 175, 23, 0, 0, 128, 180},
{1, 187, 199, 12, 7, 5, 180, 175, 24, 0, 0, 128, 180},
{1, 237, 22, 16, 7, 4, 180, 175, 25, 0, 0, 128, 180},
{1, 135, 74, 17, 7, 4, 180, 176, 26, 0, 0, 128, 180},
{1, 82, 33, 19, 7, 4, 181, 176, 27, 0, 0, 128, 181},
{1, 31, 255, 20, 7, 5, 181, 176, 28, 0, 0, 128, 181},
{1, 134, 130, 22, 7, 5, 181, 176, 29, 0, 0, 128, 181},
{1, 234, 205, 23, 7, 4, 181, 177, 30, 0, 0, 128, 181},
{1, 182, 38, 26, 7, 4, 181, 177, 31, 0, 0, 128, 181},
{1, 237, 7, 27, 7, 5, 181, 177, 32, 0, 0, 128, 181},
{1, 84, 141, 27, 7, 5, 182, 177, 33, 0, 0, 128, 182},
{1, 236, 162, 26, 7, 4, 182, 178, 34, 0, 0, 128, 182},
{1, 184, 197, 26, 7, 5, 182, 178, 35, 0, 0, 128, 182},
{1, 186, 28, 29, 7, 4, 181, 177, 36, 0, 0, 128, 181},
{1, 31, 114, 26, 7, 4, 180, 176, 37, 0, 0, 128, 180},
{1, 184, 56, 14, 7, 4, 180, 176, 38, 0, 0, 128, 180},
{1, 237, 22, 13, 7, 4, 181, 177, 39, 0, 0, 128, 181},
{1, 184, 192, 17, 7, 5, 181, 176, 40, 0, 0, 128, 181},
{1, 83, 79, 19, 7, 4, 181, 177, 41, 0, 0, 128, 181},
{1, 236, 103, 20, 7, 4, 181, 177, 42, 0, 0, 128, 181},
{1, 234, 254, 23, 7, 5, 181, 176, 43, 0, 0, 128, 181},
{1, 132, 235, 23, 7, 5, 180, 175, 44, 0, 0, 128, 180},
{1, 134, 183, 23, 7, 5, 181, 176, 45, 0, 0, 128, 181},
{1, 235, 143, 25, 7, 5, 182, 177, 46, 0, 0, 128, 182},
{1, 30, 176, 26, 7, 4, 181, 177, 47, 0, 0, 128, 181},
{1, 185, 196, 27, 7, 4, 182, 178, 48, 0, 0, 128, 182},
{1, 82, 150, 27, 7, 4, 182, 178, 49, 0, 0, 128, 182},
{1, 82, 0, 29, 7, 5, 182, 177, 50, 0, 0, 128, 182},
{1, 133, 15, 29, 7, 5, 182, 177, 51, 0, 0, 128, 182},
{1, 29, 86, 30, 7, 4, 181, 177, 52, 0, 0, 128, 181},
{1, 184, 0, 25, 7, 4, 180, 176, 53, 0, 0, 128, 180},
{1, 235, 82, 12, 7, 4, 180, 176, 54, 0, 0, 128, 180},
{1, 83, 121, 11, 7, 5, 180, 175, 55, 0, 0, 128, 180},
{1, 81, 165, 12, 7, 4, 180, 176, 56, 0, 0, 128, 180},
{1, 32, 208, 14, 7, 4, 180, 176, 57, 0, 0, 128, 180},
{1, 133, 0, 18, 7, 4, 181, 177, 58, 0, 0, 128, 181},
{1, 134, 233, 19, 7, 5, 181, 176, 59, 0, 0, 128, 181},
{1, 132, 14, 21, 7, 5, 181, 176, 60, 0, 0, 128, 181},
{1, 237, 75, 22, 7, 5, 181, 176, 61, 0, 0, 128, 181},
{1, 183, 54, 25, 7, 4, 181, 177, 62, 0, 0, 128, 181},
{1, 236, 101, 27, 7, 4, 182, 178, 63, 0, 0, 128, 182},
{1, 131, 198, 28, 7, 5, 182, 177, 64, 0, 0, 128, 182},
{1, 30, 112, 29, 7, 4, 182, 178, 65, 0, 0, 128, 182},
{1, 133, 104, 30, 7, 5, 182, 177, 66, 0, 0, 128, 182},
{1, 186, 130, 30, 7, 4, 182, 178, 67, 0, 0, 128, 182},
{1, 186, 72, 27, 7, 4, 181, 177, 68, 0, 0, 128, 181},
{1, 236, 90, 14, 7, 5, 179, 174, 69, 0, 0, 128, 179},
{1, 82, 104, 10, 7, 5, 180, 175, 70, 0, 0, 128, 180},
{1, 186, 97, 14, 7, 4, 180, 176, 71, 0, 0, 128, 180},
{1, 82, 18, 17, 7, 5, 181, 176, 72, 0, 0, 128, 181},
{1, 235, 70, 20, 7, 4, 181, 177, 73, 0, 0, 128, 181},
{1, 30, 181, 22, 7, 4, 181, 177, 74, 0, 0, 128, 181},
{1, 133, 29, 23, 7, 4, 181, 177, 75, 0, 0, 128, 181},
{1, 82, 138, 23, 7, 5, 181, 176, 76, 0, 0, 128, 181},
{1, 184, 200, 25, 7, 5, 182, 177, 77, 0, 0, 128, 182},
{1, 134, 6, 28, 7, 5, 182, 177, 78, 0, 0, 128, 182},
{1, 233, 17, 30, 7, 4, 182, 178, 79, 0, 0, 128, 182},
{1, 134, 59, 31, 7, 4, 182, 178, 80, 0, 0, 128, 182},
{1, 186, 220, 30, 7, 4, 182, 178, 81, 0, 0, 128, 182},
{1, 132, 182, 31, 7, 5, 181, 176, 82, 0, 0, 128, 181},
{1, 134, 142, 31, 7, 4, 181, 177, 83, 0, 0, 128, 181},
{1, 134, 25, 24, 7, 4, 180, 176, 84, 0, 0, 128, 180},
{1, 131, 252, 13, 7, 5, 180, 176, 85, 0, 0, 128, 180},
{1, 236, 116, 14, 7, 4, 180, 176, 86, 0, 0, 128, 180},
{1, 30, 92, 17, 7, 5, 181, 176, 87, 0, 0, 128, 181},
{1, 133, 19, 20, 7, 4, 181, 176, 88, 0, 0, 128, 181},
{1, 184, 20, 22, 7, 4, 181, 177, 89, 0, 0, 128, 181},
{1, 81, 7, 23, 7, 4, 181, 177, 90, 0, 0, 128, 181},
{1, 131, 109, 23, 7, 4, 181, 177, 91, 0, 0, 128, 181},
{1, 234, 150, 24, 7, 5, 181, 176, 92, 0, 0, 128, 181},
{1, 84, 17, 26, 7, 4, 180, 176, 93, 0, 0, 128, 180},
{1, 236, 0, 28, 7, 4, 182, 178, 94, 0, 0, 128, 182},
{1, 32, 201, 30, 7, 4, 182, 178, 95, 0, 0, 128, 182},
{1, 83, 146, 31, 7, 4, 182, 178, 96, 0, 0, 128, 182},
{1, 236, 139, 32, 7, 5, 182, 177, 97, 0, 0, 128, 182},
{1, 235, 247, 31, 7, 5, 182, 177, 98, 0, 0, 128, 182},
{1, 186, 180, 28, 7, 4, 180, 176, 99, 0, 0, 128, 180},
{1, 236, 114, 13, 7, 4, 180, 176, 100, 0, 0, 128, 180},
{1, 34, 126, 10, 7, 5, 180, 175, 101, 0, 0, 128, 180},
{1, 81, 136, 14, 7, 5, 180, 175, 102, 0, 0, 128, 180},
{1, 233, 122, 16, 7, 5, 181, 176, 103, 0, 0, 128, 181},
{1, 31, 160, 18, 7, 5, 181, 176, 104, 0, 0, 128, 181},
{1, 184, 115, 22, 7, 4, 181, 177, 105, 0, 0, 128, 181},
{1, 81, 252, 21, 7, 4, 181, 177, 106, 0, 0, 128, 181},
{1, 33, 248, 24, 7, 5, 181, 176, 107, 0, 0, 128, 181},
{1, 236, 113, 27, 7, 5, 182, 177, 108, 0, 0, 128, 182},
{1, 34, 254, 28, 7, 4, 182, 178, 109, 0, 0, 128, 182},
{1, 183, 87, 30, 7, 4, 182, 177, 110, 0, 0, 128, 182},
{1, 186, 133, 32, 7, 4, 181, 176, 111, 0, 0, 128, 181},
{1, 136, 41, 32, 7, 4, 182, 178, 112, 0, 0, 128, 182},
{1, 186, 253, 33, 7, 5, 182, 177, 113, 0, 0, 128, 182},
{1, 83, 228, 33, 7, 5, 182, 177, 114, 0, 0, 128, 182},
{1, 235, 165, 31, 7, 4, 180, 176, 115, 0, 0, 128, 180},
{1, 236, 220, 16, 7, 4, 180, 176, 116, 0, 0, 128, 180},
{1, 80, 140, 14, 7, 4, 180, 176, 117, 0, 0, 128, 180},
{1, 83, 58, 17, 7, 4, 181, 177, 118, 0, 0, 128, 181},
{1, 184, 166, 18, 7, 5, 181, 176, 119, 0, 0, 128, 181},
{1, 31, 209, 20, 7, 4, 181, 177, 120, 0, 0, 128, 181},
{1, 81, 11, 24, 7, 4, 181, 177, 121, 0, 0, 128, 181},
{1, 131, 200, 24, 7, 4, 182, 178, 122, 0, 0, 128, 182},
{1, 82, 210, 25, 7, 4, 181, 177, 123, 0, 0, 128, 181},
{1, 80, 222, 26, 7, 5, 182, 178, 124, 0, 0, 128, 182},
{1, 82, 84, 30, 7, 5, 182, 177, 125, 0, 0, 128, 182},
{1, 83, 185, 31, 7, 4, 182, 178, 126, 0, 0, 128, 182},
{1, 31, 23, 32, 7, 4, 182, 178, 127, 0, 0, 128, 182},
{1, 236, 46, 34, 7, 4, 182, 178, 128, 0, 0, 128, 182},
{1, 183, 85, 34, 7, 5, 182, 177, 129, 0, 0, 128, 182},
{1, 237, 178, 34, 7, 5, 182, 177, 130, 0, 0, 128, 182},
{1, 185, 173, 35, 7, 4, 181, 177, 131, 0, 0, 128, 181},
{1, 237, 11, 24, 7, 4, 179, 175, 132, 0, 0, 128, 179},
{1, 82, 245, 15, 7, 4, 181, 177, 133, 0, 0, 128, 181},
{1, 30, 204, 20, 7, 5, 181, 176, 134, 0, 0, 128, 181},
{1, 30, 114, 24, 7, 5, 182, 177, 135, 0, 0, 128, 182},
{1, 186, 121, 25, 7, 4, 182, 178, 136, 0, 0, 128, 182},
{1, 232, 141, 28, 7, 4, 182, 178, 137, 0, 0, 128, 182},
{1, 32, 52, 30, 7, 4, 182, 178, 138, 0, 0, 128, 182},
{1, 79, 65, 30, 7, 5, 183, 178, 139, 0, 0, 128, 183},
{1, 185, 110, 32, 7, 5, 182, 177, 140, 0, 0, 128, 182},
{1, 81, 86, 33, 7, 4, 182, 178, 141, 0, 0, 128, 182},
{1, 236, 51, 34, 7, 4, 182, 178, 142, 0, 0, 128, 182},
{1, 134, 73, 36, 7, 4, 182, 178, 143, 0, 0, 128, 182},
{1, 186, 178, 35, 7, 4, 182, 178, 144, 0, 0, 128, 182},
{1, 182, 169, 37, 7, 4, 183, 179, 145, 0, 0, 128, 183},
{1, 134, 2, 37, 7, 5, 182, 177, 146, 0, 0, 128, 182},
{1, 134, 232, 32, 7, 4, 181, 177, 147, 0, 0, 128, 181},
{1, 185, 60, 21, 7, 4, 181, 177, 148, 0, 0, 128, 181},
{1, 235, 159, 19, 7, 4, 181, 177, 149, 0, 0, 128, 181},
{1, 237, 135, 22, 7, 4, 181, 177, 150, 0, 0, 128, 181},
{1, 237, 96, 25, 7, 5, 181, 176, 151, 0, 0, 128, 181},
{1, 134, 71, 28, 7, 5, 182, 177, 152, 0, 0, 128, 182},
{1, 81, 211, 29, 7, 4, 182, 178, 153, 0, 0, 128, 182},
{1, 136, 195, 30, 7, 4, 182, 178, 154, 0, 0, 128, 182},
{1, 32, 112, 32, 7, 5, 182, 177, 155, 0, 0, 128, 182},
{1, 185, 16, 34, 7, 5, 182, 178, 156, 0, 0, 128, 182},
{1, 33, 179, 35, 7, 5, 183, 178, 157, 0, 0, 128, 183},
{1, 32, 163, 37, 7, 4, 183, 179, 158, 0, 0, 128, 183},
{1, 133, 64, 38, 7, 4, 183, 179, 159, 0, 0, 128, 183},
{1, 184, 5, 39, 7, 4, 183, 179, 160, 0, 0, 128, 183},
{1, 134, 21, 39, 7, 4, 182, 178, 161, 0, 0, 128, 182},
{1, 81, 59, 38, 7, 5, 182, 177, 162, 0, 0, 128, 182},
{1, 135, 225, 28, 7, 4, 181, 177, 163, 0, 0, 128, 181},
{1, 132, 48, 19, 7, 4, 181, 177, 164, 0, 0, 128, 181},
{1, 185, 246, 19, 7, 4, 181, 177, 165, 0, 0, 128, 181},
{1, 133, 245, 22, 7, 5, 181, 176, 166, 0, 0, 128, 181},
{1, 81, 200, 25, 7, 5, 182, 177, 167, 0, 0, 128, 182},
{1, 82, 146, 28, 7, 4, 182, 178, 168, 0, 0, 128, 182},
{1, 237, 104, 30, 7, 4, 182, 178, 169, 0, 0, 128, 182},
{1, 184, 205, 30, 7, 4, 182, 178, 170, 0, 0, 128, 182},
{1, 30, 88, 32, 7, 4, 182, 178, 171, 0, 0, 128, 182},
{1, 185, 168, 35, 7, 5, 183, 178, 172, 0, 0, 128, 183},
{1, 237, 91, 37, 7, 4, 183, 179, 173, 0, 0, 128, 183},
{1, 187, 156, 38, 7, 4, 183, 179, 174, 0, 0, 128, 183},
{1, 185, 71, 39, 7, 4, 183, 179, 175, 0, 0, 128, 183},
{1, 32, 94, 39, 7, 4, 183, 179, 176, 0, 0, 128, 183},
{1, 131, 141, 40, 7, 4, 183, 179, 177, 0, 0, 128, 183},
{1, 29, 202, 39, 7, 5, 182, 177, 178, 0, 0, 128, 182},
{1, 134, 255, 32, 7, 5, 181, 176, 179, 0, 0, 128, 181},
{1, 235, 31, 21, 7, 4, 181, 177, 180, 0, 0, 128, 181},
{1, 234, 77, 23, 7, 4, 181, 177, 181, 0, 0, 128, 181},
{1, 135, 204, 27, 7, 4, 182, 178, 182, 0, 0, 128, 182},
{1, 31, 40, 28, 7, 4, 182, 178, 183, 0, 0, 128, 182},
{1, 82, 19, 32, 7, 4, 182, 178, 184, 0, 0, 128, 182},
{1, 236, 58, 33, 7, 4, 183, 179, 185, 0, 0, 128, 183},
{1, 32, 68, 33, 7, 4, 182, 177, 186, 0, 0, 128, 182},
{1, 29, 89, 35, 7, 5, 182, 177, 187, 0, 0, 128, 182},
{1, 33, 14, 36, 7, 5, 183, 178, 188, 0, 0, 128, 183},
{1, 131, 178, 38, 7, 5, 181, 176, 189, 0, 0, 128, 181},
{1, 236, 152, 38, 7, 4, 183, 179, 190, 0, 0, 128, 183},
{1, 131, 96, 40, 7, 4, 183, 179, 191, 0, 0, 128, 183},
{1, 235, 182, 41, 7, 4, 183, 179, 192, 0, 0, 128, 183},
{1, 234, 251, 40, 7, 4, 183, 179, 193, 0, 0, 128, 183},
{1, 31, 156, 39, 7, 5, 181, 176, 194, 0, 0, 128, 181},
{1, 183, 195, 26, 7, 4, 181, 177, 195, 0, 0, 128, 181},
{1, 183, 111, 23, 7, 4, 181, 177, 196, 0, 0, 128, 181},
{1, 134, 219, 27, 7, 4, 182, 178, 197, 0, 0, 128, 182},
{1, 32, 100, 31, 7, 4, 182, 178, 198, 0, 0, 128, 182},
{1, 133, 232, 33, 7, 5, 182, 177, 199, 0, 0, 128, 182},
{1, 132, 240, 35, 7, 4, 183, 179, 200, 0, 0, 128, 183},
{1, 82, 146, 36, 7, 4, 182, 178, 201, 0, 0, 128, 182},
{1, 82, 32, 37, 7, 4, 182, 178, 202, 0, 0, 128, 182},
{1, 234, 191, 39, 7, 4, 183, 179, 203, 0, 0, 128, 183},
{1, 235, 25, 41, 7, 5, 183, 178, 204, 0, 0, 128, 183},
{1, 32, 23, 43, 7, 5, 183, 178, 205, 0, 0, 128, 183},
{1, 186, 2, 43, 7, 4, 183, 179, 206, 0, 0, 128, 183},
{1, 81, 145, 43, 7, 4, 183, 179, 207, 0, 0, 128, 183},
{1, 81, 170, 43, 7, 4, 183, 179, 208, 0, 0, 128, 183},
{1, 187, 143, 44, 7, 4, 183, 179, 209, 0, 0, 128, 183},
{1, 31, 110, 37, 7, 4, 181, 177, 210, 0, 0, 128, 181},
{1, 82, 29, 26, 7, 5, 181, 176, 211, 0, 0, 128, 181},
{1, 135, 221, 25, 7, 4, 182, 178, 212, 0, 0, 128, 182},
{1, 237, 218, 29, 7, 4, 182, 178, 213, 0, 0, 128, 182},
{1, 137, 98, 31, 7, 5, 183, 178, 214, 0, 0, 128, 183},
{1, 236, 219, 34, 7, 5, 183, 178, 215, 0, 0, 128, 183},
{1, 134, 163, 35, 7, 4, 182, 178, 216, 0, 0, 128, 182},
{1, 235, 219, 36, 7, 5, 182, 178, 217, 0, 0, 128, 182},
{1, 133, 61, 37, 7, 4, 182, 178, 218, 0, 0, 128, 182},
{1, 84, 155, 39, 7, 5, 183, 178, 219, 0, 0, 128, 183},
{1, 184, 138, 41, 7, 4, 183, 179, 220, 0, 0, 128, 183},
{1, 186, 69, 42, 7, 4, 183, 178, 221, 0, 0, 128, 183},
{1, 185, 18, 43, 7, 4, 183, 179, 222, 0, 0, 128, 183},
{1, 188, 133, 44, 7, 4, 183, 179, 223, 0, 0, 128, 183},
{1, 234, 19, 44, 7, 4, 183, 178, 224, 0, 0, 128, 183},
{1, 236, 163, 42, 7, 4, 182, 178, 225, 0, 0, 128, 182},
{1, 82, 177, 30, 7, 4, 181, 177, 226, 0, 0, 128, 181},
{1, 33, 176, 23, 7, 4, 181, 177, 227, 0, 0, 128, 181},
{1, 133, 160, 24, 7, 4, 181, 177, 228, 0, 0, 128, 181},
{1, 30, 185, 28, 7, 4, 182, 178, 229, 0, 0, 128, 182},
{1, 33, 93, 31, 7, 4, 182, 178, 230, 0, 0, 128, 182},
{1, 183, 70, 34, 7, 5, 182, 177, 231, 0, 0, 128, 182},
{1, 31, 186, 34, 7, 5, 183, 178, 232, 0, 0, 128, 183},
{1, 132, 75, 35, 7, 4, 182, 178, 233, 0, 0, 128, 182},
{1, 133, 30, 39, 7, 4, 183, 179, 234, 0, 0, 128, 183},
{1, 30, 114, 41, 7, 5, 183, 178, 235, 0, 0, 128, 183},
{1, 236, 81, 42, 7, 4, 183, 179, 236, 0, 0, 128, 183},
{1, 236, 175, 43, 7, 5, 183, 178, 237, 0, 0, 128, 183},
{1, 135, 109, 43, 7, 4, 183, 179, 238, 0, 0, 128, 183},
{1, 31, 12, 43, 7, 4, 183, 179, 239, 0, 0, 128, 183},
{1, 135, 112, 44, 7, 4, 183, 179, 240, 0, 0, 128, 183},
{1, 134, 28, 38, 7, 4, 181, 177, 241, 0, 0, 128, 181},
{1, 136, 134, 19, 7, 4, 180, 176, 242, 0, 0, 128, 180},
{1, 30, 195, 7, 7, 4, 179, 175, 243, 0, 0, 128, 179},
{1, 33, 250, 2, 7, 4, 179, 175, 244, 0, 0, 128, 179},
{1, 185, 149, 1, 7, 4, 179, 175, 245, 0, 0, 128, 179},
{1, 185, 106, 5, 7, 4, 180, 176, 246, 0, 0, 128, 180},
{1, 31, 237, 7, 7, 5, 180, 175, 247, 0, 0, 128, 180},
{1, 133, 99, 10, 7, 5, 180, 175, 248, 0, 0, 128, 180},
{1, 84, 34, 14, 7, 4, 180, 176, 249, 0, 0, 128, 180},
{1, 29, 151, 17, 7, 4, 181, 177, 250, 0, 0, 128, 181},
{1, 31, 25, 22, 7, 4, 182, 178, 251, 0, 0, 128, 182},
{1, 83, 29, 25, 7, 4, 182, 178, 252, 0, 0, 128, 182},
{1, 239, 253, 26, 7, 5, 181, 176, 253, 0, 0, 128, 181},
{1, 236, 212, 26, 7, 4, 181, 177, 254, 0, 0, 128, 181},
{1, 236, 43, 28, 7, 4, 181, 177, 255, 0, 0, 128, 181},
{1, 81, 198, 26, 7, 4, 181, 177, 0, 0, 0, 128, 181},
{1, 134, 218, 14, 7, 4, 179, 175, 1, 0, 0, 128, 179},
{1, 187, 222, 0, 7, 4, 178, 174, 2, 0, 0, 128, 178},
{1, 81, 104, 255, 6, 4, 179, 175, 3, 0, 0, 128, 179},
{1, 185, 214, 3, 7, 4, 179, 175, 4, 0, 0, 128, 179},
{1, 185, 123, 7, 7, 4, 180, 176, 5, 0, 0, 128, 180},
{1, 236, 62, 9, 7, 4, 180, 176, 6, 0, 0, 128, 180},
{1, 132, 112, 9, 7, 5, 180, 175, 7, 0, 0, 128, 180},
{1, 30, 226, 8, 7, 5, 180, 175, 8, 0, 0, 128, 180},
{1, 185, 25, 10, 7, 4, 180, 176, 9, 0, 0, 128, 180},
{1, 235, 68, 15, 7, 4, 180, 176, 10, 0, 0, 128, 180},
{1, 85, 75, 19, 7, 4, 181, 177, 11, 0, 0, 128, 181},
{1, 31, 10, 22, 7, 4, 181, 177, 12, 0, 0, 128, 181},
{1, 186, 165, 24, 7, 5, 182, 176, 13, 0, 0, 128, 182},
{1, 236, 205, 25, 7, 4, 182, 178, 14, 0, 0, 128, 182},
{1, 31, 64, 27, 7, 4, 180, 176, 15, 0, 0, 128, 180},
{1, 79, 1, 15, 7, 4, 179, 175, 16, 0, 0, 128, 179},
{1, 133, 112, 252, 6, 4, 178, 174, 17, 0, 0, 128, 178},
{1, 32, 119, 248, 6, 5, 178, 173, 18, 0, 0, 128, 178},
{1, 133, 89, 253, 6, 5, 179, 174, 19, 0, 0, 128, 179},
{1, 132, 156, 1, 7, 4, 179, 175, 20, 0, 0, 128, 179},
{1, 133, 24, 6, 7, 4, 179, 175, 21, 0, 0, 128, 179},
{1, 236, 85, 7, 7, 4, 180, 176, 22, 0, 0, 128, 180},
{1, 28, 122, 9, 7, 5, 180, 175, 23, 0, 0, 128, 180},
{1, 185, 48, 13, 7, 4, 180, 175, 24, 0, 0, 128, 180},
{1, 29, 176, 18, 7, 4, 181, 177, 25, 0, 0, 128, 181},
{1, 29, 111, 21, 7, 4, 181, 177, 26, 0, 0, 128, 181},
{1, 234, 159, 23, 7, 5, 181, 176, 27, 0, 0, 128, 181},
{1, 186, 138, 26, 7, 4, 182, 178, 28, 0, 0, 128, 182},
{1, 235, 197, 27, 7, 4, 182, 178, 29, 0, 0, 128, 182},
{1, 234, 105, 28, 7, 4, 182, 178, 30, 0, 0, 128, 182},
{1, 82, 255, 19, 7, 4, 179, 175, 31, 0, 0, 128, 179},
{1, 135, 232, 7, 7, 4, 180, 176, 32, 0, 0, 128, 180},
{1, 31, 115, 8, 7, 4, 180, 176, 33, 0, 0, 128, 180},
{1, 83, 169, 9, 7, 4, 180, 176, 34, 0, 0, 128, 180},
{1, 183, 102, 9, 7, 4, 180, 175, 35, 0, 0, 128, 180},
{1, 30, 94, 9, 7, 4, 180, 176, 36, 0, 0, 128, 180},
{1, 135, 181, 9, 7, 4, 180, 176, 37, 0, 0, 128, 180},
{1, 234, 39, 11, 7, 5, 180, 175, 38, 0, 0, 128, 180},
{1, 81, 231, 14, 7, 4, 180, 176, 39, 0, 0, 128, 180},
{1, 235, 230, 19, 7, 4, 181, 177, 40, 0, 0, 128, 181},
{1, 32, 251, 23, 7, 4, 181, 177, 41, 0, 0, 128, 181},
{1, 186, 6, 26, 7, 4, 182, 178, 42, 0, 0, 128, 182},
{1, 80, 52, 29, 7, 4, 182, 178, 43, 0, 0, 128, 182},
{1, 81, 211, 30, 7, 5, 182, 177, 44, 0, 0, 128, 182},
{1, 30, 5, 33, 7, 5, 182, 177, 45, 0, 0, 128, 182},
{1, 32, 202, 27, 7, 4, 181, 177, 46, 0, 0, 128, 181},
{1, 133, 102, 12, 7, 4, 179, 175, 47, 0, 0, 128, 179},
{1, 82, 79, 10, 7, 4, 180, 176, 48, 0, 0, 128, 180},
{1, 33, 213, 13, 7, 4, 179, 175, 49, 0, 0, 128, 179},
{1, 32, 165, 17, 7, 5, 181, 176, 50, 0, 0, 128, 181},
{1, 32, 91, 21, 7, 4, 180, 176, 51, 0, 0, 128, 180},
{1, 132, 52, 23, 7, 4, 181, 177, 52, 0, 0, 128, 181},
{1, 83, 69, 25, 7, 4, 181, 177, 53, 0, 0, 128, 181},
{1, 234, 128, 27, 7, 5, 182, 178, 54, 0, 0, 128, 182},
{1, 81, 57, 30, 7, 4, 182, 178, 55, 0, 0, 128, 182},
{1, 133, 34, 32, 7, 5, 182, 177, 56, 0, 0, 128, 182},
{1, 133, 153, 34, 7, 4, 182, 177, 57, 0, 0, 128, 182},
{1, 30, 130, 35, 7, 4, 182, 178, 58, 0, 0, 128, 182},
{1, 30, 67, 35, 7, 4, 183, 179, 59, 0, 0, 128, 183},
{1, 237, 211, 36, 7, 4, 182, 178, 60, 0, 0, 128, 182},
{1, 82, 67, 36, 7, 4, 182, 177, 61, 0, 0, 128, 182},
{1, 235, 216, 24, 7, 4, 180, 175, 62, 0, 0, 128, 180},
{1, 185, 135, 18, 7, 4, 181, 177, 63, 0, 0, 128, 181},
{1, 186, 145, 21, 7, 4, 182, 178, 64, 0, 0, 128, 182},

    
};
#endif
#if 0
const unsigned char PPG_Data[][13] = {
//old pattern
{1,0x10,0x7f,0x3,0x1,0xa,0x4c,0x44,0x14,0x0,0x0,0x80,0x4c},
{1,0xdd,0xae,0x4c,0x1,0x5,0x7a,0x77,0x15,0x0,0x0,0x80,0x7a},
{1,0x8b,0x30,0x20,0x6,0x4,0x9c,0x98,0x16,0x0,0x0,0x80,0x9c},
{1,0xc6,0xaa,0xa0,0x8,0x4,0x95,0x91,0x17,0x0,0x0,0x80,0x95},
{1,0xa2,0x59,0x77,0x8,0x4,0x95,0x91,0x18,0x0,0x0,0x80,0x95},
{1,0xa4,0xcd,0x76,0x8,0x4,0x9a,0x96,0x19,0x0,0x0,0x80,0x9a},
{1,0xf,0xbf,0xa8,0x8,0x4,0x9c,0x98,0x1a,0x0,0x0,0x80,0x9c},
{1,0x7c,0x70,0xdd,0x8,0x3,0xa1,0x9e,0x1b,0x0,0x0,0x80,0xa1},
{1,0xc6,0x16,0xa,0x9,0x7,0xa3,0x9f,0x1c,0x0,0x0,0x80,0xa3},
{1,0x7d,0x84,0x2d,0x9,0x4,0xa5,0xa1,0x1d,0x0,0x0,0x80,0xa5},
{1,0xa0,0x31,0x4f,0x9,0x4,0xa7,0xa3,0x1e,0x0,0x0,0x80,0xa7},
{1,0xe9,0xff,0x6c,0x9,0x5,0xa9,0xa4,0x1f,0x0,0x0,0x80,0xa9},
{1,0xa0,0xf7,0x85,0x9,0x4,0xaa,0xa6,0x20,0x0,0x0,0x80,0xaa},
{1,0x7d,0x10,0x9b,0x9,0x4,0xad,0xa9,0x21,0x0,0x0,0x80,0xad},
{1,0xc8,0x4a,0xaf,0x9,0x5,0xae,0xa9,0x22,0x0,0x0,0x80,0xae},
{1,0xa1,0x61,0xc0,0x9,0x5,0xae,0xa9,0x23,0x0,0x0,0x80,0xae},
{1,0xc5,0x56,0xce,0x9,0x4,0xae,0xaa,0x24,0x0,0x0,0x80,0xae},
{1,0xa2,0xab,0xd2,0x9,0x4,0xae,0xaa,0x25,0x0,0x0,0x80,0xae},
{1,0xe,0x33,0xdb,0x9,0x4,0xaf,0xab,0x26,0x0,0x0,0x80,0xaf},
{1,0xa4,0x23,0xea,0x9,0x4,0xb1,0xad,0x27,0x0,0x0,0x80,0xb1},
{1,0xa4,0x23,0xfa,0x9,0x4,0xb2,0xae,0x28,0x0,0x0,0x80,0xb2},
{1,0xc5,0xca,0x8,0xa,0x4,0xb2,0xae,0x29,0x0,0x0,0x80,0xb2},
{1,0x7c,0xb4,0x15,0xa,0x4,0xb3,0xaf,0x2a,0x0,0x0,0x80,0xb3},
{1,0xeb,0x79,0x1f,0xa,0x5,0xb4,0xaf,0x2b,0x0,0x0,0x80,0xb4},
{1,0xeb,0xf,0x28,0xa,0x4,0xb5,0xb1,0x2c,0x0,0x0,0x80,0xb5},
{1,0xa1,0x1d,0x35,0xa,0x4,0xb6,0xb2,0x2d,0x0,0x0,0x80,0xb6},
{1,0xec,0xdd,0x3d,0xa,0x4,0xb7,0xb3,0x2e,0x0,0x0,0x80,0xb7},
{1,0xc4,0xe4,0x47,0xa,0x4,0xb8,0xb4,0x2f,0x0,0x0,0x80,0xb8},
{1,0x7d,0x5a,0x51,0xa,0x5,0xb8,0xb4,0x30,0x0,0x0,0x80,0xb8},
{1,0x56,0xad,0x5b,0xa,0x4,0xb8,0xb4,0x31,0x0,0x0,0x80,0xb8},
{1,0x7b,0xa,0x64,0xa,0x5,0xb9,0xb4,0x32,0x0,0x0,0x80,0xb9},
{1,0xa3,0x5b,0x65,0xa,0x5,0xb9,0xb4,0x33,0x0,0x0,0x80,0xb9},
{1,0x34,0x8e,0x65,0xa,0x7,0xb9,0xb2,0x34,0x0,0x0,0x80,0xb9},
{1,0x34,0xbe,0x6e,0xa,0x4,0xba,0xb6,0x35,0x0,0x0,0x80,0xba},
{1,0xea,0x53,0x78,0xa,0x4,0xba,0xb6,0x36,0x0,0x0,0x80,0xba},
{1,0xc4,0x8e,0x82,0xa,0x4,0xbb,0xb7,0x37,0x0,0x0,0x80,0xbb},
{1,0xec,0xe1,0x8b,0xa,0x5,0xbc,0xb7,0x38,0x0,0x0,0x80,0xbc},
{1,0x10,0xcb,0x94,0xa,0x5,0xbc,0xb7,0x39,0x0,0x0,0x80,0xbc},
{1,0xe9,0xcf,0x9a,0xa,0x5,0xbd,0xb8,0x3a,0x0,0x0,0x80,0xbd},
{1,0x35,0x4e,0xa3,0xa,0x4,0xbd,0xb9,0x3b,0x0,0x0,0x80,0xbd},
{1,0xc6,0xa4,0xab,0xa,0x4,0xbe,0xba,0x3c,0x0,0x0,0x80,0xbe},
{1,0xc7,0xbe,0xb2,0xa,0x4,0xbe,0xba,0x3d,0x0,0x0,0x80,0xbe},
{1,0x57,0x29,0xb9,0xa,0x4,0xbe,0xba,0x3e,0x0,0x0,0x80,0xbe},
{1,0x10,0x61,0xc1,0xa,0x5,0xbf,0xba,0x3f,0x0,0x0,0x80,0xbf},
{1,0xa0,0xfd,0xc7,0xa,0x5,0xc0,0xbb,0x40,0x0,0x0,0x80,0xc0},
{1,0xea,0xcb,0xc6,0xa,0x5,0xbf,0xba,0x41,0x0,0x0,0x80,0xbf},
{1,0xc5,0x9a,0xc0,0xa,0x4,0xbf,0xbb,0x42,0x0,0x0,0x80,0xbf},
{1,0x57,0x45,0xc1,0xa,0x4,0xbf,0xbb,0x43,0x0,0x0,0x80,0xbf},
{1,0x33,0x74,0xc7,0xa,0x4,0xc0,0xbc,0x44,0x0,0x0,0x80,0xc0},
{1,0xc5,0x8a,0xce,0xa,0x4,0xc1,0xbd,0x45,0x0,0x0,0x80,0xc1},
{1,0x10,0x35,0xd7,0xa,0x4,0xc1,0xbd,0x46,0x0,0x0,0x80,0xc1},
{1,0x5a,0xa5,0xdd,0xa,0x4,0xc1,0xbd,0x47,0x0,0x0,0x80,0xc1},
{1,0xa1,0xa7,0xe0,0xa,0x5,0xc1,0xbc,0x48,0x0,0x0,0x80,0xc1},
{1,0xc6,0xae,0xe5,0xa,0x6,0xc2,0xbc,0x49,0x0,0x0,0x80,0xc2},
{1,0xc3,0xbe,0xed,0xa,0x5,0xc3,0xbe,0x4a,0x0,0x0,0x80,0xc3},
{1,0xd,0xed,0xf3,0xa,0x4,0xc3,0xbe,0x4b,0x0,0x0,0x80,0xc3},
{1,0xeb,0x97,0xf9,0xa,0x4,0xc3,0xbf,0x4c,0x0,0x0,0x80,0xc3},
{1,0xc8,0x90,0xff,0xa,0x5,0xc4,0xbf,0x4d,0x0,0x0,0x80,0xc4},
{1,0xa3,0x6b,0x5,0xb,0x5,0xc4,0xc0,0x4e,0x0,0x0,0x80,0xc4},
{1,0x7f,0xc,0xff,0xa,0x4,0xc2,0xbe,0x4f,0x0,0x0,0x80,0xc2},
{1,0x11,0x2b,0xf8,0xa,0x5,0xc3,0xbe,0x50,0x0,0x0,0x80,0xc3},
{1,0x32,0x40,0xf9,0xa,0x5,0xc3,0xbe,0x51,0x0,0x0,0x80,0xc3},
{1,0x56,0x25,0xfc,0xa,0x5,0xc4,0xbf,0x52,0x0,0x0,0x80,0xc4},
{1,0xa3,0xef,0x1,0xb,0x5,0xc4,0xc0,0x53,0x0,0x0,0x80,0xc4},
{1,0x30,0x4a,0x8,0xb,0x4,0xc4,0xc0,0x54,0x0,0x0,0x80,0xc4},
{1,0x5a,0x37,0xb,0xb,0x4,0xc5,0xc0,0x55,0x0,0x0,0x80,0xc5},
{1,0x59,0x13,0x11,0xb,0x5,0xc6,0xc1,0x56,0x0,0x0,0x80,0xc6},
{1,0x5a,0xb1,0x15,0xb,0x4,0xc6,0xc2,0x57,0x0,0x0,0x80,0xc6},
{1,0x58,0x1,0x1d,0xb,0x4,0xc5,0xc1,0x58,0x0,0x0,0x80,0xc5},
{1,0x36,0x72,0x21,0xb,0x4,0xc6,0xc2,0x59,0x0,0x0,0x80,0xc6},
{1,0xa1,0xd9,0x26,0xb,0x4,0xc6,0xc2,0x5a,0x0,0x0,0x80,0xc6},
{1,0x31,0xbe,0x2b,0xb,0x4,0x8d,0x89,0x5b,0x0,0x0,0x80,0x8d},
{1,0x69,0x6c,0x2a,0xb,0x4,0x8d,0x89,0x5c,0x0,0x0,0x80,0x8d},
{1,0xb6,0x6a,0x1f,0xb,0x4,0x8c,0x88,0x5d,0x0,0x0,0x80,0x8c},
{1,0x86,0x49,0x10,0xb,0x5,0x8c,0x87,0x5e,0x0,0x0,0x80,0x8c},
{1,0xb9,0xd0,0x9,0xb,0x4,0x8c,0x88,0x5f,0x0,0x0,0x80,0x8c},
{1,0x1e,0x1f,0xa,0xb,0x4,0x8c,0x88,0x60,0x0,0x0,0x80,0x8c},
{1,0xb7,0xbe,0x9,0xb,0x4,0x8d,0x89,0x61,0x0,0x0,0x80,0x8d},
{1,0xeb,0x33,0x12,0xb,0x4,0x8d,0x89,0x62,0x0,0x0,0x80,0x8d},
{1,0xb9,0xea,0x16,0xb,0x5,0x8d,0x88,0x63,0x0,0x0,0x80,0x8d},
{1,0x51,0x6e,0x19,0xb,0x4,0x8d,0x89,0x64,0x0,0x0,0x80,0x8d},
{1,0x82,0x5b,0x1b,0xb,0x4,0x8d,0x89,0x65,0x0,0x0,0x80,0x8d},
{1,0xed,0x91,0x1f,0xb,0x4,0x8d,0x89,0x66,0x0,0x0,0x80,0x8d},
{1,0xb8,0x12,0x26,0xb,0x4,0x8e,0x8a,0x67,0x0,0x0,0x80,0x8e},
{1,0xb9,0x70,0x2b,0xb,0x4,0x8e,0x8a,0x68,0x0,0x0,0x80,0x8e},
{1,0xb7,0x66,0x2f,0xb,0x4,0x8e,0x8a,0x69,0x0,0x0,0x80,0x8e},
{1,0x1f,0x5d,0x33,0xb,0x4,0x8e,0x8a,0x6a,0x0,0x0,0x80,0x8e},
{1,0xb9,0xa,0x39,0xb,0x5,0x8e,0x89,0x6b,0x0,0x0,0x80,0x8e},
{1,0x86,0xb,0x2c,0xb,0x4,0x8d,0x89,0x6c,0x0,0x0,0x80,0x8d},
{1,0xb8,0x12,0x1d,0xb,0x4,0x8c,0x88,0x6d,0x0,0x0,0x80,0x8c},
{1,0xec,0x8d,0x13,0xb,0x4,0x8c,0x88,0x6e,0x0,0x0,0x80,0x8c},
{1,0xb7,0x2e,0x10,0xb,0x4,0x8c,0x88,0x6f,0x0,0x0,0x80,0x8c},
{1,0x21,0xd5,0x10,0xb,0x5,0x8c,0x87,0x70,0x0,0x0,0x80,0x8c},
{1,0x51,0xb8,0x13,0xb,0x5,0x8c,0x87,0x71,0x0,0x0,0x80,0x8c},
{1,0xb6,0x7a,0x15,0xb,0x4,0x8d,0x88,0x72,0x0,0x0,0x80,0x8d},
{1,0x53,0x30,0x18,0xb,0x4,0x8d,0x89,0x73,0x0,0x0,0x80,0x8d},
{1,0x86,0xdb,0x1b,0xb,0x4,0x8d,0x89,0x74,0x0,0x0,0x80,0x8d},
{1,0x84,0xa9,0x20,0xb,0x4,0x8d,0x89,0x75,0x0,0x0,0x80,0x8d},
{1,0x20,0x5,0x26,0xb,0x4,0x8d,0x89,0x76,0x0,0x0,0x80,0x8d},
{1,0x52,0xe4,0x27,0xb,0x4,0x8d,0x89,0x77,0x0,0x0,0x80,0x8d},
{1,0x86,0x7b,0x2b,0xb,0x5,0x8e,0x89,0x78,0x0,0x0,0x80,0x8e},
{1,0xed,0x3b,0x32,0xb,0x4,0x8e,0x8a,0x79,0x0,0x0,0x80,0x8e},
{1,0xec,0x1d,0x31,0xb,0x4,0x8d,0x89,0x7a,0x0,0x0,0x80,0x8d},
{1,0x50,0xa0,0x1d,0xb,0x4,0x8c,0x88,0x7b,0x0,0x0,0x80,0x8c},
{1,0xb8,0x16,0xb,0xb,0x6,0x8c,0x86,0x7c,0x0,0x0,0x80,0x8c},
{1,0xee,0x3,0x2,0xb,0x4,0x8b,0x87,0x7d,0x0,0x0,0x80,0x8b},
{1,0xba,0x2a,0xfc,0xa,0x4,0x8b,0x87,0x7e,0x0,0x0,0x80,0x8b},
{1,0xeb,0x2d,0xfe,0xa,0x4,0x8c,0x88,0x7f,0x0,0x0,0x80,0x8c},
{1,0x54,0x4,0x1,0xb,0x4,0x8b,0x87,0x80,0x0,0x0,0x80,0x8b},
{1,0xef,0xf,0x1,0xb,0x5,0x8b,0x86,0x81,0x0,0x0,0x80,0x8b},
{1,0xb9,0xca,0x2,0xb,0x3,0x8c,0x89,0x82,0x0,0x0,0x80,0x8c},
{1,0xba,0xd2,0x5,0xb,0x4,0x8c,0x87,0x83,0x0,0x0,0x80,0x8c},
{1,0x20,0xa5,0xa,0xb,0x5,0x8c,0x87,0x84,0x0,0x0,0x80,0x8c},
{1,0x86,0x2d,0x10,0xb,0x4,0x8d,0x87,0x85,0x0,0x0,0x80,0x8d},
{1,0xb8,0xd6,0x12,0xb,0x4,0x8c,0x88,0x86,0x0,0x0,0x80,0x8c},
{1,0x52,0x68,0x15,0xb,0x4,0x8d,0x89,0x87,0x0,0x0,0x80,0x8d},
{1,0x52,0x92,0x1a,0xb,0x5,0x8c,0x87,0x88,0x0,0x0,0x80,0x8c},
{1,0x20,0x97,0xc,0xb,0x4,0x8a,0x86,0x89,0x0,0x0,0x80,0x8a},
{1,0x1e,0xf5,0xf1,0xa,0x5,0x89,0x84,0x8a,0x0,0x0,0x80,0x89},
{1,0x54,0xec,0xdc,0xa,0x4,0x89,0x85,0x8b,0x0,0x0,0x80,0x89},
{1,0xeb,0xb1,0xd3,0xa,0x4,0x86,0x82,0x8c,0x0,0x0,0x80,0x86},
{1,0x88,0x11,0xcf,0xa,0x4,0x89,0x85,0x8d,0x0,0x0,0x80,0x89},
{1,0x20,0xcd,0xd3,0xa,0x4,0x89,0x85,0x8e,0x0,0x0,0x80,0x89},
{1,0xb9,0x5a,0xd1,0xa,0x4,0x89,0x85,0x8f,0x0,0x0,0x80,0x89},
{1,0xb6,0x6c,0xd4,0xa,0x4,0x89,0x85,0x90,0x0,0x0,0x80,0x89},
{1,0xed,0xbf,0xd8,0xa,0x5,0x8a,0x85,0x91,0x0,0x0,0x80,0x8a},
{1,0x20,0x73,0xdc,0xa,0x4,0x8a,0x86,0x92,0x0,0x0,0x80,0x8a},
{1,0x85,0x23,0xe1,0xa,0x4,0x8a,0x86,0x93,0x0,0x0,0x80,0x8a},
{1,0x53,0x64,0xe5,0xa,0x5,0x8a,0x85,0x94,0x0,0x0,0x80,0x8a},
{1,0xba,0x76,0xe8,0xa,0x5,0x8b,0x86,0x95,0x0,0x0,0x80,0x8b},
{1,0x1f,0xc5,0xee,0xa,0x5,0x89,0x85,0x96,0x0,0x0,0x80,0x89},
{1,0x85,0x2d,0xdf,0xa,0x4,0x88,0x84,0x97,0x0,0x0,0x80,0x88},
{1,0x54,0xbc,0xc1,0xa,0x4,0x87,0x83,0x98,0x0,0x0,0x80,0x87},
{1,0xbc,0xb2,0xab,0xa,0x5,0x87,0x82,0x99,0x0,0x0,0x80,0x87},
{1,0xb8,0xd8,0x9f,0xa,0x5,0x86,0x81,0x9a,0x0,0x0,0x80,0x86},
{1,0x51,0xb8,0x98,0xa,0x4,0x86,0x82,0x9b,0x0,0x0,0x80,0x86},
{1,0x84,0x3d,0x9c,0xa,0x4,0x86,0x82,0x9c,0x0,0x0,0x80,0x86},
{1,0xb7,0x92,0x9c,0xa,0x4,0x86,0x82,0x9d,0x0,0x0,0x80,0x86},
{1,0xeb,0xa3,0x9d,0xa,0x5,0x87,0x82,0x9e,0x0,0x0,0x80,0x87},
{1,0x87,0x99,0xa0,0xa,0x4,0x87,0x83,0x9f,0x0,0x0,0x80,0x87},
{1,0xb8,0x5e,0xa6,0xa,0x4,0x88,0x84,0xa0,0x0,0x0,0x80,0x88},
{1,0x83,0x97,0xa9,0xa,0x5,0x87,0x83,0xa1,0x0,0x0,0x80,0x87},
{1,0xec,0x77,0xaf,0xa,0x4,0x88,0x84,0xa2,0x0,0x0,0x80,0x88},
{1,0xec,0x85,0xb3,0xa,0x4,0x88,0x84,0xa3,0x0,0x0,0x80,0x88},
{1,0x52,0x54,0xb9,0xa,0x4,0x87,0x84,0xa4,0x0,0x0,0x80,0x87},
{1,0xb8,0xe6,0xb0,0xa,0x4,0x86,0x82,0xa5,0x0,0x0,0x80,0x86},
{1,0x1e,0xbd,0x89,0xa,0x4,0x84,0x80,0xa6,0x0,0x0,0x80,0x84},
{1,0xec,0xa3,0x62,0xa,0x5,0x82,0x7d,0xa7,0x0,0x0,0x80,0x82},
{1,0x52,0x84,0x4d,0xa,0x4,0x82,0x7e,0xa8,0x0,0x0,0x80,0x82},
{1,0x54,0x80,0x40,0xa,0x4,0x82,0x7e,0xa9,0x0,0x0,0x80,0x82},
{1,0xea,0xfb,0x3e,0xa,0x4,0x82,0x7e,0xaa,0x0,0x0,0x80,0x82},
{1,0x86,0xa5,0x3f,0xa,0x5,0x82,0x7d,0xab,0x0,0x0,0x80,0x82},
{1,0xb9,0x6e,0x3d,0xa,0x4,0x82,0x7e,0xac,0x0,0x0,0x80,0x82},


{1,0x10,0x7f,0x3,0x1,0xa,0x4c,0x44,0x14,0x0,0x0,0x80,0x4c},
{1,0xdd,0xae,0x4c,0x1,0x5,0x7a,0x77,0x15,0x0,0x0,0x80,0x7a},
{1,0x8b,0x30,0x20,0x6,0x4,0x9c,0x98,0x16,0x0,0x0,0x80,0x9c},
{1,0xc6,0xaa,0xa0,0x8,0x4,0x95,0x91,0x17,0x0,0x0,0x80,0x95},
{1,0xa2,0x59,0x77,0x8,0x4,0x95,0x91,0x18,0x0,0x0,0x80,0x95},
{1,0xa4,0xcd,0x76,0x8,0x4,0x9a,0x96,0x19,0x0,0x0,0x80,0x9a},
{1,0xf,0xbf,0xa8,0x8,0x4,0x9c,0x98,0x1a,0x0,0x0,0x80,0x9c},
{1,0x7c,0x70,0xdd,0x8,0x3,0xa1,0x9e,0x1b,0x0,0x0,0x80,0xa1},
{1,0xc6,0x16,0xa,0x9,0x7,0xa3,0x9f,0x1c,0x0,0x0,0x80,0xa3},
{1,0x7d,0x84,0x2d,0x9,0x4,0xa5,0xa1,0x1d,0x0,0x0,0x80,0xa5},
{1,0xa0,0x31,0x4f,0x9,0x4,0xa7,0xa3,0x1e,0x0,0x0,0x80,0xa7},
{1,0xe9,0xff,0x6c,0x9,0x5,0xa9,0xa4,0x1f,0x0,0x0,0x80,0xa9},
{1,0xa0,0xf7,0x85,0x9,0x4,0xaa,0xa6,0x20,0x0,0x0,0x80,0xaa},
{1,0x7d,0x10,0x9b,0x9,0x4,0xad,0xa9,0x21,0x0,0x0,0x80,0xad},
{1,0xc8,0x4a,0xaf,0x9,0x5,0xae,0xa9,0x22,0x0,0x0,0x80,0xae},
{1,0xa1,0x61,0xc0,0x9,0x5,0xae,0xa9,0x23,0x0,0x0,0x80,0xae},
{1,0xc5,0x56,0xce,0x9,0x4,0xae,0xaa,0x24,0x0,0x0,0x80,0xae},
{1,0xa2,0xab,0xd2,0x9,0x4,0xae,0xaa,0x25,0x0,0x0,0x80,0xae},
{1,0xe,0x33,0xdb,0x9,0x4,0xaf,0xab,0x26,0x0,0x0,0x80,0xaf},
{1,0xa4,0x23,0xea,0x9,0x4,0xb1,0xad,0x27,0x0,0x0,0x80,0xb1},
{1,0xa4,0x23,0xfa,0x9,0x4,0xb2,0xae,0x28,0x0,0x0,0x80,0xb2},
{1,0xc5,0xca,0x8,0xa,0x4,0xb2,0xae,0x29,0x0,0x0,0x80,0xb2},
{1,0x7c,0xb4,0x15,0xa,0x4,0xb3,0xaf,0x2a,0x0,0x0,0x80,0xb3},
{1,0xeb,0x79,0x1f,0xa,0x5,0xb4,0xaf,0x2b,0x0,0x0,0x80,0xb4},
{1,0xeb,0xf,0x28,0xa,0x4,0xb5,0xb1,0x2c,0x0,0x0,0x80,0xb5},
{1,0xa1,0x1d,0x35,0xa,0x4,0xb6,0xb2,0x2d,0x0,0x0,0x80,0xb6},
{1,0xec,0xdd,0x3d,0xa,0x4,0xb7,0xb3,0x2e,0x0,0x0,0x80,0xb7},
{1,0xc4,0xe4,0x47,0xa,0x4,0xb8,0xb4,0x2f,0x0,0x0,0x80,0xb8},
{1,0x7d,0x5a,0x51,0xa,0x5,0xb8,0xb4,0x30,0x0,0x0,0x80,0xb8},
{1,0x56,0xad,0x5b,0xa,0x4,0xb8,0xb4,0x31,0x0,0x0,0x80,0xb8},
{1,0x7b,0xa,0x64,0xa,0x5,0xb9,0xb4,0x32,0x0,0x0,0x80,0xb9},
{1,0xa3,0x5b,0x65,0xa,0x5,0xb9,0xb4,0x33,0x0,0x0,0x80,0xb9},
{1,0x34,0x8e,0x65,0xa,0x7,0xb9,0xb2,0x34,0x0,0x0,0x80,0xb9},
{1,0x34,0xbe,0x6e,0xa,0x4,0xba,0xb6,0x35,0x0,0x0,0x80,0xba},
{1,0xea,0x53,0x78,0xa,0x4,0xba,0xb6,0x36,0x0,0x0,0x80,0xba},
{1,0xc4,0x8e,0x82,0xa,0x4,0xbb,0xb7,0x37,0x0,0x0,0x80,0xbb},
{1,0xec,0xe1,0x8b,0xa,0x5,0xbc,0xb7,0x38,0x0,0x0,0x80,0xbc},
{1,0x10,0xcb,0x94,0xa,0x5,0xbc,0xb7,0x39,0x0,0x0,0x80,0xbc},
{1,0xe9,0xcf,0x9a,0xa,0x5,0xbd,0xb8,0x3a,0x0,0x0,0x80,0xbd},
{1,0x35,0x4e,0xa3,0xa,0x4,0xbd,0xb9,0x3b,0x0,0x0,0x80,0xbd},
{1,0xc6,0xa4,0xab,0xa,0x4,0xbe,0xba,0x3c,0x0,0x0,0x80,0xbe},
{1,0xc7,0xbe,0xb2,0xa,0x4,0xbe,0xba,0x3d,0x0,0x0,0x80,0xbe},
{1,0x57,0x29,0xb9,0xa,0x4,0xbe,0xba,0x3e,0x0,0x0,0x80,0xbe},
{1,0x10,0x61,0xc1,0xa,0x5,0xbf,0xba,0x3f,0x0,0x0,0x80,0xbf},
{1,0xa0,0xfd,0xc7,0xa,0x5,0xc0,0xbb,0x40,0x0,0x0,0x80,0xc0},
{1,0xea,0xcb,0xc6,0xa,0x5,0xbf,0xba,0x41,0x0,0x0,0x80,0xbf},
{1,0xc5,0x9a,0xc0,0xa,0x4,0xbf,0xbb,0x42,0x0,0x0,0x80,0xbf},
{1,0x57,0x45,0xc1,0xa,0x4,0xbf,0xbb,0x43,0x0,0x0,0x80,0xbf},
{1,0x33,0x74,0xc7,0xa,0x4,0xc0,0xbc,0x44,0x0,0x0,0x80,0xc0},
{1,0xc5,0x8a,0xce,0xa,0x4,0xc1,0xbd,0x45,0x0,0x0,0x80,0xc1},
{1,0x10,0x35,0xd7,0xa,0x4,0xc1,0xbd,0x46,0x0,0x0,0x80,0xc1},
{1,0x5a,0xa5,0xdd,0xa,0x4,0xc1,0xbd,0x47,0x0,0x0,0x80,0xc1},
{1,0xa1,0xa7,0xe0,0xa,0x5,0xc1,0xbc,0x48,0x0,0x0,0x80,0xc1},
{1,0xc6,0xae,0xe5,0xa,0x6,0xc2,0xbc,0x49,0x0,0x0,0x80,0xc2},
{1,0xc3,0xbe,0xed,0xa,0x5,0xc3,0xbe,0x4a,0x0,0x0,0x80,0xc3},
{1,0xd,0xed,0xf3,0xa,0x4,0xc3,0xbe,0x4b,0x0,0x0,0x80,0xc3},
{1,0xeb,0x97,0xf9,0xa,0x4,0xc3,0xbf,0x4c,0x0,0x0,0x80,0xc3},
{1,0xc8,0x90,0xff,0xa,0x5,0xc4,0xbf,0x4d,0x0,0x0,0x80,0xc4},
{1,0xa3,0x6b,0x5,0xb,0x5,0xc4,0xc0,0x4e,0x0,0x0,0x80,0xc4},
{1,0x7f,0xc,0xff,0xa,0x4,0xc2,0xbe,0x4f,0x0,0x0,0x80,0xc2},
{1,0x11,0x2b,0xf8,0xa,0x5,0xc3,0xbe,0x50,0x0,0x0,0x80,0xc3},
{1,0x32,0x40,0xf9,0xa,0x5,0xc3,0xbe,0x51,0x0,0x0,0x80,0xc3},
{1,0x56,0x25,0xfc,0xa,0x5,0xc4,0xbf,0x52,0x0,0x0,0x80,0xc4},
{1,0xa3,0xef,0x1,0xb,0x5,0xc4,0xc0,0x53,0x0,0x0,0x80,0xc4},
{1,0x30,0x4a,0x8,0xb,0x4,0xc4,0xc0,0x54,0x0,0x0,0x80,0xc4},
{1,0x5a,0x37,0xb,0xb,0x4,0xc5,0xc0,0x55,0x0,0x0,0x80,0xc5},
{1,0x59,0x13,0x11,0xb,0x5,0xc6,0xc1,0x56,0x0,0x0,0x80,0xc6},
{1,0x5a,0xb1,0x15,0xb,0x4,0xc6,0xc2,0x57,0x0,0x0,0x80,0xc6},
{1,0x58,0x1,0x1d,0xb,0x4,0xc5,0xc1,0x58,0x0,0x0,0x80,0xc5},
{1,0x36,0x72,0x21,0xb,0x4,0xc6,0xc2,0x59,0x0,0x0,0x80,0xc6},
{1,0xa1,0xd9,0x26,0xb,0x4,0xc6,0xc2,0x5a,0x0,0x0,0x80,0xc6},
{1,0x31,0xbe,0x2b,0xb,0x4,0x8d,0x89,0x5b,0x0,0x0,0x80,0x8d},
{1,0x69,0x6c,0x2a,0xb,0x4,0x8d,0x89,0x5c,0x0,0x0,0x80,0x8d},
{1,0xb6,0x6a,0x1f,0xb,0x4,0x8c,0x88,0x5d,0x0,0x0,0x80,0x8c},
{1,0x86,0x49,0x10,0xb,0x5,0x8c,0x87,0x5e,0x0,0x0,0x80,0x8c},
{1,0xb9,0xd0,0x9,0xb,0x4,0x8c,0x88,0x5f,0x0,0x0,0x80,0x8c},
{1,0x1e,0x1f,0xa,0xb,0x4,0x8c,0x88,0x60,0x0,0x0,0x80,0x8c},
{1,0xb7,0xbe,0x9,0xb,0x4,0x8d,0x89,0x61,0x0,0x0,0x80,0x8d},
{1,0xeb,0x33,0x12,0xb,0x4,0x8d,0x89,0x62,0x0,0x0,0x80,0x8d},
{1,0xb9,0xea,0x16,0xb,0x5,0x8d,0x88,0x63,0x0,0x0,0x80,0x8d},
{1,0x51,0x6e,0x19,0xb,0x4,0x8d,0x89,0x64,0x0,0x0,0x80,0x8d},
{1,0x82,0x5b,0x1b,0xb,0x4,0x8d,0x89,0x65,0x0,0x0,0x80,0x8d},
{1,0xed,0x91,0x1f,0xb,0x4,0x8d,0x89,0x66,0x0,0x0,0x80,0x8d},
{1,0xb8,0x12,0x26,0xb,0x4,0x8e,0x8a,0x67,0x0,0x0,0x80,0x8e},
{1,0xb9,0x70,0x2b,0xb,0x4,0x8e,0x8a,0x68,0x0,0x0,0x80,0x8e},
{1,0xb7,0x66,0x2f,0xb,0x4,0x8e,0x8a,0x69,0x0,0x0,0x80,0x8e},
{1,0x1f,0x5d,0x33,0xb,0x4,0x8e,0x8a,0x6a,0x0,0x0,0x80,0x8e},
{1,0xb9,0xa,0x39,0xb,0x5,0x8e,0x89,0x6b,0x0,0x0,0x80,0x8e},
{1,0x86,0xb,0x2c,0xb,0x4,0x8d,0x89,0x6c,0x0,0x0,0x80,0x8d},
{1,0xb8,0x12,0x1d,0xb,0x4,0x8c,0x88,0x6d,0x0,0x0,0x80,0x8c},
{1,0xec,0x8d,0x13,0xb,0x4,0x8c,0x88,0x6e,0x0,0x0,0x80,0x8c},
{1,0xb7,0x2e,0x10,0xb,0x4,0x8c,0x88,0x6f,0x0,0x0,0x80,0x8c},
{1,0x21,0xd5,0x10,0xb,0x5,0x8c,0x87,0x70,0x0,0x0,0x80,0x8c},
{1,0x51,0xb8,0x13,0xb,0x5,0x8c,0x87,0x71,0x0,0x0,0x80,0x8c},
{1,0xb6,0x7a,0x15,0xb,0x4,0x8d,0x88,0x72,0x0,0x0,0x80,0x8d},
{1,0x53,0x30,0x18,0xb,0x4,0x8d,0x89,0x73,0x0,0x0,0x80,0x8d},
{1,0x86,0xdb,0x1b,0xb,0x4,0x8d,0x89,0x74,0x0,0x0,0x80,0x8d},
{1,0x84,0xa9,0x20,0xb,0x4,0x8d,0x89,0x75,0x0,0x0,0x80,0x8d},
{1,0x20,0x5,0x26,0xb,0x4,0x8d,0x89,0x76,0x0,0x0,0x80,0x8d},
{1,0x52,0xe4,0x27,0xb,0x4,0x8d,0x89,0x77,0x0,0x0,0x80,0x8d},
{1,0x86,0x7b,0x2b,0xb,0x5,0x8e,0x89,0x78,0x0,0x0,0x80,0x8e},
{1,0xed,0x3b,0x32,0xb,0x4,0x8e,0x8a,0x79,0x0,0x0,0x80,0x8e},
{1,0xec,0x1d,0x31,0xb,0x4,0x8d,0x89,0x7a,0x0,0x0,0x80,0x8d},
{1,0x50,0xa0,0x1d,0xb,0x4,0x8c,0x88,0x7b,0x0,0x0,0x80,0x8c},
{1,0xb8,0x16,0xb,0xb,0x6,0x8c,0x86,0x7c,0x0,0x0,0x80,0x8c},
{1,0xee,0x3,0x2,0xb,0x4,0x8b,0x87,0x7d,0x0,0x0,0x80,0x8b},
{1,0xba,0x2a,0xfc,0xa,0x4,0x8b,0x87,0x7e,0x0,0x0,0x80,0x8b},
{1,0xeb,0x2d,0xfe,0xa,0x4,0x8c,0x88,0x7f,0x0,0x0,0x80,0x8c},
{1,0x54,0x4,0x1,0xb,0x4,0x8b,0x87,0x80,0x0,0x0,0x80,0x8b},
{1,0xef,0xf,0x1,0xb,0x5,0x8b,0x86,0x81,0x0,0x0,0x80,0x8b},
{1,0xb9,0xca,0x2,0xb,0x3,0x8c,0x89,0x82,0x0,0x0,0x80,0x8c},
{1,0xba,0xd2,0x5,0xb,0x4,0x8c,0x87,0x83,0x0,0x0,0x80,0x8c},
{1,0x20,0xa5,0xa,0xb,0x5,0x8c,0x87,0x84,0x0,0x0,0x80,0x8c},
{1,0x86,0x2d,0x10,0xb,0x4,0x8d,0x87,0x85,0x0,0x0,0x80,0x8d},
{1,0xb8,0xd6,0x12,0xb,0x4,0x8c,0x88,0x86,0x0,0x0,0x80,0x8c},
{1,0x52,0x68,0x15,0xb,0x4,0x8d,0x89,0x87,0x0,0x0,0x80,0x8d},
{1,0x52,0x92,0x1a,0xb,0x5,0x8c,0x87,0x88,0x0,0x0,0x80,0x8c},
{1,0x20,0x97,0xc,0xb,0x4,0x8a,0x86,0x89,0x0,0x0,0x80,0x8a},
{1,0x1e,0xf5,0xf1,0xa,0x5,0x89,0x84,0x8a,0x0,0x0,0x80,0x89},
{1,0x54,0xec,0xdc,0xa,0x4,0x89,0x85,0x8b,0x0,0x0,0x80,0x89},
{1,0xeb,0xb1,0xd3,0xa,0x4,0x86,0x82,0x8c,0x0,0x0,0x80,0x86},
{1,0x88,0x11,0xcf,0xa,0x4,0x89,0x85,0x8d,0x0,0x0,0x80,0x89},
{1,0x20,0xcd,0xd3,0xa,0x4,0x89,0x85,0x8e,0x0,0x0,0x80,0x89},
{1,0xb9,0x5a,0xd1,0xa,0x4,0x89,0x85,0x8f,0x0,0x0,0x80,0x89},
{1,0xb6,0x6c,0xd4,0xa,0x4,0x89,0x85,0x90,0x0,0x0,0x80,0x89},
{1,0xed,0xbf,0xd8,0xa,0x5,0x8a,0x85,0x91,0x0,0x0,0x80,0x8a},
{1,0x20,0x73,0xdc,0xa,0x4,0x8a,0x86,0x92,0x0,0x0,0x80,0x8a},
{1,0x85,0x23,0xe1,0xa,0x4,0x8a,0x86,0x93,0x0,0x0,0x80,0x8a},
{1,0x53,0x64,0xe5,0xa,0x5,0x8a,0x85,0x94,0x0,0x0,0x80,0x8a},
{1,0xba,0x76,0xe8,0xa,0x5,0x8b,0x86,0x95,0x0,0x0,0x80,0x8b},
{1,0x1f,0xc5,0xee,0xa,0x5,0x89,0x85,0x96,0x0,0x0,0x80,0x89},
{1,0x85,0x2d,0xdf,0xa,0x4,0x88,0x84,0x97,0x0,0x0,0x80,0x88},
{1,0x54,0xbc,0xc1,0xa,0x4,0x87,0x83,0x98,0x0,0x0,0x80,0x87},
{1,0xbc,0xb2,0xab,0xa,0x5,0x87,0x82,0x99,0x0,0x0,0x80,0x87},
{1,0xb8,0xd8,0x9f,0xa,0x5,0x86,0x81,0x9a,0x0,0x0,0x80,0x86},
{1,0x51,0xb8,0x98,0xa,0x4,0x86,0x82,0x9b,0x0,0x0,0x80,0x86},
{1,0x84,0x3d,0x9c,0xa,0x4,0x86,0x82,0x9c,0x0,0x0,0x80,0x86},
{1,0xb7,0x92,0x9c,0xa,0x4,0x86,0x82,0x9d,0x0,0x0,0x80,0x86},
{1,0xeb,0xa3,0x9d,0xa,0x5,0x87,0x82,0x9e,0x0,0x0,0x80,0x87},
{1,0x87,0x99,0xa0,0xa,0x4,0x87,0x83,0x9f,0x0,0x0,0x80,0x87},
{1,0xb8,0x5e,0xa6,0xa,0x4,0x88,0x84,0xa0,0x0,0x0,0x80,0x88},
{1,0x83,0x97,0xa9,0xa,0x5,0x87,0x83,0xa1,0x0,0x0,0x80,0x87},
{1,0xec,0x77,0xaf,0xa,0x4,0x88,0x84,0xa2,0x0,0x0,0x80,0x88},
{1,0xec,0x85,0xb3,0xa,0x4,0x88,0x84,0xa3,0x0,0x0,0x80,0x88},
{1,0x52,0x54,0xb9,0xa,0x4,0x87,0x84,0xa4,0x0,0x0,0x80,0x87},
{1,0xb8,0xe6,0xb0,0xa,0x4,0x86,0x82,0xa5,0x0,0x0,0x80,0x86},
{1,0x1e,0xbd,0x89,0xa,0x4,0x84,0x80,0xa6,0x0,0x0,0x80,0x84},
{1,0xec,0xa3,0x62,0xa,0x5,0x82,0x7d,0xa7,0x0,0x0,0x80,0x82},
{1,0x52,0x84,0x4d,0xa,0x4,0x82,0x7e,0xa8,0x0,0x0,0x80,0x82},
{1,0x54,0x80,0x40,0xa,0x4,0x82,0x7e,0xa9,0x0,0x0,0x80,0x82},
{1,0xea,0xfb,0x3e,0xa,0x4,0x82,0x7e,0xaa,0x0,0x0,0x80,0x82},
{1,0x86,0xa5,0x3f,0xa,0x5,0x82,0x7d,0xab,0x0,0x0,0x80,0x82},
{1,0xb9,0x6e,0x3d,0xa,0x4,0x82,0x7e,0xac,0x0,0x0,0x80,0x82},

};

#endif

#endif
