//Author: Jing and Simon

#include "mbed.h"
#include "Adafruit_PWMServoDriver.h"

#define STRONG 39
#define MEDIUM 22
#define WEAK 5



// Contains the color codes - Red, Green, Blue
int purple[]    =   {204,   0,      255};
int orange[]    =   {255,   69,     0};
int pink[]      =   {255,   0,      255};
int blue[]      =   {0,     0,      255};
int black[]     =   {0,     0,      0};
int red[]       =   {255,   0,      0};
int green[]     =   {0,     255,    0};

Adafruit_PWMServoDriver pwm(p9, p10);

void setServoPulse(uint8_t n, float pulse) {
    float pulselength = 10000;   // 10,000 us per second
    pulse = 4094 * pulse / pulselength;
    pwm.setPWM(n, 0, pulse);
}

void setColor(int *color, int intensity, int duration){
    setServoPulse(0, color[0] * intensity);
    setServoPulse(1, color[1] * intensity);
    setServoPulse(2, color[2] * intensity); 
    wait_ms(duration);   
}

void initServoDriver() {
    pwm.begin();
    //pwm.setPWMFreq(100);  //This dosen't work well because of uncertain clock speed. Use setPrescale().
    pwm.setPrescale(64);    //This value is decided for 10ms interval.
    pwm.setI2Cfreq(400000); //400kHz
}

int main() {
    //pwm.i2c_probe();
    initServoDriver();

    while(1){       
       
        // Test basic color patterns
        setColor(purple, STRONG, 1000);    
        setColor(orange, STRONG, 1000);  
        setColor(pink, STRONG, 1000);
        setColor(blue, STRONG, 1000); 
       
        // Test blinking patterns
        for(int i = 0 ; i < 10 ; i++){
            setColor(red, STRONG, 250);
            setColor(green, STRONG, 250);   
        }
        
        // Test dimming
        for(int i = 10 ; i < 0 ; i++){
            setColor(blue, 4 * i, 250);
        }
           
    }

}