#include "mbed.h"
#include "MRF24J40.h"
#include "Actuator.h"
#include <string>
#include <sstream>
#include <vector>
#include <stdio.h>      /* printf, scanf, puts, NULL */
#include <stdlib.h>     /* srand, rand */
#include <time.h>
#include "rtos.h"

DigitalOut myled(LED3);  //for vest test
DigitalOut led1(LED1);   //for RF test


PwmOut motor1(p25);
PwmOut motor2(p26);
PwmOut motor3(p23);
PwmOut motor4(p24);
PwmOut motor5(p22);
PwmOut motor6(p21);
Serial pc(USBTX, USBRX);
Timeout to1;
Timeout to2;
Timeout to3;
Timeout to4;
Timeout to5;
Timeout to6;

Actuator actuator1(0,1,motor1,to1);
Actuator actuator2(0,2,motor2,to2);
Actuator actuator3(0,3,motor3,to3);
Actuator actuator4(0,4,motor4,to4);
Actuator actuator5(0,5,motor5,to5);
Actuator actuator6(0,5,motor6,to6);



// Timeout for vibration

// RF tranceiver to link with handheld.
MRF24J40 mrf(p11, p12, p13, p14, p21);

char rxBuffer[128];
uint8_t rxLen;
uint32_t duration;
uint32_t viberation;

int rf_receive(char *data, uint8_t maxLength)
{
    uint8_t len = mrf.Receive((uint8_t *)data, maxLength);
    //pc.printf("data: %s, %d\r\n",data,len);
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};
    if(len > 10) {
        //Remove the header and footer of the message
        for(uint8_t i = 0; i < len-2; i++) {
            if(i<8) {
                //Make sure our header is valid first
                if(data[i] != header[i])
                    return 0;
            } else {
                data[i-8] = data[i];
            }
        }
        pc.printf("Received: %s length:%d\r\n", data, ((int)len)-10);
    }
    return ((int)len)-10;
}

std::vector<std::string> split(const std::string &str, char delimiter, std::vector<std::string> extract)
{
    std::stringstream ss(str);
    std::string item;
    while (std::getline(ss, item, delimiter)) {
        extract.push_back(item);
    }
    return extract;
}


void updateMotors(uint32_t dur) {
    float durinsec = dur/1000.0;
    if(actuator1.getM()) actuator1.getTo().attach(&actuator1,&Actuator::shot,durinsec);
    if(actuator2.getM()) actuator2.getTo().attach(&actuator2,&Actuator::shot,durinsec);
    if(actuator3.getM()) actuator3.getTo().attach(&actuator3,&Actuator::shot,durinsec);
    if(actuator4.getM()) actuator4.getTo().attach(&actuator4,&Actuator::shot,durinsec);
    if(actuator5.getM()) actuator5.getTo().attach(&actuator5,&Actuator::shot,durinsec);
    if(actuator6.getM()) actuator6.getTo().attach(&actuator6,&Actuator::shot,durinsec);
}


int main() {
    myled = 0;
    pc.baud(115200);
    
    pc.printf("Client Vest\r\n");
    while(1){
        // Check if any data was received. 
        rxLen = rf_receive(rxBuffer,64);
        if(rxLen) 
        {
            pc.printf("Received string %s \r\n",rxBuffer);
            std::vector<std::string> msg;
            /*split the buffer based on the delimiter ',' and save into extract*/
            msg = split(std::string(rxBuffer),'/',msg);
            
            if(msg[0]=="all"||msg[0]=="vest")
            { 
            std::vector<std::string> extract;
            extract = split(msg[3],',',extract);    //vest is the second part of the msg
            
                if(!extract[0].compare("V")) {
                
                    if(!extract[1].compare("A")) {
                
                    const char* control = extract[2].c_str();
                    duration = std::atoi(extract[3].c_str()); // duration
                    viberation = std::atoi(extract[4].c_str()); // viberation
                
                    if(strlen(control)==6)
                    {
                    if(control[0]=='1'){
                       actuator1.setMotor(viberation);
                       actuator1.setM(1);
                       //updateMotors(duration);
                       }
                    if(control[1]=='1'){
                       actuator2.setMotor(viberation);
                       actuator2.setM(1);
                       //updateMotors(duration);
                       }
                    if(control[2]=='1'){
                       actuator3.setMotor(viberation);
                       actuator3.setM(1);
                       //updateMotors(duration);
                       }
                    if(control[3]=='1'){
                       actuator4.setMotor(viberation);
                       actuator4.setM(1);
                       updateMotors(duration);
                       }
                    if(control[4]=='1'){
                       actuator5.setMotor(viberation);
                       actuator5.setM(1);
                       //updateMotors(duration);
                       }
                    if(control[5]=='1'){
                       actuator6.setMotor(viberation);
                       actuator6.setM(1);
                       //updateMotors(duration);
                       }
                    updateMotors(duration);
                    }
                    else pc.printf("error!\r\n");                
                
                }
                
                if(!extract[1].compare("C")){
                       actuator1.setMotor(0);
                       actuator1.setM(0);
                       actuator2.setMotor(0);
                       actuator2.setM(0);
                       actuator3.setMotor(0);
                       actuator3.setM(0);
                       actuator4.setMotor(0);
                       actuator4.setM(0);
                       actuator5.setMotor(0);
                       actuator5.setM(0);
                       actuator6.setMotor(0);
                       actuator6.setM(0);
                       viberation = 0;
                       updateMotors(duration);
                       }            
                }
                else{
                    pc.printf("error!\r\n");
                    }

            
        
        }
          
        }
    }
}
