#include "mbed.h"
#include<string>
#include <sstream>
#include <vector>
#include "rtos.h"
#include "OSCmsg.h"
#include "MRF24J40.h"
#include <stdio.h>      /* printf, scanf, puts, NULL */
#include <stdlib.h>     /* srand, rand */
#include <time.h>       /* time */


#include "led_patterns.h"
#include "choosePattern.h"

#define WAVE_DELAY 50

Serial pc(USBTX, USBRX);    // Serial communication for debugging purposes
Mutex stdio_mutex;


#define ROWS 2          // Rows of leds; each seperate strip is considered as a row
#define COLS 26         // number of leds per row

LPD8806 strip = LPD8806(26);

MRF24J40 mrf(p11,p12,p13,p14,p21); // pins for zig bee
int grid[ROWS][COLS] = {10}; //


int rf_receive(char *data, uint8_t maxLength)
{
    uint8_t len = mrf.Receive((uint8_t *)data, maxLength);
    //pc.printf("data: %s, %d\r\n",data,len);
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};
    if(len > 10) {
        //Remove the header and footer of the message
        for(uint8_t i = 0; i < len-2; i++) {
            if(i<8) {
                //Make sure our header is valid first
                if(data[i] != header[i])
                    return 0;
            } else {
                data[i-8] = data[i];
            }
        }
        pc.printf("Received: %s length:%d\r\n", data, ((int)len)-10);
    }
    return ((int)len)-10;
}


// Used for sending and receiving
char rxBuffer[128];
int rxLen;

typedef enum {NEMO,ROCKET,BEYONCE,BOWL,NILL1,FLASH1,DEFAULT,OFF} stat;
volatile stat status = DEFAULT;


/*Extracts the individual strings and saves them into a vector*/
std::vector<std::string> split(const std::string &str, char delimiter, std::vector<std::string> extract)
{
    std::stringstream ss(str);
    std::string item;
    while (std::getline(ss, item, delimiter)) {
        extract.push_back(item);
    }
    return extract;
}

/*Chooses RGB value based on string*/
void getColor(uint8_t *R,uint8_t *G,uint8_t *B,std::string str)
{
    char V = str[0];
    switch(V) {
        case 'R':
            *R = 255;
            *G = 0;
            *B = 0;
            break;
        case 'G':
            *R = 0;
            *G = 255;
            *B = 0;
            break;
        case 'B':
            *R = 0;
            *G = 0;
            *B = 255;
            break;
        case 'Y':
            *R = 255;
            *G = 255;
            *B = 0;
            break;
        case 'C':
            *R = 0;
            *G = 255;
            *B = 255;
            break;
        case 'M':
            *R = 255;
            *G = 0;
            *B = 255;
            break;
        case 'W':
            *R = 255;
            *G = 255;
            *B = 255;
            break;
            

        default:
            *R = 0;
            *G = 0;
            *B = 0;
            break;
    }
}
/****************************************
* main
*
* sets up the communication between the  main mbed
* inits the leds to check if the leds are working properly
* continuosly checks for a command from the main mbed
* if new command received, then executes the appropriate function
*
****************************************/
int main()
{
    uint8_t R,G,B;
    strip.begin();
    init_grid();
    OSCmsg m;
    choosePattern Chooser;
    getColor(&R,&G,&B,"W");
    //Chooser.find("FF",255,0,0,500,2000);
    Chooser.find("FF",R,G,B,50,1000);
    pc.printf("Start----- Light COntroller !\r\n");

    OSCclass *c=new OSCclass;
    pc.baud(115200);

    

    while(1) {
        rxLen = rf_receive(rxBuffer, 128);
        if(rxLen > 0) {

            pc.printf("Received string %s \r\n",rxBuffer);
            std::vector<std::string> msg;
            /*split the buffer based on the delimiter ',' and save into extract*/
            msg = split(std::string(rxBuffer),'/',msg);
            
            if(msg[0]=="ledall"||msg[0]=="ledstrip1")
            { 
            std::vector<std::string> extract;
            extract = split(msg[2],',',extract);

            /*Display Patterns*/
            if(!extract[0].compare("A")) {
                std::string pattern = extract[1]; // pattern
                getColor(&R,&G,&B,extract[2]); //Set RGB value based on string
                uint32_t delay    = std::atoi(extract[3].c_str()); // delay
                uint32_t duration = std::atoi(extract[4].c_str()); // duration
                Chooser.find(pattern,R,G,B,delay,duration); // display the pattern if valid
            }
            if(!extract[0].compare("C")) {
                /*Turns off the LED*/
                for (int i=0; i < strip.numPixels(); i++) {
                    strip.setPixelColor(i, 0);  // turn all pixels off
                }
                strip.show();
            }
            }
        }
    }
}
