/*============================================================================
* Name        : led_patterns.cpp
* Author      : Srini and Jing
* Version     : v1.3
* Date        : 11/08/2014
* Copyright   : 
* Description : Defines all the functions which set the patterns of leds
*============================================================================*/

#include "led_patterns.h"    

#define ROWS 2          // Rows of leds; each seperate strip is considered as a row
#define COLS 26         // number of leds per row

/*global timer to mark the duration*/
Timer gTimer;

// Total leds used for light effects; ROWS * COLS
extern LPD8806  strip ;
extern int grid[ROWS][COLS]; // 

void begin()
{
        strip.begin();
}

/****************************************
* init_grid()
* Jing and Srini
* This is initiliazing the led Strips.
* The Led Strips are NOT daisy chained!
* Each strip is connected to Power Source.
* Currenly the support is for only 2 strips
*
****************************************/

void init_grid()
{
    int col;
    
    /*Address init for the first strip*/
    for(col = 0; col < COLS ; col++)
        grid[0][col] = COLS*0 + col;
        
    /*Address init for the second strip*/
    for(col = 0; col < COLS; col++)
        grid[1][col] = COLS*1 + col;
}

/****************************************
* clear
*
* shuts down all leds 
****************************************/
void clear()
{
    for (int x=0; x<(strip.numPixels()); x++)
        strip.setPixelColor(x, strip.Color(0,0,0));
    strip.show();
}

/****************************************
* wave
*
* creates a flow effect that is in sync with the super bowl touchdown scene; 
* the rgb value can be changed so that the color can match the color of the team that scored
* 
* Srini and Jing
*
* @param r      red color value
* @param g      green color  
* @param b      blue color   
* @param delay  delay between updating the led layout to "move the color" by 1 led
*
****************************************/
void wave(uint8_t r, uint8_t g, uint8_t b, uint32_t delay, uint32_t duration) {
    int i;
    /*Setting the pixels one at at time*/
    for (i=0; i < COLS; i++)
    {
        strip.setPixelColor(grid[0][i], strip.Color(r, g, b)); //strip 1
        strip.setPixelColor(grid[1][i], strip.Color(r, g, b)); // strip 2
        strip.show();
        wait_ms(delay);
    }
    /*Shutting down the leds*/
    for (i=0; i<((strip.numPixels())); i++)
        strip.setPixelColor(i, strip.Color(0,0,0));
    strip.show();
}

/****************************************
* backward_wave
*
* creates a flow effect that is in sync with the super bowl touchdown scene; 
* the rgb value can be changed so that the color can match the color of the team that scored
* 
* Srini and Jing
*
* @param r      red color value
* @param g      green color  
* @param b      blue color   
* @param delay  delay between updating the led layout to "move the color" by 1 led
*
****************************************/

void backward_wave(uint8_t r, uint8_t g, uint8_t b, uint32_t delay, uint32_t duration) {
    int i;
    /*Setting the pixels one at at time*/
    for (i=COLS; i > 0; i--)
    {
        strip.setPixelColor(grid[0][i], strip.Color(r, g, b));  // strip 1
        strip.setPixelColor(grid[1][i], strip.Color(r, g, b));  //strip 2
        strip.show();
        wait_ms(delay);
    }
    /*Shutting down the leds*/
    for (i=0; i<((strip.numPixels())); i++)
        strip.setPixelColor(i, strip.Color(0,0,0));
    strip.show();
}

/****************************************
* flash
*
* The led strip flashes the light with the mentioned time-period and duration
* 
* Srini and Jing
*
* @param r      red color value
* @param g      green color  
* @param b      blue color   
* @param delay  delay between every flash in milliseconds duty cycle is 50%
* @param duration How long should the flash effect be active in milliseconds
****************************************/
void flash(uint8_t r, uint8_t g, uint8_t b, uint32_t delay, uint32_t duration) {
    int i;
    gTimer.start(); // begin timer
    
    /*While the time is less than the duration specified keep flashing*/
    while(gTimer.read_ms() < duration)
    {
        for (i= 0; i < COLS; i++)
        {
            strip.setPixelColor(grid[0][i], strip.Color(r, g, b)); //strip 1
            strip.setPixelColor(grid[1][i], strip.Color(r, g, b)); // strip 2       
        }
            strip.show();
            wait_ms(delay);
    
        /*Shutting down the leds*/
        for (i=0; i<((strip.numPixels())); i++)
            strip.setPixelColor(i, strip.Color(0,0,0));
        strip.show();
        wait_ms(delay);
    }
    gTimer.stop();
    gTimer.reset();
}

/****************************************
* back_and_forth
*
* The led strip produces waves in both forward and backward directions consecutively
* 
* Srini and Jing
*
* @param r      red color value
* @param g      green color  
* @param b      blue color   
* @param delay  delay between updating the led layout to "move the color" by 1 led
*
****************************************/

void back_and_forth(uint8_t r, uint8_t g, uint8_t b, uint32_t delay, uint32_t duration) {
 wave( r,  g,  b,  delay,duration);
 backward_wave( r,  g,  b,  delay, duration);
}
 

/****************************************
* rise_and_fall
*
* The led strip produces waves in  forward direction and switches of leds backwards as a wave
* 
* Srini and Jing
*
* @param r      red color value
* @param g      green color  
* @param b      blue color   
* @param delay  delay between updating the led layout to "move the color" by 1 led
*
****************************************/
 void rise_and_fall(uint8_t r, uint8_t g, uint8_t b,uint32_t delay, uint32_t duration) {

    for (int i=0; i < COLS; i++)
    {
        strip.setPixelColor(grid[0][i], strip.Color(r, g, b));  // strip 1
        strip.setPixelColor(grid[1][i], strip.Color(r, g, b));  //strip 2
        strip.show();
        wait_ms(delay);
        
    }
    /*Shutting down the leds*/
    for (int i=COLS; i > 0; i--)
    {
        strip.setPixelColor(grid[0][i], strip.Color(0, 0, 0));  // strip 1
        strip.setPixelColor(grid[1][i], strip.Color(0, 0, 0));  //strip 2
        strip.show();
        wait_ms(delay);
        
    }
}

